<?php

namespace LightrCommerce\Plugin\Widget\Elementor;

use LightrCommerce\BigCommerce\Core as Api;
use Elementor\Controls_Manager;

class SearchBar extends BaseWidget {

    const CODE = 'SearchBar';

    public function get_icon() {
        return 'eicon-search-results';
    }

    protected function _register_controls() {
        $this->start_controls_section('section_content', [
            'label' => 'Search Bar',
            'tab' => Controls_Manager::TAB_CONTENT,
        ]);

        $this->add_control('display', [
            'label' => 'Display',
            'type' => Controls_Manager::SELECT,
            'options' => ['searchbar' => 'Search Bar', 'dialog' => 'Dialog'],
            'default' => 'searchbar',
        ]);
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $this->printTemplate(['display' => $settings['display']]);
    }
}
