<?php

// THIS ELEMENT SHOULD PRINT THE SAME OPTIONS AS The category component, but without sidebar navigation / title and headers.

namespace LightrCommerce\Plugin\Widget\Elementor;

use LightrCommerce\BigCommerce\Core as Api;
use Elementor\Controls_Manager;

class ProductList extends BaseWidget {

    const CODE = 'ProductList';

    public function get_icon() {
        return 'eicon-products-archive';
    }

    protected function _register_controls() {
        $this->start_controls_section('section_content', [
            'label' => 'Category',
            'tab' => Controls_Manager::TAB_CONTENT,
        ]);

        $this->add_control('category', [
            'label' => 'Category',
            'type' => Controls_Manager::SELECT,
            'options' => $this->getCategoryOptions(),
            'default' => '0',
        ]);

        $this->end_controls_section();
    }

    private function getCategoryOptions($children = null) {
        if (!$children) {
            $categories = Api::getCategories();
            $options = [0 => 'Select Category'];
        } else {
            $categories = $children;
        }
        foreach ($categories as $category) {
            $options[$category->entityId] = $category->name;
            if ($category->hasChildren) {
                $options += $this->getCategoryOptions($category->children);
            }
        }
        return $options;
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $this->printTemplate(['categoryId' => $settings['category']]);
    }
}
