<?php

namespace LightrCommerce\Plugin\Widget\Elementor;

use LightrCommerce\BigCommerce\Core as Api;
use Elementor\Controls_Manager;

class ProductFullDetail extends BaseWidget {

    const CODE = 'ProductFullDetail';

    public function get_icon() {
        return 'eicon-single-product';
    }

    protected function _register_controls() {
        $this->start_controls_section('section_content', [
            'label' => 'Catalog',
            'tab' => Controls_Manager::TAB_CONTENT,
        ]);

        $this->add_control('product', [
            'label' => 'Product',
            'type' => Controls_Manager::SELECT,
            'options' => $this->getProductOptions(),
            'default' => '0',
        ]);

        $this->end_controls_section();
    }

    private function getProductOptions() {
        $products = Api::getProducts();
        $options = [0 => 'Select Product'];
        foreach ($products as $product) {
            $options[$product->entityId] = $product->name;
        }
        return $options;
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $this->printTemplate(['productId' => $settings['product']]);
    }
}
