<?php

namespace LightrCommerce\Plugin\Widget\Elementor;

use LightrCommerce\BigCommerce\Core as Api;
use Elementor\Controls_Manager;

class CategoryProducts extends BaseWidget {

    const CODE = 'CategoryProducts';

    public function get_icon() {
        return 'eicon-product-categories';
    }

    protected function _register_controls() {
        $this->start_controls_section('section_content', [
            'label' => __('Products from a category', 'lightrcommerce'),
            'tab' => Controls_Manager::TAB_CONTENT,
        ]);

        $options = $this->getCategoryOptions();
        
        // select the first category by default
        $default = count($options) ? array_keys($options)[0] : '0';
        
        $options[0] = __('-- Select category --', 'lightrcommerce');

        $this->add_control('category', [
            'label' => __('Select the category', 'lightrcommerce'),
            'type' => Controls_Manager::SELECT,
            'options' => $options,
            'default' => $default
        ]);

        $this->add_control('limit', [
            'type' => \Elementor\Controls_Manager::NUMBER,
            'label' => __('Maximum number of products to display', 'lightrcommerce'),
            'min' => 1,
            'step' => 1,
            'default' => 4,
        ]);

        $this->end_controls_section();
    }

    private function getCategoryOptions($children = null): array {
        if (!$children) {
            $categories = Api::getCategories();
        } else {
            $categories = $children;
        }
        foreach ($categories as $category) {
            $options[$category->entityId] = $category->name;
            if ($category->hasChildren) {
                $options += $this->getCategoryOptions($category->children);
            }
        }
        return $options;
    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        if ($settings['category']) {
            $this->printTemplate([
                'categoryId' => $settings['category'],
                'limit' => $settings['limit'],
            ]);
        } else {
            esc_html_e('You need to select a category in the settings of this widget.', 'lightrcommerce');
        }
    }
}
