<?php

namespace LightrCommerce\Plugin\Widget\Elementor;

use LightrCommerce\BigCommerce\Core as Api;
use LightrCommerce\Plugin;

class BaseWidget extends \Elementor\Widget_Base {

    protected $config;

    public function get_name() {
        return 'lightrcommerce_' . $this->getConfig()->code;
    }

    public function get_title() {
        return $this->getConfig()->name;
    }

    public function get_icon() {
        return 'eicon-image';
    }

    public function get_categories() {
        return ['lightrcommerce'];
    }

    public function get_keywords() {
        return [];
    }

    protected function is_dynamic_content(): bool {
        return true;
    }

    protected function printTemplate(array $parameters = []) {
        $endpoint = $this->config->endpoint;
        $queryString = '';

        // When there are parameters in config we need to add them to the endpoint
        foreach ($this->config->parameters ?? [] as $_parameter) {
            if ($_parameter->required ?? false) {
                if (!isset($parameters[$_parameter->code])) {
                    throw new \Exception(esc_html('Missing required parameter: ' . $_parameter->code));
                }
                $endpoint = str_replace(
                        ':' . $_parameter->code . '',
                        $parameters[$_parameter->code],
                        $endpoint
                );
            } else {
                $queryString = sprintf(
                        '%s=%s',
                        $_parameter->code,
                        urlencode($parameters[$_parameter->code])
                );
            }
        }

        $apiUrl = $endpoint . ($queryString ? '?' . $queryString : '');

        echo Api::getOutput($apiUrl); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
    }

    protected function getConfig() {
        if ($this->config == null) {
            $this->config = Plugin::getWidgetConfig(static::CODE);
        }
        return $this->config;
    }
}
