<?php

namespace LightrCommerce\Plugin;

use LightrCommerce\BigCommerce\Core as Api;
use LightrCommerce\Plugin;

class Widget extends \WP_Widget {

    protected $config;

    public function __construct() {
        $options = [
            'description' => esc_html($this->getConfig()->description ?? '', 'lightrcommerce'),
            'customize_selective_refresh' => true,
        ];

        parent::__construct(
                $this->getConfig()->code,
                $this->getConfig()->name,
                $options
        );
    }

    /**
     * Outputs the content of the widget
     *
     * @param array $args
     * @param array $instance
     */
    public function widget($args, $instance) {
        return 'base output';
    }

    /**
     * Outputs the options form on admin
     *
     * @param array $instance The widget options
     */
    public function form($instance) {
    }

    /**
     * Processing widget options on save
     *
     * @param array $new_instance The new options
     * @param array $old_instance The previous options
     *
     * @return array
     */
    public function update($new_instance, $old_instance) {
        
    }

    protected function printTemplate(array $parameters = []) {
        $endpoint = $this->config->endpoint;

        // When there are parameters in config we need to add them to the endpoint
        if (isset($this->config->parameters)) {
            foreach ($this->config->parameters as $_parameter) {
                if ($_parameter->required) {
                    if (!isset($parameters[$_parameter->code])) {
                        throw new \Exception(esc_html('Missing required parameter: ' . $_parameter->code));
                    }
                    $endpoint = str_replace(
                            ':' . $_parameter->code . '',
                            $parameters[$_parameter->code],
                            $endpoint
                    );
                }
            }
        }

        echo Api::getOutput($endpoint); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
    }

    protected function getConfig() {
        if (!$this->config) {
            $this->config = Plugin::getWidgetConfig(static::CODE);
        }
        return $this->config;
    }

}
