<?php

namespace LightrCommerce\Plugin\Api;

class BigCommerceApiService implements ApiServiceInterface {

    const CODE = 'bigcommerce';
    const NAME = 'BigCommerce';

    public function isAvailable(): bool {
        return true;
    }

    public function getCode(): string {
        return self::CODE;
    }

    public function getName(): string {
        return self::NAME;
    }

    public function getMiddlewareStatus(): int {
        
    }

    public function getServiceStatus(): int {
        
    }

    public function isMiddlewareActive(): bool {
        try {
            $response = \LightrCommerce\BigCommerce\Core::getApiResponse('config');
            $status = wp_remote_retrieve_response_code($response);
            
            if ($status == 200) {
                return true;
            }
            
            if ($response instanceof \WP_Error) {
                throw new \Exception(implode(PHP_EOL, $response->get_error_messages()));
            }
        } catch (\Exception $e) {
            error_log((string) $e);
            return false;
        }

        return false;
    }

    public function isServiceActive(): bool {
        return true;
    }

    public function isFrontendEnabled(): bool {
        return (bool) get_option('lightrcommerce_bc_frontend_enabled');
    }
}
