<?php

namespace LightrCommerce\BigCommerce;

class Helper {

    static function isValidPermanentUrl(string $permanentUrl): bool {
        return preg_match('#^https://store-[\w-]+\.mybigcommerce\.com$#', $permanentUrl);
    }

    static function isValidGraphQlUrl(string $url): bool {
        $response = wp_safe_remote_post($url);
        $status = wp_remote_retrieve_response_code($response);
        // we expect a 401 unauthorized response because we don't have yet credentials
        return $status == \WP_Http::UNAUTHORIZED;
    }

    static function parsePermanentStoreUrl(string $permanentUrl): ?\StdClass {
        if (!preg_match('#^https://store-([\w]+)(-(\d+))?\.mybigcommerce\.com#', $permanentUrl, $match)) {
            return null;
        }
        
        $storeHash = $match[1];
        $channelId = $match[2] ?? 1;
        
        $apiUrl = sprintf('https://api.bigcommerce.com/stores/%s/v3/', $storeHash);
        $graphqlUrl = $permanentUrl . '/graphql';
        
        return (object) [
            'channelId' => $channelId,
            'storeHash' => $storeHash,
            'apiUrl' => $apiUrl,
            'graphqlUrl' => $graphqlUrl
        ];
    }
}
