<?php
namespace LightrCommerce\BigCommerce\Catalog;
use LightrCommerce\BigCommerce\Core;
class Product extends Core {
    const PRODUCTS_ENDPOINT = 'catalog/products';

    public function getAllProducts(array $filters = []) {
        $endpoint = self::PRODUCTS_ENDPOINT;
        if (!empty($filters)) {
            $endpoint .= '?' . http_build_query($filters);
        }

        $response = $this->callBigCommerce($endpoint);
        $products = [];
        while (
            $response['status'] == 200 &&
            $response['data']->meta->pagination->current_page <
                $response['data']->meta->pagination->total_pages
        ) {
            $products = array_merge($products, $response['data']->data);
            $endpoint = self::PRODUCTS_ENDPOINT . $response['data']->meta->pagination->links->next;
            $response = $this->callBigCommerce($endpoint);
        }
        return $products;
    }
}
