<?php

/**
 * Plugin Name: LightR Commerce
 * Description: This plugin brings the future of e-commerce your WordPress with seamless BigCommerce integration. Activate to enjoy headless, composable setup, offering unparalleled customization and performance for your online store.
 * Plugin URI: https://lightrcommerce.com/?utm_source=wp-plugins&utm_campaign=plugin-uri&utm_medium=wp-dash
 * Version: 1.0.11
 * Author: Young-dogs
 * Author URI: https://www.young-dogs.com?utm_source=wp-plugins&utm_campaign=plugin-uri&utm_medium=wp-dash
 * Requires PHP: 7.4
 * Text Domain: lightrcommerce
 * Domain Path: /languages/
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 *
 * @package YoungDogs-LightrCommerce
 */
if (!defined('ABSPATH')) {
    // exit if accessed directly
    exit;
}

define('LIGHTRCOMMERCE_VERSION', '1.0.11');
define('LIGHTRCOMMERCE_PHP_MIN_VERSION', '7.4');
define('LIGHTRCOMMERCE_WP_MIN_VERSION', '6.0');
define('LIGHTRCOMMERCE_URL', plugins_url('/', __FILE__));
define('LIGHTRCOMMERCE_PLUGIN_BASE', plugin_basename(__FILE__));
define('LIGHTRCOMMERCE_PATH', plugin_dir_path(__FILE__));
define('LIGHTRCOMMERCE_ASSETS_PATH', LIGHTRCOMMERCE_PATH . 'src/assets');
define('LIGHTRCOMMERCE_ASSETS_URL', LIGHTRCOMMERCE_URL . 'src/assets');
define('LIGHTRCOMMERCE_TEMPLATE_PATH', LIGHTRCOMMERCE_PATH . 'src/templates');

/**
 * Load LightrCommerce textdomain.
 * 
 * @return void
 */
add_action('plugins_loaded', function () {
    load_plugin_textdomain('lightrcommerce');
});

use LightrCommerce\Plugin;

if (version_compare(PHP_VERSION, LIGHTRCOMMERCE_PHP_MIN_VERSION, '<')) {
    add_action('admin_notices', 'lightrcommerce_wrong_php_version');
} elseif (version_compare(get_bloginfo('version'), LIGHTRCOMMERCE_WP_MIN_VERSION, '<')) {
    add_action('admin_notices', 'lightrcommerce_wrong_wp_version');
} else {
    require LIGHTRCOMMERCE_PATH . 'src/Plugin.php';
    $plugin = new Plugin();
}

function lightrcommerce_wrong_php_version() {
    include LIGHTRCOMMERCE_TEMPLATE_PATH . '/partials/invalid_php_version.php';
}

function lightrcommerce_wrong_wp_version() {
    include LIGHTRCOMMERCE_TEMPLATE_PATH . '/partials/invalid_wordpress_version.php';
}
