document.addEventListener('DOMContentLoaded', () => {
    const handleOpenCartEvent = (e) => {
        e.preventDefault();
        window.lightrcommerce.openCart();
    };

    [...document.querySelectorAll('[data-lightrcommerce-trigger="cart"]')].forEach((element) =>
        element.addEventListener('click', handleOpenCartEvent)
    );

    document.addEventListener('cartcount', (e) => {
        const { totalQuantity } = e.detail || '';
        [...document.querySelectorAll('[data-lightrcommerce-content="cartcount"]')].forEach((element) => {
            let container = element.querySelector('span.lightrcommerce-counter');
            if (!container) {
                container = document.createElement('span');
                container.classList.add('lightrcommerce-counter');
                element.appendChild(container);
            }
            container.innerHTML = totalQuantity;
        });
    });
});
