<?php
/**
 * States
 *
 * Returns an array of country states. This deprecates and replaces the /states/ directory found in older versions.
 *
 * States should be defined in English and translated native through localisation files.
 *
 * Country codes and states (or province) names should follow the Unicode CLDR recommendation (https://cldr.unicode.org/translation/displaynames/countryregion-territory-names).
 *
 * Countries defined with empty arrays have no states. These should also be defined in countries-address-info.php to mark the state field as not required and hidden.
 *
 * @package WooCommerce\i18n
 * @version 3.8.0
 */

defined( 'ABSPATH' ) || exit;

return array(
	'AF' => array(),
	'AL' => array( // Albanian states.
		'AL-01' => __( 'Berat', 'lifterlms' ),
		'AL-09' => __( 'Dibër', 'lifterlms' ),
		'AL-02' => __( 'Durrës', 'lifterlms' ),
		'AL-03' => __( 'Elbasan', 'lifterlms' ),
		'AL-04' => __( 'Fier', 'lifterlms' ),
		'AL-05' => __( 'Gjirokastër', 'lifterlms' ),
		'AL-06' => __( 'Korçë', 'lifterlms' ),
		'AL-07' => __( 'Kukës', 'lifterlms' ),
		'AL-08' => __( 'Lezhë', 'lifterlms' ),
		'AL-10' => __( 'Shkodër', 'lifterlms' ),
		'AL-11' => __( 'Tirana', 'lifterlms' ),
		'AL-12' => __( 'Vlorë', 'lifterlms' ),
	),
	'AO' => array( // Angolan states.
		'BGO' => __( 'Bengo', 'lifterlms' ),
		'BLU' => __( 'Benguela', 'lifterlms' ),
		'BIE' => __( 'Bié', 'lifterlms' ),
		'CAB' => __( 'Cabinda', 'lifterlms' ),
		'CNN' => __( 'Cunene', 'lifterlms' ),
		'HUA' => __( 'Huambo', 'lifterlms' ),
		'HUI' => __( 'Huíla', 'lifterlms' ),
		'CCU' => __( 'Kuando Kubango', 'lifterlms' ),
		'CNO' => __( 'Kwanza-Norte', 'lifterlms' ),
		'CUS' => __( 'Kwanza-Sul', 'lifterlms' ),
		'LUA' => __( 'Luanda', 'lifterlms' ),
		'LNO' => __( 'Lunda-Norte', 'lifterlms' ),
		'LSU' => __( 'Lunda-Sul', 'lifterlms' ),
		'MAL' => __( 'Malanje', 'lifterlms' ),
		'MOX' => __( 'Moxico', 'lifterlms' ),
		'NAM' => __( 'Namibe', 'lifterlms' ),
		'UIG' => __( 'Uíge', 'lifterlms' ),
		'ZAI' => __( 'Zaire', 'lifterlms' ),
	),
	'AR' => array( // Argentinian provinces.
		'C' => __( 'Ciudad Autónoma de Buenos Aires', 'lifterlms' ),
		'B' => __( 'Buenos Aires', 'lifterlms' ),
		'K' => __( 'Catamarca', 'lifterlms' ),
		'H' => __( 'Chaco', 'lifterlms' ),
		'U' => __( 'Chubut', 'lifterlms' ),
		'X' => __( 'Córdoba', 'lifterlms' ),
		'W' => __( 'Corrientes', 'lifterlms' ),
		'E' => __( 'Entre Ríos', 'lifterlms' ),
		'P' => __( 'Formosa', 'lifterlms' ),
		'Y' => __( 'Jujuy', 'lifterlms' ),
		'L' => __( 'La Pampa', 'lifterlms' ),
		'F' => __( 'La Rioja', 'lifterlms' ),
		'M' => __( 'Mendoza', 'lifterlms' ),
		'N' => __( 'Misiones', 'lifterlms' ),
		'Q' => __( 'Neuquén', 'lifterlms' ),
		'R' => __( 'Río Negro', 'lifterlms' ),
		'A' => __( 'Salta', 'lifterlms' ),
		'J' => __( 'San Juan', 'lifterlms' ),
		'D' => __( 'San Luis', 'lifterlms' ),
		'Z' => __( 'Santa Cruz', 'lifterlms' ),
		'S' => __( 'Santa Fe', 'lifterlms' ),
		'G' => __( 'Santiago del Estero', 'lifterlms' ),
		'V' => __( 'Tierra del Fuego', 'lifterlms' ),
		'T' => __( 'Tucumán', 'lifterlms' ),
	),
	'AT' => array(),
	'AU' => array( // Australian states.
		'ACT' => __( 'Australian Capital Territory', 'lifterlms' ),
		'NSW' => __( 'New South Wales', 'lifterlms' ),
		'NT'  => __( 'Northern Territory', 'lifterlms' ),
		'QLD' => __( 'Queensland', 'lifterlms' ),
		'SA'  => __( 'South Australia', 'lifterlms' ),
		'TAS' => __( 'Tasmania', 'lifterlms' ),
		'VIC' => __( 'Victoria', 'lifterlms' ),
		'WA'  => __( 'Western Australia', 'lifterlms' ),
	),
	'AX' => array(),
	'BD' => array( // Bangladeshi districts.
		'BD-05' => __( 'Bagerhat', 'lifterlms' ),
		'BD-01' => __( 'Bandarban', 'lifterlms' ),
		'BD-02' => __( 'Barguna', 'lifterlms' ),
		'BD-06' => __( 'Barishal', 'lifterlms' ),
		'BD-07' => __( 'Bhola', 'lifterlms' ),
		'BD-03' => __( 'Bogura', 'lifterlms' ),
		'BD-04' => __( 'Brahmanbaria', 'lifterlms' ),
		'BD-09' => __( 'Chandpur', 'lifterlms' ),
		'BD-10' => __( 'Chattogram', 'lifterlms' ),
		'BD-12' => __( 'Chuadanga', 'lifterlms' ),
		'BD-11' => __( "Cox's Bazar", 'lifterlms' ),
		'BD-08' => __( 'Cumilla', 'lifterlms' ),
		'BD-13' => __( 'Dhaka', 'lifterlms' ),
		'BD-14' => __( 'Dinajpur', 'lifterlms' ),
		'BD-15' => __( 'Faridpur ', 'lifterlms' ),
		'BD-16' => __( 'Feni', 'lifterlms' ),
		'BD-19' => __( 'Gaibandha', 'lifterlms' ),
		'BD-18' => __( 'Gazipur', 'lifterlms' ),
		'BD-17' => __( 'Gopalganj', 'lifterlms' ),
		'BD-20' => __( 'Habiganj', 'lifterlms' ),
		'BD-21' => __( 'Jamalpur', 'lifterlms' ),
		'BD-22' => __( 'Jashore', 'lifterlms' ),
		'BD-25' => __( 'Jhalokati', 'lifterlms' ),
		'BD-23' => __( 'Jhenaidah', 'lifterlms' ),
		'BD-24' => __( 'Joypurhat', 'lifterlms' ),
		'BD-29' => __( 'Khagrachhari', 'lifterlms' ),
		'BD-27' => __( 'Khulna', 'lifterlms' ),
		'BD-26' => __( 'Kishoreganj', 'lifterlms' ),
		'BD-28' => __( 'Kurigram', 'lifterlms' ),
		'BD-30' => __( 'Kushtia', 'lifterlms' ),
		'BD-31' => __( 'Lakshmipur', 'lifterlms' ),
		'BD-32' => __( 'Lalmonirhat', 'lifterlms' ),
		'BD-36' => __( 'Madaripur', 'lifterlms' ),
		'BD-37' => __( 'Magura', 'lifterlms' ),
		'BD-33' => __( 'Manikganj ', 'lifterlms' ),
		'BD-39' => __( 'Meherpur', 'lifterlms' ),
		'BD-38' => __( 'Moulvibazar', 'lifterlms' ),
		'BD-35' => __( 'Munshiganj', 'lifterlms' ),
		'BD-34' => __( 'Mymensingh', 'lifterlms' ),
		'BD-48' => __( 'Naogaon', 'lifterlms' ),
		'BD-43' => __( 'Narail', 'lifterlms' ),
		'BD-40' => __( 'Narayanganj', 'lifterlms' ),
		'BD-42' => __( 'Narsingdi', 'lifterlms' ),
		'BD-44' => __( 'Natore', 'lifterlms' ),
		'BD-45' => __( 'Nawabganj', 'lifterlms' ),
		'BD-41' => __( 'Netrakona', 'lifterlms' ),
		'BD-46' => __( 'Nilphamari', 'lifterlms' ),
		'BD-47' => __( 'Noakhali', 'lifterlms' ),
		'BD-49' => __( 'Pabna', 'lifterlms' ),
		'BD-52' => __( 'Panchagarh', 'lifterlms' ),
		'BD-51' => __( 'Patuakhali', 'lifterlms' ),
		'BD-50' => __( 'Pirojpur', 'lifterlms' ),
		'BD-53' => __( 'Rajbari', 'lifterlms' ),
		'BD-54' => __( 'Rajshahi', 'lifterlms' ),
		'BD-56' => __( 'Rangamati', 'lifterlms' ),
		'BD-55' => __( 'Rangpur', 'lifterlms' ),
		'BD-58' => __( 'Satkhira', 'lifterlms' ),
		'BD-62' => __( 'Shariatpur', 'lifterlms' ),
		'BD-57' => __( 'Sherpur', 'lifterlms' ),
		'BD-59' => __( 'Sirajganj', 'lifterlms' ),
		'BD-61' => __( 'Sunamganj', 'lifterlms' ),
		'BD-60' => __( 'Sylhet', 'lifterlms' ),
		'BD-63' => __( 'Tangail', 'lifterlms' ),
		'BD-64' => __( 'Thakurgaon', 'lifterlms' ),
	),
	'BE' => array(),
	'BG' => array( // Bulgarian states.
		'BG-01' => __( 'Blagoevgrad', 'lifterlms' ),
		'BG-02' => __( 'Burgas', 'lifterlms' ),
		'BG-08' => __( 'Dobrich', 'lifterlms' ),
		'BG-07' => __( 'Gabrovo', 'lifterlms' ),
		'BG-26' => __( 'Haskovo', 'lifterlms' ),
		'BG-09' => __( 'Kardzhali', 'lifterlms' ),
		'BG-10' => __( 'Kyustendil', 'lifterlms' ),
		'BG-11' => __( 'Lovech', 'lifterlms' ),
		'BG-12' => __( 'Montana', 'lifterlms' ),
		'BG-13' => __( 'Pazardzhik', 'lifterlms' ),
		'BG-14' => __( 'Pernik', 'lifterlms' ),
		'BG-15' => __( 'Pleven', 'lifterlms' ),
		'BG-16' => __( 'Plovdiv', 'lifterlms' ),
		'BG-17' => __( 'Razgrad', 'lifterlms' ),
		'BG-18' => __( 'Ruse', 'lifterlms' ),
		'BG-27' => __( 'Shumen', 'lifterlms' ),
		'BG-19' => __( 'Silistra', 'lifterlms' ),
		'BG-20' => __( 'Sliven', 'lifterlms' ),
		'BG-21' => __( 'Smolyan', 'lifterlms' ),
		'BG-23' => __( 'Sofia District', 'lifterlms' ),
		'BG-22' => __( 'Sofia', 'lifterlms' ),
		'BG-24' => __( 'Stara Zagora', 'lifterlms' ),
		'BG-25' => __( 'Targovishte', 'lifterlms' ),
		'BG-03' => __( 'Varna', 'lifterlms' ),
		'BG-04' => __( 'Veliko Tarnovo', 'lifterlms' ),
		'BG-05' => __( 'Vidin', 'lifterlms' ),
		'BG-06' => __( 'Vratsa', 'lifterlms' ),
		'BG-28' => __( 'Yambol', 'lifterlms' ),
	),
	'BH' => array(),
	'BI' => array(),
	'BJ' => array( // Beninese states.
		'AL' => __( 'Alibori', 'lifterlms' ),
		'AK' => __( 'Atakora', 'lifterlms' ),
		'AQ' => __( 'Atlantique', 'lifterlms' ),
		'BO' => __( 'Borgou', 'lifterlms' ),
		'CO' => __( 'Collines', 'lifterlms' ),
		'KO' => __( 'Kouffo', 'lifterlms' ),
		'DO' => __( 'Donga', 'lifterlms' ),
		'LI' => __( 'Littoral', 'lifterlms' ),
		'MO' => __( 'Mono', 'lifterlms' ),
		'OU' => __( 'Ouémé', 'lifterlms' ),
		'PL' => __( 'Plateau', 'lifterlms' ),
		'ZO' => __( 'Zou', 'lifterlms' ),
	),
	'BO' => array( // Bolivian states.
		'BO-B' => __( 'Beni', 'lifterlms' ),
		'BO-H' => __( 'Chuquisaca', 'lifterlms' ),
		'BO-C' => __( 'Cochabamba', 'lifterlms' ),
		'BO-L' => __( 'La Paz', 'lifterlms' ),
		'BO-O' => __( 'Oruro', 'lifterlms' ),
		'BO-N' => __( 'Pando', 'lifterlms' ),
		'BO-P' => __( 'Potosí', 'lifterlms' ),
		'BO-S' => __( 'Santa Cruz', 'lifterlms' ),
		'BO-T' => __( 'Tarija', 'lifterlms' ),
	),
	'BR' => array( // Brazilian states.
		'AC' => __( 'Acre', 'lifterlms' ),
		'AL' => __( 'Alagoas', 'lifterlms' ),
		'AP' => __( 'Amapá', 'lifterlms' ),
		'AM' => __( 'Amazonas', 'lifterlms' ),
		'BA' => __( 'Bahia', 'lifterlms' ),
		'CE' => __( 'Ceará', 'lifterlms' ),
		'DF' => __( 'Distrito Federal', 'lifterlms' ),
		'ES' => __( 'Espírito Santo', 'lifterlms' ),
		'GO' => __( 'Goiás', 'lifterlms' ),
		'MA' => __( 'Maranhão', 'lifterlms' ),
		'MT' => __( 'Mato Grosso', 'lifterlms' ),
		'MS' => __( 'Mato Grosso do Sul', 'lifterlms' ),
		'MG' => __( 'Minas Gerais', 'lifterlms' ),
		'PA' => __( 'Pará', 'lifterlms' ),
		'PB' => __( 'Paraíba', 'lifterlms' ),
		'PR' => __( 'Paraná', 'lifterlms' ),
		'PE' => __( 'Pernambuco', 'lifterlms' ),
		'PI' => __( 'Piauí', 'lifterlms' ),
		'RJ' => __( 'Rio de Janeiro', 'lifterlms' ),
		'RN' => __( 'Rio Grande do Norte', 'lifterlms' ),
		'RS' => __( 'Rio Grande do Sul', 'lifterlms' ),
		'RO' => __( 'Rondônia', 'lifterlms' ),
		'RR' => __( 'Roraima', 'lifterlms' ),
		'SC' => __( 'Santa Catarina', 'lifterlms' ),
		'SP' => __( 'São Paulo', 'lifterlms' ),
		'SE' => __( 'Sergipe', 'lifterlms' ),
		'TO' => __( 'Tocantins', 'lifterlms' ),
	),
	'CA' => array( // Canadian states.
		'AB' => __( 'Alberta', 'lifterlms' ),
		'BC' => __( 'British Columbia', 'lifterlms' ),
		'MB' => __( 'Manitoba', 'lifterlms' ),
		'NB' => __( 'New Brunswick', 'lifterlms' ),
		'NL' => __( 'Newfoundland and Labrador', 'lifterlms' ),
		'NT' => __( 'Northwest Territories', 'lifterlms' ),
		'NS' => __( 'Nova Scotia', 'lifterlms' ),
		'NU' => __( 'Nunavut', 'lifterlms' ),
		'ON' => __( 'Ontario', 'lifterlms' ),
		'PE' => __( 'Prince Edward Island', 'lifterlms' ),
		'QC' => __( 'Quebec', 'lifterlms' ),
		'SK' => __( 'Saskatchewan', 'lifterlms' ),
		'YT' => __( 'Yukon Territory', 'lifterlms' ),
	),
	'CH' => array( // Swiss cantons.
		'AG' => __( 'Aargau', 'lifterlms' ),
		'AR' => __( 'Appenzell Ausserrhoden', 'lifterlms' ),
		'AI' => __( 'Appenzell Innerrhoden', 'lifterlms' ),
		'BL' => __( 'Basel-Landschaft', 'lifterlms' ),
		'BS' => __( 'Basel-Stadt', 'lifterlms' ),
		'BE' => __( 'Bern', 'lifterlms' ),
		'FR' => __( 'Fribourg', 'lifterlms' ),
		'GE' => __( 'Geneva', 'lifterlms' ),
		'GL' => __( 'Glarus', 'lifterlms' ),
		'GR' => __( 'Graubünden', 'lifterlms' ),
		'JU' => __( 'Jura', 'lifterlms' ),
		'LU' => __( 'Luzern', 'lifterlms' ),
		'NE' => __( 'Neuchâtel', 'lifterlms' ),
		'NW' => __( 'Nidwalden', 'lifterlms' ),
		'OW' => __( 'Obwalden', 'lifterlms' ),
		'SH' => __( 'Schaffhausen', 'lifterlms' ),
		'SZ' => __( 'Schwyz', 'lifterlms' ),
		'SO' => __( 'Solothurn', 'lifterlms' ),
		'SG' => __( 'St. Gallen', 'lifterlms' ),
		'TG' => __( 'Thurgau', 'lifterlms' ),
		'TI' => __( 'Ticino', 'lifterlms' ),
		'UR' => __( 'Uri', 'lifterlms' ),
		'VS' => __( 'Valais', 'lifterlms' ),
		'VD' => __( 'Vaud', 'lifterlms' ),
		'ZG' => __( 'Zug', 'lifterlms' ),
		'ZH' => __( 'Zürich', 'lifterlms' ),
	),
	'CL' => array( // Chilean states.
		'CL-AI' => __( 'Aisén del General Carlos Ibañez del Campo', 'lifterlms' ),
		'CL-AN' => __( 'Antofagasta', 'lifterlms' ),
		'CL-AP' => __( 'Arica y Parinacota', 'lifterlms' ),
		'CL-AR' => __( 'La Araucanía', 'lifterlms' ),
		'CL-AT' => __( 'Atacama', 'lifterlms' ),
		'CL-BI' => __( 'Biobío', 'lifterlms' ),
		'CL-CO' => __( 'Coquimbo', 'lifterlms' ),
		'CL-LI' => __( 'Libertador General Bernardo O\'Higgins', 'lifterlms' ),
		'CL-LL' => __( 'Los Lagos', 'lifterlms' ),
		'CL-LR' => __( 'Los Ríos', 'lifterlms' ),
		'CL-MA' => __( 'Magallanes', 'lifterlms' ),
		'CL-ML' => __( 'Maule', 'lifterlms' ),
		'CL-NB' => __( 'Ñuble', 'lifterlms' ),
		'CL-RM' => __( 'Región Metropolitana de Santiago', 'lifterlms' ),
		'CL-TA' => __( 'Tarapacá', 'lifterlms' ),
		'CL-VS' => __( 'Valparaíso', 'lifterlms' ),
	),
	'CN' => array( // Chinese states.
		'CN1'  => __( 'Yunnan / 云南', 'lifterlms' ),
		'CN2'  => __( 'Beijing / 北京', 'lifterlms' ),
		'CN3'  => __( 'Tianjin / 天津', 'lifterlms' ),
		'CN4'  => __( 'Hebei / 河北', 'lifterlms' ),
		'CN5'  => __( 'Shanxi / 山西', 'lifterlms' ),
		'CN6'  => __( 'Inner Mongolia / 內蒙古', 'lifterlms' ),
		'CN7'  => __( 'Liaoning / 辽宁', 'lifterlms' ),
		'CN8'  => __( 'Jilin / 吉林', 'lifterlms' ),
		'CN9'  => __( 'Heilongjiang / 黑龙江', 'lifterlms' ),
		'CN10' => __( 'Shanghai / 上海', 'lifterlms' ),
		'CN11' => __( 'Jiangsu / 江苏', 'lifterlms' ),
		'CN12' => __( 'Zhejiang / 浙江', 'lifterlms' ),
		'CN13' => __( 'Anhui / 安徽', 'lifterlms' ),
		'CN14' => __( 'Fujian / 福建', 'lifterlms' ),
		'CN15' => __( 'Jiangxi / 江西', 'lifterlms' ),
		'CN16' => __( 'Shandong / 山东', 'lifterlms' ),
		'CN17' => __( 'Henan / 河南', 'lifterlms' ),
		'CN18' => __( 'Hubei / 湖北', 'lifterlms' ),
		'CN19' => __( 'Hunan / 湖南', 'lifterlms' ),
		'CN20' => __( 'Guangdong / 广东', 'lifterlms' ),
		'CN21' => __( 'Guangxi Zhuang / 广西壮族', 'lifterlms' ),
		'CN22' => __( 'Hainan / 海南', 'lifterlms' ),
		'CN23' => __( 'Chongqing / 重庆', 'lifterlms' ),
		'CN24' => __( 'Sichuan / 四川', 'lifterlms' ),
		'CN25' => __( 'Guizhou / 贵州', 'lifterlms' ),
		'CN26' => __( 'Shaanxi / 陕西', 'lifterlms' ),
		'CN27' => __( 'Gansu / 甘肃', 'lifterlms' ),
		'CN28' => __( 'Qinghai / 青海', 'lifterlms' ),
		'CN29' => __( 'Ningxia Hui / 宁夏', 'lifterlms' ),
		'CN30' => __( 'Macao / 澳门', 'lifterlms' ),
		'CN31' => __( 'Tibet / 西藏', 'lifterlms' ),
		'CN32' => __( 'Xinjiang / 新疆', 'lifterlms' ),
	),
	'CO' => array( // Colombian states.
		'CO-AMA' => __( 'Amazonas', 'lifterlms' ),
		'CO-ANT' => __( 'Antioquia', 'lifterlms' ),
		'CO-ARA' => __( 'Arauca', 'lifterlms' ),
		'CO-ATL' => __( 'Atlántico', 'lifterlms' ),
		'CO-BOL' => __( 'Bolívar', 'lifterlms' ),
		'CO-BOY' => __( 'Boyacá', 'lifterlms' ),
		'CO-CAL' => __( 'Caldas', 'lifterlms' ),
		'CO-CAQ' => __( 'Caquetá', 'lifterlms' ),
		'CO-CAS' => __( 'Casanare', 'lifterlms' ),
		'CO-CAU' => __( 'Cauca', 'lifterlms' ),
		'CO-CES' => __( 'Cesar', 'lifterlms' ),
		'CO-CHO' => __( 'Chocó', 'lifterlms' ),
		'CO-COR' => __( 'Córdoba', 'lifterlms' ),
		'CO-CUN' => __( 'Cundinamarca', 'lifterlms' ),
		'CO-DC' => __( 'Capital District', 'lifterlms' ),
		'CO-GUA' => __( 'Guainía', 'lifterlms' ),
		'CO-GUV' => __( 'Guaviare', 'lifterlms' ),
		'CO-HUI' => __( 'Huila', 'lifterlms' ),
		'CO-LAG' => __( 'La Guajira', 'lifterlms' ),
		'CO-MAG' => __( 'Magdalena', 'lifterlms' ),
		'CO-MET' => __( 'Meta', 'lifterlms' ),
		'CO-NAR' => __( 'Nariño', 'lifterlms' ),
		'CO-NSA' => __( 'Norte de Santander', 'lifterlms' ),
		'CO-PUT' => __( 'Putumayo', 'lifterlms' ),
		'CO-QUI' => __( 'Quindío', 'lifterlms' ),
		'CO-RIS' => __( 'Risaralda', 'lifterlms' ),
		'CO-SAN' => __( 'Santander', 'lifterlms' ),
		'CO-SAP' => __( 'San Andrés & Providencia', 'lifterlms' ),
		'CO-SUC' => __( 'Sucre', 'lifterlms' ),
		'CO-TOL' => __( 'Tolima', 'lifterlms' ),
		'CO-VAC' => __( 'Valle del Cauca', 'lifterlms' ),
		'CO-VAU' => __( 'Vaupés', 'lifterlms' ),
		'CO-VID' => __( 'Vichada', 'lifterlms' ),
	),
	'CR' => array( // Costa Rican states.
		'CR-A' => __( 'Alajuela', 'lifterlms' ),
		'CR-C' => __( 'Cartago', 'lifterlms' ),
		'CR-G' => __( 'Guanacaste', 'lifterlms' ),
		'CR-H' => __( 'Heredia', 'lifterlms' ),
		'CR-L' => __( 'Limón', 'lifterlms' ),
		'CR-P' => __( 'Puntarenas', 'lifterlms' ),
		'CR-SJ' => __( 'San José', 'lifterlms' ),
	),
	'CZ' => array(),
	'DE' => array( // German states.
		'DE-BW' => __( 'Baden-Württemberg', 'lifterlms' ),
		'DE-BY' => __( 'Bavaria', 'lifterlms' ),
		'DE-BE' => __( 'Berlin', 'lifterlms' ),
		'DE-BB' => __( 'Brandenburg', 'lifterlms' ),
		'DE-HB' => __( 'Bremen', 'lifterlms' ),
		'DE-HH' => __( 'Hamburg', 'lifterlms' ),
		'DE-HE' => __( 'Hesse', 'lifterlms' ),
		'DE-MV' => __( 'Mecklenburg-Vorpommern', 'lifterlms' ),
		'DE-NI' => __( 'Lower Saxony', 'lifterlms' ),
		'DE-NW' => __( 'North Rhine-Westphalia', 'lifterlms' ),
		'DE-RP' => __( 'Rhineland-Palatinate', 'lifterlms' ),
		'DE-SL' => __( 'Saarland', 'lifterlms' ),
		'DE-SN' => __( 'Saxony', 'lifterlms' ),
		'DE-ST' => __( 'Saxony-Anhalt', 'lifterlms' ),
		'DE-SH' => __( 'Schleswig-Holstein', 'lifterlms' ),
		'DE-TH' => __( 'Thuringia', 'lifterlms' ),
	),
	'DK' => array(),
	'DO' => array( // Dominican states.
		'DO-01' => __( 'Distrito Nacional', 'lifterlms' ),
		'DO-02' => __( 'Azua', 'lifterlms' ),
		'DO-03' => __( 'Baoruco', 'lifterlms' ),
		'DO-04' => __( 'Barahona', 'lifterlms' ),
		'DO-33' => __( 'Cibao Nordeste', 'lifterlms' ),
		'DO-34' => __( 'Cibao Noroeste', 'lifterlms' ),
		'DO-35' => __( 'Cibao Norte', 'lifterlms' ),
		'DO-36' => __( 'Cibao Sur', 'lifterlms' ),
		'DO-05' => __( 'Dajabón', 'lifterlms' ),
		'DO-06' => __( 'Duarte', 'lifterlms' ),
		'DO-08' => __( 'El Seibo', 'lifterlms' ),
		'DO-37' => __( 'El Valle', 'lifterlms' ),
		'DO-07' => __( 'Elías Piña', 'lifterlms' ),
		'DO-38' => __( 'Enriquillo', 'lifterlms' ),
		'DO-09' => __( 'Espaillat', 'lifterlms' ),
		'DO-30' => __( 'Hato Mayor', 'lifterlms' ),
		'DO-19' => __( 'Hermanas Mirabal', 'lifterlms' ),
		'DO-39' => __( 'Higüamo', 'lifterlms' ),
		'DO-10' => __( 'Independencia', 'lifterlms' ),
		'DO-11' => __( 'La Altagracia', 'lifterlms' ),
		'DO-12' => __( 'La Romana', 'lifterlms' ),
		'DO-13' => __( 'La Vega', 'lifterlms' ),
		'DO-14' => __( 'María Trinidad Sánchez', 'lifterlms' ),
		'DO-28' => __( 'Monseñor Nouel', 'lifterlms' ),
		'DO-15' => __( 'Monte Cristi', 'lifterlms' ),
		'DO-29' => __( 'Monte Plata', 'lifterlms' ),
		'DO-40' => __( 'Ozama', 'lifterlms' ),
		'DO-16' => __( 'Pedernales', 'lifterlms' ),
		'DO-17' => __( 'Peravia', 'lifterlms' ),
		'DO-18' => __( 'Puerto Plata', 'lifterlms' ),
		'DO-20' => __( 'Samaná', 'lifterlms' ),
		'DO-21' => __( 'San Cristóbal', 'lifterlms' ),
		'DO-31' => __( 'San José de Ocoa', 'lifterlms' ),
		'DO-22' => __( 'San Juan', 'lifterlms' ),
		'DO-23' => __( 'San Pedro de Macorís', 'lifterlms' ),
		'DO-24' => __( 'Sánchez Ramírez', 'lifterlms' ),
		'DO-25' => __( 'Santiago', 'lifterlms' ),
		'DO-26' => __( 'Santiago Rodríguez', 'lifterlms' ),
		'DO-32' => __( 'Santo Domingo', 'lifterlms' ),
		'DO-41' => __( 'Valdesia', 'lifterlms' ),
		'DO-27' => __( 'Valverde', 'lifterlms' ),
		'DO-42' => __( 'Yuma', 'lifterlms' ),
	),
	'DZ' => array( // Algerian states.
		'DZ-01' => __( 'Adrar', 'lifterlms' ),
		'DZ-02' => __( 'Chlef', 'lifterlms' ),
		'DZ-03' => __( 'Laghouat', 'lifterlms' ),
		'DZ-04' => __( 'Oum El Bouaghi', 'lifterlms' ),
		'DZ-05' => __( 'Batna', 'lifterlms' ),
		'DZ-06' => __( 'Béjaïa', 'lifterlms' ),
		'DZ-07' => __( 'Biskra', 'lifterlms' ),
		'DZ-08' => __( 'Béchar', 'lifterlms' ),
		'DZ-09' => __( 'Blida', 'lifterlms' ),
		'DZ-10' => __( 'Bouira', 'lifterlms' ),
		'DZ-11' => __( 'Tamanghasset', 'lifterlms' ),
		'DZ-12' => __( 'Tébessa', 'lifterlms' ),
		'DZ-13' => __( 'Tlemcen', 'lifterlms' ),
		'DZ-14' => __( 'Tiaret', 'lifterlms' ),
		'DZ-15' => __( 'Tizi Ouzou', 'lifterlms' ),
		'DZ-16' => __( 'Algiers', 'lifterlms' ),
		'DZ-17' => __( 'Djelfa', 'lifterlms' ),
		'DZ-18' => __( 'Jijel', 'lifterlms' ),
		'DZ-19' => __( 'Sétif', 'lifterlms' ),
		'DZ-20' => __( 'Saïda', 'lifterlms' ),
		'DZ-21' => __( 'Skikda', 'lifterlms' ),
		'DZ-22' => __( 'Sidi Bel Abbès', 'lifterlms' ),
		'DZ-23' => __( 'Annaba', 'lifterlms' ),
		'DZ-24' => __( 'Guelma', 'lifterlms' ),
		'DZ-25' => __( 'Constantine', 'lifterlms' ),
		'DZ-26' => __( 'Médéa', 'lifterlms' ),
		'DZ-27' => __( 'Mostaganem', 'lifterlms' ),
		'DZ-28' => __( 'M’Sila', 'lifterlms' ),
		'DZ-29' => __( 'Mascara', 'lifterlms' ),
		'DZ-30' => __( 'Ouargla', 'lifterlms' ),
		'DZ-31' => __( 'Oran', 'lifterlms' ),
		'DZ-32' => __( 'El Bayadh', 'lifterlms' ),
		'DZ-33' => __( 'Illizi', 'lifterlms' ),
		'DZ-34' => __( 'Bordj Bou Arréridj', 'lifterlms' ),
		'DZ-35' => __( 'Boumerdès', 'lifterlms' ),
		'DZ-36' => __( 'El Tarf', 'lifterlms' ),
		'DZ-37' => __( 'Tindouf', 'lifterlms' ),
		'DZ-38' => __( 'Tissemsilt', 'lifterlms' ),
		'DZ-39' => __( 'El Oued', 'lifterlms' ),
		'DZ-40' => __( 'Khenchela', 'lifterlms' ),
		'DZ-41' => __( 'Souk Ahras', 'lifterlms' ),
		'DZ-42' => __( 'Tipasa', 'lifterlms' ),
		'DZ-43' => __( 'Mila', 'lifterlms' ),
		'DZ-44' => __( 'Aïn Defla', 'lifterlms' ),
		'DZ-45' => __( 'Naama', 'lifterlms' ),
		'DZ-46' => __( 'Aïn Témouchent', 'lifterlms' ),
		'DZ-47' => __( 'Ghardaïa', 'lifterlms' ),
		'DZ-48' => __( 'Relizane', 'lifterlms' ),
	),
	'EE' => array(),
	'EC' => array( // Ecuadorian states.
		'EC-A' => __( 'Azuay', 'lifterlms' ),
		'EC-B' => __( 'Bolívar', 'lifterlms' ),
		'EC-F' => __( 'Cañar', 'lifterlms' ),
		'EC-C' => __( 'Carchi', 'lifterlms' ),
		'EC-H' => __( 'Chimborazo', 'lifterlms' ),
		'EC-X' => __( 'Cotopaxi', 'lifterlms' ),
		'EC-O' => __( 'El Oro', 'lifterlms' ),
		'EC-E' => __( 'Esmeraldas', 'lifterlms' ),
		'EC-W' => __( 'Galápagos', 'lifterlms' ),
		'EC-G' => __( 'Guayas', 'lifterlms' ),
		'EC-I' => __( 'Imbabura', 'lifterlms' ),
		'EC-L' => __( 'Loja', 'lifterlms' ),
		'EC-R' => __( 'Los Ríos', 'lifterlms' ),
		'EC-M' => __( 'Manabí', 'lifterlms' ),
		'EC-S' => __( 'Morona-Santiago', 'lifterlms' ),
		'EC-N' => __( 'Napo', 'lifterlms' ),
		'EC-D' => __( 'Orellana', 'lifterlms' ),
		'EC-Y' => __( 'Pastaza', 'lifterlms' ),
		'EC-P' => __( 'Pichincha', 'lifterlms' ),
		'EC-SE' => __( 'Santa Elena', 'lifterlms' ),
		'EC-SD' => __( 'Santo Domingo de los Tsáchilas', 'lifterlms' ),
		'EC-U' => __( 'Sucumbíos', 'lifterlms' ),
		'EC-T' => __( 'Tungurahua', 'lifterlms' ),
		'EC-Z' => __( 'Zamora-Chinchipe', 'lifterlms' ),
	),
	'EG' => array( // Egyptian states.
		'EGALX' => __( 'Alexandria', 'lifterlms' ),
		'EGASN' => __( 'Aswan', 'lifterlms' ),
		'EGAST' => __( 'Asyut', 'lifterlms' ),
		'EGBA'  => __( 'Red Sea', 'lifterlms' ),
		'EGBH'  => __( 'Beheira', 'lifterlms' ),
		'EGBNS' => __( 'Beni Suef', 'lifterlms' ),
		'EGC'   => __( 'Cairo', 'lifterlms' ),
		'EGDK'  => __( 'Dakahlia', 'lifterlms' ),
		'EGDT'  => __( 'Damietta', 'lifterlms' ),
		'EGFYM' => __( 'Faiyum', 'lifterlms' ),
		'EGGH'  => __( 'Gharbia', 'lifterlms' ),
		'EGGZ'  => __( 'Giza', 'lifterlms' ),
		'EGIS'  => __( 'Ismailia', 'lifterlms' ),
		'EGJS'  => __( 'South Sinai', 'lifterlms' ),
		'EGKB'  => __( 'Qalyubia', 'lifterlms' ),
		'EGKFS' => __( 'Kafr el-Sheikh', 'lifterlms' ),
		'EGKN'  => __( 'Qena', 'lifterlms' ),
		'EGLX'  => __( 'Luxor', 'lifterlms' ),
		'EGMN'  => __( 'Minya', 'lifterlms' ),
		'EGMNF' => __( 'Monufia', 'lifterlms' ),
		'EGMT'  => __( 'Matrouh', 'lifterlms' ),
		'EGPTS' => __( 'Port Said', 'lifterlms' ),
		'EGSHG' => __( 'Sohag', 'lifterlms' ),
		'EGSHR' => __( 'Al Sharqia', 'lifterlms' ),
		'EGSIN' => __( 'North Sinai', 'lifterlms' ),
		'EGSUZ' => __( 'Suez', 'lifterlms' ),
		'EGWAD' => __( 'New Valley', 'lifterlms' ),
	),
	'ES' => array( // Spanish states.
		'C'  => __( 'A Coruña', 'lifterlms' ),
		'VI' => __( 'Araba/Álava', 'lifterlms' ),
		'AB' => __( 'Albacete', 'lifterlms' ),
		'A'  => __( 'Alicante', 'lifterlms' ),
		'AL' => __( 'Almería', 'lifterlms' ),
		'O'  => __( 'Asturias', 'lifterlms' ),
		'AV' => __( 'Ávila', 'lifterlms' ),
		'BA' => __( 'Badajoz', 'lifterlms' ),
		'PM' => __( 'Baleares', 'lifterlms' ),
		'B'  => __( 'Barcelona', 'lifterlms' ),
		'BU' => __( 'Burgos', 'lifterlms' ),
		'CC' => __( 'Cáceres', 'lifterlms' ),
		'CA' => __( 'Cádiz', 'lifterlms' ),
		'S'  => __( 'Cantabria', 'lifterlms' ),
		'CS' => __( 'Castellón', 'lifterlms' ),
		'CE' => __( 'Ceuta', 'lifterlms' ),
		'CR' => __( 'Ciudad Real', 'lifterlms' ),
		'CO' => __( 'Córdoba', 'lifterlms' ),
		'CU' => __( 'Cuenca', 'lifterlms' ),
		'GI' => __( 'Girona', 'lifterlms' ),
		'GR' => __( 'Granada', 'lifterlms' ),
		'GU' => __( 'Guadalajara', 'lifterlms' ),
		'SS' => __( 'Gipuzkoa', 'lifterlms' ),
		'H'  => __( 'Huelva', 'lifterlms' ),
		'HU' => __( 'Huesca', 'lifterlms' ),
		'J'  => __( 'Jaén', 'lifterlms' ),
		'LO' => __( 'La Rioja', 'lifterlms' ),
		'GC' => __( 'Las Palmas', 'lifterlms' ),
		'LE' => __( 'León', 'lifterlms' ),
		'L'  => __( 'Lleida', 'lifterlms' ),
		'LU' => __( 'Lugo', 'lifterlms' ),
		'M'  => __( 'Madrid', 'lifterlms' ),
		'MA' => __( 'Málaga', 'lifterlms' ),
		'ML' => __( 'Melilla', 'lifterlms' ),
		'MU' => __( 'Murcia', 'lifterlms' ),
		'NA' => __( 'Navarra', 'lifterlms' ),
		'OR' => __( 'Ourense', 'lifterlms' ),
		'P'  => __( 'Palencia', 'lifterlms' ),
		'PO' => __( 'Pontevedra', 'lifterlms' ),
		'SA' => __( 'Salamanca', 'lifterlms' ),
		'TF' => __( 'Santa Cruz de Tenerife', 'lifterlms' ),
		'SG' => __( 'Segovia', 'lifterlms' ),
		'SE' => __( 'Sevilla', 'lifterlms' ),
		'SO' => __( 'Soria', 'lifterlms' ),
		'T'  => __( 'Tarragona', 'lifterlms' ),
		'TE' => __( 'Teruel', 'lifterlms' ),
		'TO' => __( 'Toledo', 'lifterlms' ),
		'V'  => __( 'Valencia', 'lifterlms' ),
		'VA' => __( 'Valladolid', 'lifterlms' ),
		'BI' => __( 'Biscay', 'lifterlms' ),
		'ZA' => __( 'Zamora', 'lifterlms' ),
		'Z'  => __( 'Zaragoza', 'lifterlms' ),
	),
	'ET' => array(),
	'FI' => array(),
	'FR' => array(),
	'GF' => array(),
	'GH' => array( // Ghanaian regions.
		'AF' => __( 'Ahafo', 'lifterlms' ),
		'AH' => __( 'Ashanti', 'lifterlms' ),
		'BA' => __( 'Brong-Ahafo', 'lifterlms' ),
		'BO' => __( 'Bono', 'lifterlms' ),
		'BE' => __( 'Bono East', 'lifterlms' ),
		'CP' => __( 'Central', 'lifterlms' ),
		'EP' => __( 'Eastern', 'lifterlms' ),
		'AA' => __( 'Greater Accra', 'lifterlms' ),
		'NE' => __( 'North East', 'lifterlms' ),
		'NP' => __( 'Northern', 'lifterlms' ),
		'OT' => __( 'Oti', 'lifterlms' ),
		'SV' => __( 'Savannah', 'lifterlms' ),
		'UE' => __( 'Upper East', 'lifterlms' ),
		'UW' => __( 'Upper West', 'lifterlms' ),
		'TV' => __( 'Volta', 'lifterlms' ),
		'WP' => __( 'Western', 'lifterlms' ),
		'WN' => __( 'Western North', 'lifterlms' ),
	),
	'GP' => array(),
	'GR' => array( // Greek regions.
		'I' => __( 'Attica', 'lifterlms' ),
		'A' => __( 'East Macedonia and Thrace', 'lifterlms' ),
		'B' => __( 'Central Macedonia', 'lifterlms' ),
		'C' => __( 'West Macedonia', 'lifterlms' ),
		'D' => __( 'Epirus', 'lifterlms' ),
		'E' => __( 'Thessaly', 'lifterlms' ),
		'F' => __( 'Ionian Islands', 'lifterlms' ),
		'G' => __( 'West Greece', 'lifterlms' ),
		'H' => __( 'Central Greece', 'lifterlms' ),
		'J' => __( 'Peloponnese', 'lifterlms' ),
		'K' => __( 'North Aegean', 'lifterlms' ),
		'L' => __( 'South Aegean', 'lifterlms' ),
		'M' => __( 'Crete', 'lifterlms' ),
	),
	'GT' => array( // Guatemalan states.
		'GT-AV' => __( 'Alta Verapaz', 'lifterlms' ),
		'GT-BV' => __( 'Baja Verapaz', 'lifterlms' ),
		'GT-CM' => __( 'Chimaltenango', 'lifterlms' ),
		'GT-CQ' => __( 'Chiquimula', 'lifterlms' ),
		'GT-PR' => __( 'El Progreso', 'lifterlms' ),
		'GT-ES' => __( 'Escuintla', 'lifterlms' ),
		'GT-GU' => __( 'Guatemala', 'lifterlms' ),
		'GT-HU' => __( 'Huehuetenango', 'lifterlms' ),
		'GT-IZ' => __( 'Izabal', 'lifterlms' ),
		'GT-JA' => __( 'Jalapa', 'lifterlms' ),
		'GT-JU' => __( 'Jutiapa', 'lifterlms' ),
		'GT-PE' => __( 'Petén', 'lifterlms' ),
		'GT-QZ' => __( 'Quetzaltenango', 'lifterlms' ),
		'GT-QC' => __( 'Quiché', 'lifterlms' ),
		'GT-RE' => __( 'Retalhuleu', 'lifterlms' ),
		'GT-SA' => __( 'Sacatepéquez', 'lifterlms' ),
		'GT-SM' => __( 'San Marcos', 'lifterlms' ),
		'GT-SR' => __( 'Santa Rosa', 'lifterlms' ),
		'GT-SO' => __( 'Sololá', 'lifterlms' ),
		'GT-SU' => __( 'Suchitepéquez', 'lifterlms' ),
		'GT-TO' => __( 'Totonicapán', 'lifterlms' ),
		'GT-ZA' => __( 'Zacapa', 'lifterlms' ),
	),
	'HK' => array( // Hong Kong states.
		'HONG KONG'       => __( 'Hong Kong Island', 'lifterlms' ),
		'KOWLOON'         => __( 'Kowloon', 'lifterlms' ),
		'NEW TERRITORIES' => __( 'New Territories', 'lifterlms' ),
	),
	'HN' => array( // Honduran states.
		'HN-AT' => __( 'Atlántida', 'lifterlms' ),
		'HN-IB' => __( 'Bay Islands', 'lifterlms' ),
		'HN-CH' => __( 'Choluteca', 'lifterlms' ),
		'HN-CL' => __( 'Colón', 'lifterlms' ),
		'HN-CM' => __( 'Comayagua', 'lifterlms' ),
		'HN-CP' => __( 'Copán', 'lifterlms' ),
		'HN-CR' => __( 'Cortés', 'lifterlms' ),
		'HN-EP' => __( 'El Paraíso', 'lifterlms' ),
		'HN-FM' => __( 'Francisco Morazán', 'lifterlms' ),
		'HN-GD' => __( 'Gracias a Dios', 'lifterlms' ),
		'HN-IN' => __( 'Intibucá', 'lifterlms' ),
		'HN-LE' => __( 'Lempira', 'lifterlms' ),
		'HN-LP' => __( 'La Paz', 'lifterlms' ),
		'HN-OC' => __( 'Ocotepeque', 'lifterlms' ),
		'HN-OL' => __( 'Olancho', 'lifterlms' ),
		'HN-SB' => __( 'Santa Bárbara', 'lifterlms' ),
		'HN-VA' => __( 'Valle', 'lifterlms' ),
		'HN-YO' => __( 'Yoro', 'lifterlms' ),
	),
	'HR' => array( // Croatian counties.
		'HR-01' => __( 'Zagreb County', 'lifterlms' ),
		'HR-02' => __( 'Krapina-Zagorje County', 'lifterlms' ),
		'HR-03' => __( 'Sisak-Moslavina County', 'lifterlms' ),
		'HR-04' => __( 'Karlovac County', 'lifterlms' ),
		'HR-05' => __( 'Varaždin County', 'lifterlms' ),
		'HR-06' => __( 'Koprivnica-Križevci County', 'lifterlms' ),
		'HR-07' => __( 'Bjelovar-Bilogora County', 'lifterlms' ),
		'HR-08' => __( 'Primorje-Gorski Kotar County', 'lifterlms' ),
		'HR-09' => __( 'Lika-Senj County', 'lifterlms' ),
		'HR-10' => __( 'Virovitica-Podravina County', 'lifterlms' ),
		'HR-11' => __( 'Požega-Slavonia County', 'lifterlms' ),
		'HR-12' => __( 'Brod-Posavina County', 'lifterlms' ),
		'HR-13' => __( 'Zadar County', 'lifterlms' ),
		'HR-14' => __( 'Osijek-Baranja County', 'lifterlms' ),
		'HR-15' => __( 'Šibenik-Knin County', 'lifterlms' ),
		'HR-16' => __( 'Vukovar-Srijem County', 'lifterlms' ),
		'HR-17' => __( 'Split-Dalmatia County', 'lifterlms' ),
		'HR-18' => __( 'Istria County', 'lifterlms' ),
		'HR-19' => __( 'Dubrovnik-Neretva County', 'lifterlms' ),
		'HR-20' => __( 'Međimurje County', 'lifterlms' ),
		'HR-21' => __( 'Zagreb City', 'lifterlms' ),
	),
	'HU' => array( // Hungarian states.
		'BK' => __( 'Bács-Kiskun', 'lifterlms' ),
		'BE' => __( 'Békés', 'lifterlms' ),
		'BA' => __( 'Baranya', 'lifterlms' ),
		'BZ' => __( 'Borsod-Abaúj-Zemplén', 'lifterlms' ),
		'BU' => __( 'Budapest', 'lifterlms' ),
		'CS' => __( 'Csongrád-Csanád', 'lifterlms' ),
		'FE' => __( 'Fejér', 'lifterlms' ),
		'GS' => __( 'Győr-Moson-Sopron', 'lifterlms' ),
		'HB' => __( 'Hajdú-Bihar', 'lifterlms' ),
		'HE' => __( 'Heves', 'lifterlms' ),
		'JN' => __( 'Jász-Nagykun-Szolnok', 'lifterlms' ),
		'KE' => __( 'Komárom-Esztergom', 'lifterlms' ),
		'NO' => __( 'Nógrád', 'lifterlms' ),
		'PE' => __( 'Pest', 'lifterlms' ),
		'SO' => __( 'Somogy', 'lifterlms' ),
		'SZ' => __( 'Szabolcs-Szatmár-Bereg', 'lifterlms' ),
		'TO' => __( 'Tolna', 'lifterlms' ),
		'VA' => __( 'Vas', 'lifterlms' ),
		'VE' => __( 'Veszprém', 'lifterlms' ),
		'ZA' => __( 'Zala', 'lifterlms' ),
	),
	'ID' => array( // Indonesian provinces.
		'AC' => __( 'Daerah Istimewa Aceh', 'lifterlms' ),
		'SU' => __( 'Sumatera Utara', 'lifterlms' ),
		'SB' => __( 'Sumatera Barat', 'lifterlms' ),
		'RI' => __( 'Riau', 'lifterlms' ),
		'KR' => __( 'Kepulauan Riau', 'lifterlms' ),
		'JA' => __( 'Jambi', 'lifterlms' ),
		'SS' => __( 'Sumatera Selatan', 'lifterlms' ),
		'BB' => __( 'Bangka Belitung', 'lifterlms' ),
		'BE' => __( 'Bengkulu', 'lifterlms' ),
		'LA' => __( 'Lampung', 'lifterlms' ),
		'JK' => __( 'DKI Jakarta', 'lifterlms' ),
		'JB' => __( 'Jawa Barat', 'lifterlms' ),
		'BT' => __( 'Banten', 'lifterlms' ),
		'JT' => __( 'Jawa Tengah', 'lifterlms' ),
		'JI' => __( 'Jawa Timur', 'lifterlms' ),
		'YO' => __( 'Daerah Istimewa Yogyakarta', 'lifterlms' ),
		'BA' => __( 'Bali', 'lifterlms' ),
		'NB' => __( 'Nusa Tenggara Barat', 'lifterlms' ),
		'NT' => __( 'Nusa Tenggara Timur', 'lifterlms' ),
		'KB' => __( 'Kalimantan Barat', 'lifterlms' ),
		'KT' => __( 'Kalimantan Tengah', 'lifterlms' ),
		'KI' => __( 'Kalimantan Timur', 'lifterlms' ),
		'KS' => __( 'Kalimantan Selatan', 'lifterlms' ),
		'KU' => __( 'Kalimantan Utara', 'lifterlms' ),
		'SA' => __( 'Sulawesi Utara', 'lifterlms' ),
		'ST' => __( 'Sulawesi Tengah', 'lifterlms' ),
		'SG' => __( 'Sulawesi Tenggara', 'lifterlms' ),
		'SR' => __( 'Sulawesi Barat', 'lifterlms' ),
		'SN' => __( 'Sulawesi Selatan', 'lifterlms' ),
		'GO' => __( 'Gorontalo', 'lifterlms' ),
		'MA' => __( 'Maluku', 'lifterlms' ),
		'MU' => __( 'Maluku Utara', 'lifterlms' ),
		'PA' => __( 'Papua', 'lifterlms' ),
		'PB' => __( 'Papua Barat', 'lifterlms' ),
	),
	'IE' => array( // Irish states.
		'CW' => __( 'Carlow', 'lifterlms' ),
		'CN' => __( 'Cavan', 'lifterlms' ),
		'CE' => __( 'Clare', 'lifterlms' ),
		'CO' => __( 'Cork', 'lifterlms' ),
		'DL' => __( 'Donegal', 'lifterlms' ),
		'D'  => __( 'Dublin', 'lifterlms' ),
		'G'  => __( 'Galway', 'lifterlms' ),
		'KY' => __( 'Kerry', 'lifterlms' ),
		'KE' => __( 'Kildare', 'lifterlms' ),
		'KK' => __( 'Kilkenny', 'lifterlms' ),
		'LS' => __( 'Laois', 'lifterlms' ),
		'LM' => __( 'Leitrim', 'lifterlms' ),
		'LK' => __( 'Limerick', 'lifterlms' ),
		'LD' => __( 'Longford', 'lifterlms' ),
		'LH' => __( 'Louth', 'lifterlms' ),
		'MO' => __( 'Mayo', 'lifterlms' ),
		'MH' => __( 'Meath', 'lifterlms' ),
		'MN' => __( 'Monaghan', 'lifterlms' ),
		'OY' => __( 'Offaly', 'lifterlms' ),
		'RN' => __( 'Roscommon', 'lifterlms' ),
		'SO' => __( 'Sligo', 'lifterlms' ),
		'TA' => __( 'Tipperary', 'lifterlms' ),
		'WD' => __( 'Waterford', 'lifterlms' ),
		'WH' => __( 'Westmeath', 'lifterlms' ),
		'WX' => __( 'Wexford', 'lifterlms' ),
		'WW' => __( 'Wicklow', 'lifterlms' ),
	),
	'IN' => array( // Indian states.
		'AP' => __( 'Andhra Pradesh', 'lifterlms' ),
		'AR' => __( 'Arunachal Pradesh', 'lifterlms' ),
		'AS' => __( 'Assam', 'lifterlms' ),
		'BR' => __( 'Bihar', 'lifterlms' ),
		'CT' => __( 'Chhattisgarh', 'lifterlms' ),
		'GA' => __( 'Goa', 'lifterlms' ),
		'GJ' => __( 'Gujarat', 'lifterlms' ),
		'HR' => __( 'Haryana', 'lifterlms' ),
		'HP' => __( 'Himachal Pradesh', 'lifterlms' ),
		'JK' => __( 'Jammu and Kashmir', 'lifterlms' ),
		'JH' => __( 'Jharkhand', 'lifterlms' ),
		'KA' => __( 'Karnataka', 'lifterlms' ),
		'KL' => __( 'Kerala', 'lifterlms' ),
		'LA' => __( 'Ladakh', 'lifterlms' ),
		'MP' => __( 'Madhya Pradesh', 'lifterlms' ),
		'MH' => __( 'Maharashtra', 'lifterlms' ),
		'MN' => __( 'Manipur', 'lifterlms' ),
		'ML' => __( 'Meghalaya', 'lifterlms' ),
		'MZ' => __( 'Mizoram', 'lifterlms' ),
		'NL' => __( 'Nagaland', 'lifterlms' ),
		'OD' => __( 'Odisha', 'lifterlms' ),
		'PB' => __( 'Punjab', 'lifterlms' ),
		'RJ' => __( 'Rajasthan', 'lifterlms' ),
		'SK' => __( 'Sikkim', 'lifterlms' ),
		'TN' => __( 'Tamil Nadu', 'lifterlms' ),
		'TS' => __( 'Telangana', 'lifterlms' ),
		'TR' => __( 'Tripura', 'lifterlms' ),
		'UK' => __( 'Uttarakhand', 'lifterlms' ),
		'UP' => __( 'Uttar Pradesh', 'lifterlms' ),
		'WB' => __( 'West Bengal', 'lifterlms' ),
		'AN' => __( 'Andaman and Nicobar Islands', 'lifterlms' ),
		'CH' => __( 'Chandigarh', 'lifterlms' ),
		'DN' => __( 'Dadra and Nagar Haveli', 'lifterlms' ),
		'DD' => __( 'Daman and Diu', 'lifterlms' ),
		'DL' => __( 'Delhi', 'lifterlms' ),
		'LD' => __( 'Lakshadeep', 'lifterlms' ),
		'PY' => __( 'Pondicherry (Puducherry)', 'lifterlms' ),
	),
	'IR' => array( // Iranian states.
		'KHZ' => __( 'Khuzestan (خوزستان)', 'lifterlms' ),
		'THR' => __( 'Tehran (تهران)', 'lifterlms' ),
		'ILM' => __( 'Ilaam (ایلام)', 'lifterlms' ),
		'BHR' => __( 'Bushehr (بوشهر)', 'lifterlms' ),
		'ADL' => __( 'Ardabil (اردبیل)', 'lifterlms' ),
		'ESF' => __( 'Isfahan (اصفهان)', 'lifterlms' ),
		'YZD' => __( 'Yazd (یزد)', 'lifterlms' ),
		'KRH' => __( 'Kermanshah (کرمانشاه)', 'lifterlms' ),
		'KRN' => __( 'Kerman (کرمان)', 'lifterlms' ),
		'HDN' => __( 'Hamadan (همدان)', 'lifterlms' ),
		'GZN' => __( 'Ghazvin (قزوین)', 'lifterlms' ),
		'ZJN' => __( 'Zanjan (زنجان)', 'lifterlms' ),
		'LRS' => __( 'Luristan (لرستان)', 'lifterlms' ),
		'ABZ' => __( 'Alborz (البرز)', 'lifterlms' ),
		'EAZ' => __( 'East Azarbaijan (آذربایجان شرقی)', 'lifterlms' ),
		'WAZ' => __( 'West Azarbaijan (آذربایجان غربی)', 'lifterlms' ),
		'CHB' => __( 'Chaharmahal and Bakhtiari (چهارمحال و بختیاری)', 'lifterlms' ),
		'SKH' => __( 'South Khorasan (خراسان جنوبی)', 'lifterlms' ),
		'RKH' => __( 'Razavi Khorasan (خراسان رضوی)', 'lifterlms' ),
		'NKH' => __( 'North Khorasan (خراسان شمالی)', 'lifterlms' ),
		'SMN' => __( 'Semnan (سمنان)', 'lifterlms' ),
		'FRS' => __( 'Fars (فارس)', 'lifterlms' ),
		'QHM' => __( 'Qom (قم)', 'lifterlms' ),
		'KRD' => __( 'Kurdistan / کردستان)', 'lifterlms' ),
		'KBD' => __( 'Kohgiluyeh and BoyerAhmad (کهگیلوییه و بویراحمد)', 'lifterlms' ),
		'GLS' => __( 'Golestan (گلستان)', 'lifterlms' ),
		'GIL' => __( 'Gilan (گیلان)', 'lifterlms' ),
		'MZN' => __( 'Mazandaran (مازندران)', 'lifterlms' ),
		'MKZ' => __( 'Markazi (مرکزی)', 'lifterlms' ),
		'HRZ' => __( 'Hormozgan (هرمزگان)', 'lifterlms' ),
		'SBN' => __( 'Sistan and Baluchestan (سیستان و بلوچستان)', 'lifterlms' ),
	),
	'IS' => array(),
	'IT' => array( // Italian provinces.
		'AG' => __( 'Agrigento', 'lifterlms' ),
		'AL' => __( 'Alessandria', 'lifterlms' ),
		'AN' => __( 'Ancona', 'lifterlms' ),
		'AO' => __( 'Aosta', 'lifterlms' ),
		'AR' => __( 'Arezzo', 'lifterlms' ),
		'AP' => __( 'Ascoli Piceno', 'lifterlms' ),
		'AT' => __( 'Asti', 'lifterlms' ),
		'AV' => __( 'Avellino', 'lifterlms' ),
		'BA' => __( 'Bari', 'lifterlms' ),
		'BT' => __( 'Barletta-Andria-Trani', 'lifterlms' ),
		'BL' => __( 'Belluno', 'lifterlms' ),
		'BN' => __( 'Benevento', 'lifterlms' ),
		'BG' => __( 'Bergamo', 'lifterlms' ),
		'BI' => __( 'Biella', 'lifterlms' ),
		'BO' => __( 'Bologna', 'lifterlms' ),
		'BZ' => __( 'Bolzano', 'lifterlms' ),
		'BS' => __( 'Brescia', 'lifterlms' ),
		'BR' => __( 'Brindisi', 'lifterlms' ),
		'CA' => __( 'Cagliari', 'lifterlms' ),
		'CL' => __( 'Caltanissetta', 'lifterlms' ),
		'CB' => __( 'Campobasso', 'lifterlms' ),
		'CE' => __( 'Caserta', 'lifterlms' ),
		'CT' => __( 'Catania', 'lifterlms' ),
		'CZ' => __( 'Catanzaro', 'lifterlms' ),
		'CH' => __( 'Chieti', 'lifterlms' ),
		'CO' => __( 'Como', 'lifterlms' ),
		'CS' => __( 'Cosenza', 'lifterlms' ),
		'CR' => __( 'Cremona', 'lifterlms' ),
		'KR' => __( 'Crotone', 'lifterlms' ),
		'CN' => __( 'Cuneo', 'lifterlms' ),
		'EN' => __( 'Enna', 'lifterlms' ),
		'FM' => __( 'Fermo', 'lifterlms' ),
		'FE' => __( 'Ferrara', 'lifterlms' ),
		'FI' => __( 'Firenze', 'lifterlms' ),
		'FG' => __( 'Foggia', 'lifterlms' ),
		'FC' => __( 'Forlì-Cesena', 'lifterlms' ),
		'FR' => __( 'Frosinone', 'lifterlms' ),
		'GE' => __( 'Genova', 'lifterlms' ),
		'GO' => __( 'Gorizia', 'lifterlms' ),
		'GR' => __( 'Grosseto', 'lifterlms' ),
		'IM' => __( 'Imperia', 'lifterlms' ),
		'IS' => __( 'Isernia', 'lifterlms' ),
		'SP' => __( 'La Spezia', 'lifterlms' ),
		'AQ' => __( "L'Aquila", 'lifterlms' ),
		'LT' => __( 'Latina', 'lifterlms' ),
		'LE' => __( 'Lecce', 'lifterlms' ),
		'LC' => __( 'Lecco', 'lifterlms' ),
		'LI' => __( 'Livorno', 'lifterlms' ),
		'LO' => __( 'Lodi', 'lifterlms' ),
		'LU' => __( 'Lucca', 'lifterlms' ),
		'MC' => __( 'Macerata', 'lifterlms' ),
		'MN' => __( 'Mantova', 'lifterlms' ),
		'MS' => __( 'Massa-Carrara', 'lifterlms' ),
		'MT' => __( 'Matera', 'lifterlms' ),
		'ME' => __( 'Messina', 'lifterlms' ),
		'MI' => __( 'Milano', 'lifterlms' ),
		'MO' => __( 'Modena', 'lifterlms' ),
		'MB' => __( 'Monza e della Brianza', 'lifterlms' ),
		'NA' => __( 'Napoli', 'lifterlms' ),
		'NO' => __( 'Novara', 'lifterlms' ),
		'NU' => __( 'Nuoro', 'lifterlms' ),
		'OR' => __( 'Oristano', 'lifterlms' ),
		'PD' => __( 'Padova', 'lifterlms' ),
		'PA' => __( 'Palermo', 'lifterlms' ),
		'PR' => __( 'Parma', 'lifterlms' ),
		'PV' => __( 'Pavia', 'lifterlms' ),
		'PG' => __( 'Perugia', 'lifterlms' ),
		'PU' => __( 'Pesaro e Urbino', 'lifterlms' ),
		'PE' => __( 'Pescara', 'lifterlms' ),
		'PC' => __( 'Piacenza', 'lifterlms' ),
		'PI' => __( 'Pisa', 'lifterlms' ),
		'PT' => __( 'Pistoia', 'lifterlms' ),
		'PN' => __( 'Pordenone', 'lifterlms' ),
		'PZ' => __( 'Potenza', 'lifterlms' ),
		'PO' => __( 'Prato', 'lifterlms' ),
		'RG' => __( 'Ragusa', 'lifterlms' ),
		'RA' => __( 'Ravenna', 'lifterlms' ),
		'RC' => __( 'Reggio Calabria', 'lifterlms' ),
		'RE' => __( 'Reggio Emilia', 'lifterlms' ),
		'RI' => __( 'Rieti', 'lifterlms' ),
		'RN' => __( 'Rimini', 'lifterlms' ),
		'RM' => __( 'Roma', 'lifterlms' ),
		'RO' => __( 'Rovigo', 'lifterlms' ),
		'SA' => __( 'Salerno', 'lifterlms' ),
		'SS' => __( 'Sassari', 'lifterlms' ),
		'SV' => __( 'Savona', 'lifterlms' ),
		'SI' => __( 'Siena', 'lifterlms' ),
		'SR' => __( 'Siracusa', 'lifterlms' ),
		'SO' => __( 'Sondrio', 'lifterlms' ),
		'SU' => __( 'Sud Sardegna', 'lifterlms' ),
		'TA' => __( 'Taranto', 'lifterlms' ),
		'TE' => __( 'Teramo', 'lifterlms' ),
		'TR' => __( 'Terni', 'lifterlms' ),
		'TO' => __( 'Torino', 'lifterlms' ),
		'TP' => __( 'Trapani', 'lifterlms' ),
		'TN' => __( 'Trento', 'lifterlms' ),
		'TV' => __( 'Treviso', 'lifterlms' ),
		'TS' => __( 'Trieste', 'lifterlms' ),
		'UD' => __( 'Udine', 'lifterlms' ),
		'VA' => __( 'Varese', 'lifterlms' ),
		'VE' => __( 'Venezia', 'lifterlms' ),
		'VB' => __( 'Verbano-Cusio-Ossola', 'lifterlms' ),
		'VC' => __( 'Vercelli', 'lifterlms' ),
		'VR' => __( 'Verona', 'lifterlms' ),
		'VV' => __( 'Vibo Valentia', 'lifterlms' ),
		'VI' => __( 'Vicenza', 'lifterlms' ),
		'VT' => __( 'Viterbo', 'lifterlms' ),
	),
	'IL' => array(),
	'IM' => array(),
	'JM' => array( // Jamaican parishes.
		'JM-01' => __( 'Kingston', 'lifterlms' ),
		'JM-02' => __( 'Saint Andrew', 'lifterlms' ),
		'JM-03' => __( 'Saint Thomas', 'lifterlms' ),
		'JM-04' => __( 'Portland', 'lifterlms' ),
		'JM-05' => __( 'Saint Mary', 'lifterlms' ),
		'JM-06' => __( 'Saint Ann', 'lifterlms' ),
		'JM-07' => __( 'Trelawny', 'lifterlms' ),
		'JM-08' => __( 'Saint James', 'lifterlms' ),
		'JM-09' => __( 'Hanover', 'lifterlms' ),
		'JM-10' => __( 'Westmoreland', 'lifterlms' ),
		'JM-11' => __( 'Saint Elizabeth', 'lifterlms' ),
		'JM-12' => __( 'Manchester', 'lifterlms' ),
		'JM-13' => __( 'Clarendon', 'lifterlms' ),
		'JM-14' => __( 'Saint Catherine', 'lifterlms' ),
	),

	/**
	 * Japanese states.
	 *
	 * English notation of prefectures conform to the notation of Japan Post.
	 * The suffix corresponds with the Japanese translation file.
	 */
	'JP' => array(
		'JP01' => __( 'Hokkaido', 'lifterlms' ),
		'JP02' => __( 'Aomori', 'lifterlms' ),
		'JP03' => __( 'Iwate', 'lifterlms' ),
		'JP04' => __( 'Miyagi', 'lifterlms' ),
		'JP05' => __( 'Akita', 'lifterlms' ),
		'JP06' => __( 'Yamagata', 'lifterlms' ),
		'JP07' => __( 'Fukushima', 'lifterlms' ),
		'JP08' => __( 'Ibaraki', 'lifterlms' ),
		'JP09' => __( 'Tochigi', 'lifterlms' ),
		'JP10' => __( 'Gunma', 'lifterlms' ),
		'JP11' => __( 'Saitama', 'lifterlms' ),
		'JP12' => __( 'Chiba', 'lifterlms' ),
		'JP13' => __( 'Tokyo', 'lifterlms' ),
		'JP14' => __( 'Kanagawa', 'lifterlms' ),
		'JP15' => __( 'Niigata', 'lifterlms' ),
		'JP16' => __( 'Toyama', 'lifterlms' ),
		'JP17' => __( 'Ishikawa', 'lifterlms' ),
		'JP18' => __( 'Fukui', 'lifterlms' ),
		'JP19' => __( 'Yamanashi', 'lifterlms' ),
		'JP20' => __( 'Nagano', 'lifterlms' ),
		'JP21' => __( 'Gifu', 'lifterlms' ),
		'JP22' => __( 'Shizuoka', 'lifterlms' ),
		'JP23' => __( 'Aichi', 'lifterlms' ),
		'JP24' => __( 'Mie', 'lifterlms' ),
		'JP25' => __( 'Shiga', 'lifterlms' ),
		'JP26' => __( 'Kyoto', 'lifterlms' ),
		'JP27' => __( 'Osaka', 'lifterlms' ),
		'JP28' => __( 'Hyogo', 'lifterlms' ),
		'JP29' => __( 'Nara', 'lifterlms' ),
		'JP30' => __( 'Wakayama', 'lifterlms' ),
		'JP31' => __( 'Tottori', 'lifterlms' ),
		'JP32' => __( 'Shimane', 'lifterlms' ),
		'JP33' => __( 'Okayama', 'lifterlms' ),
		'JP34' => __( 'Hiroshima', 'lifterlms' ),
		'JP35' => __( 'Yamaguchi', 'lifterlms' ),
		'JP36' => __( 'Tokushima', 'lifterlms' ),
		'JP37' => __( 'Kagawa', 'lifterlms' ),
		'JP38' => __( 'Ehime', 'lifterlms' ),
		'JP39' => __( 'Kochi', 'lifterlms' ),
		'JP40' => __( 'Fukuoka', 'lifterlms' ),
		'JP41' => __( 'Saga', 'lifterlms' ),
		'JP42' => __( 'Nagasaki', 'lifterlms' ),
		'JP43' => __( 'Kumamoto', 'lifterlms' ),
		'JP44' => __( 'Oita', 'lifterlms' ),
		'JP45' => __( 'Miyazaki', 'lifterlms' ),
		'JP46' => __( 'Kagoshima', 'lifterlms' ),
		'JP47' => __( 'Okinawa', 'lifterlms' ),
	),
	'KE' => array( // Kenyan counties.
		'KE01' => __( 'Baringo', 'lifterlms' ),
		'KE02' => __( 'Bomet', 'lifterlms' ),
		'KE03' => __( 'Bungoma', 'lifterlms' ),
		'KE04' => __( 'Busia', 'lifterlms' ),
		'KE05' => __( 'Elgeyo-Marakwet', 'lifterlms' ),
		'KE06' => __( 'Embu', 'lifterlms' ),
		'KE07' => __( 'Garissa', 'lifterlms' ),
		'KE08' => __( 'Homa Bay', 'lifterlms' ),
		'KE09' => __( 'Isiolo', 'lifterlms' ),
		'KE10' => __( 'Kajiado', 'lifterlms' ),
		'KE11' => __( 'Kakamega', 'lifterlms' ),
		'KE12' => __( 'Kericho', 'lifterlms' ),
		'KE13' => __( 'Kiambu', 'lifterlms' ),
		'KE14' => __( 'Kilifi', 'lifterlms' ),
		'KE15' => __( 'Kirinyaga', 'lifterlms' ),
		'KE16' => __( 'Kisii', 'lifterlms' ),
		'KE17' => __( 'Kisumu', 'lifterlms' ),
		'KE18' => __( 'Kitui', 'lifterlms' ),
		'KE19' => __( 'Kwale', 'lifterlms' ),
		'KE20' => __( 'Laikipia', 'lifterlms' ),
		'KE21' => __( 'Lamu', 'lifterlms' ),
		'KE22' => __( 'Machakos', 'lifterlms' ),
		'KE23' => __( 'Makueni', 'lifterlms' ),
		'KE24' => __( 'Mandera', 'lifterlms' ),
		'KE25' => __( 'Marsabit', 'lifterlms' ),
		'KE26' => __( 'Meru', 'lifterlms' ),
		'KE27' => __( 'Migori', 'lifterlms' ),
		'KE28' => __( 'Mombasa', 'lifterlms' ),
		'KE29' => __( 'Murang’a', 'lifterlms' ),
		'KE30' => __( 'Nairobi County', 'lifterlms' ),
		'KE31' => __( 'Nakuru', 'lifterlms' ),
		'KE32' => __( 'Nandi', 'lifterlms' ),
		'KE33' => __( 'Narok', 'lifterlms' ),
		'KE34' => __( 'Nyamira', 'lifterlms' ),
		'KE35' => __( 'Nyandarua', 'lifterlms' ),
		'KE36' => __( 'Nyeri', 'lifterlms' ),
		'KE37' => __( 'Samburu', 'lifterlms' ),
		'KE38' => __( 'Siaya', 'lifterlms' ),
		'KE39' => __( 'Taita-Taveta', 'lifterlms' ),
		'KE40' => __( 'Tana River', 'lifterlms' ),
		'KE41' => __( 'Tharaka-Nithi', 'lifterlms' ),
		'KE42' => __( 'Trans Nzoia', 'lifterlms' ),
		'KE43' => __( 'Turkana', 'lifterlms' ),
		'KE44' => __( 'Uasin Gishu', 'lifterlms' ),
		'KE45' => __( 'Vihiga', 'lifterlms' ),
		'KE46' => __( 'Wajir', 'lifterlms' ),
		'KE47' => __( 'West Pokot', 'lifterlms' ),
	),
	'KN' => array( // Saint Kitts and Nevis parishes.
		'KNK'  => __( 'Saint Kitts', 'lifterlms' ),
		'KNN'  => __( 'Nevis', 'lifterlms' ),
		'KN01' => __( 'Christ Church Nichola Town', 'lifterlms' ),
		'KN02' => __( 'Saint Anne Sandy Point', 'lifterlms' ),
		'KN03' => __( 'Saint George Basseterre', 'lifterlms' ),
		'KN04' => __( 'Saint George Gingerland', 'lifterlms' ),
		'KN05' => __( 'Saint James Windward', 'lifterlms' ),
		'KN06' => __( 'Saint John Capisterre', 'lifterlms' ),
		'KN07' => __( 'Saint John Figtree', 'lifterlms' ),
		'KN08' => __( 'Saint Mary Cayon', 'lifterlms' ),
		'KN09' => __( 'Saint Paul Capisterre', 'lifterlms' ),
		'KN10' => __( 'Saint Paul Charlestown', 'lifterlms' ),
		'KN11' => __( 'Saint Peter Basseterre', 'lifterlms' ),
		'KN12' => __( 'Saint Thomas Lowland', 'lifterlms' ),
		'KN13' => __( 'Saint Thomas Middle Island', 'lifterlms' ),
		'KN15' => __( 'Trinity Palmetto Point', 'lifterlms' ),
	),
	'KR' => array(),
	'KW' => array(),
	'LA' => array( // Laotian provinces.
		'AT' => __( 'Attapeu', 'lifterlms' ),
		'BK' => __( 'Bokeo', 'lifterlms' ),
		'BL' => __( 'Bolikhamsai', 'lifterlms' ),
		'CH' => __( 'Champasak', 'lifterlms' ),
		'HO' => __( 'Houaphanh', 'lifterlms' ),
		'KH' => __( 'Khammouane', 'lifterlms' ),
		'LM' => __( 'Luang Namtha', 'lifterlms' ),
		'LP' => __( 'Luang Prabang', 'lifterlms' ),
		'OU' => __( 'Oudomxay', 'lifterlms' ),
		'PH' => __( 'Phongsaly', 'lifterlms' ),
		'SL' => __( 'Salavan', 'lifterlms' ),
		'SV' => __( 'Savannakhet', 'lifterlms' ),
		'VI' => __( 'Vientiane Province', 'lifterlms' ),
		'VT' => __( 'Vientiane', 'lifterlms' ),
		'XA' => __( 'Sainyabuli', 'lifterlms' ),
		'XE' => __( 'Sekong', 'lifterlms' ),
		'XI' => __( 'Xiangkhouang', 'lifterlms' ),
		'XS' => __( 'Xaisomboun', 'lifterlms' ),
	),
	'LB' => array(),
	'LI' => array(),
	'LR' => array( // Liberian provinces.
		'BM' => __( 'Bomi', 'lifterlms' ),
		'BN' => __( 'Bong', 'lifterlms' ),
		'GA' => __( 'Gbarpolu', 'lifterlms' ),
		'GB' => __( 'Grand Bassa', 'lifterlms' ),
		'GC' => __( 'Grand Cape Mount', 'lifterlms' ),
		'GG' => __( 'Grand Gedeh', 'lifterlms' ),
		'GK' => __( 'Grand Kru', 'lifterlms' ),
		'LO' => __( 'Lofa', 'lifterlms' ),
		'MA' => __( 'Margibi', 'lifterlms' ),
		'MY' => __( 'Maryland', 'lifterlms' ),
		'MO' => __( 'Montserrado', 'lifterlms' ),
		'NM' => __( 'Nimba', 'lifterlms' ),
		'RV' => __( 'Rivercess', 'lifterlms' ),
		'RG' => __( 'River Gee', 'lifterlms' ),
		'SN' => __( 'Sinoe', 'lifterlms' ),
	),
	'LU' => array(),
	'MA' => array( // Moroccan regions.
		'maagd' => __( 'Agadir-Ida Ou Tanane', 'lifterlms' ),
		'maazi' => __( 'Azilal', 'lifterlms' ),
		'mabem' => __( 'Béni-Mellal', 'lifterlms' ),
		'maber' => __( 'Berkane', 'lifterlms' ),
		'mabes' => __( 'Ben Slimane', 'lifterlms' ),
		'mabod' => __( 'Boujdour', 'lifterlms' ),
		'mabom' => __( 'Boulemane', 'lifterlms' ),
		'mabrr' => __( 'Berrechid', 'lifterlms' ),
		'macas' => __( 'Casablanca', 'lifterlms' ),
		'mache' => __( 'Chefchaouen', 'lifterlms' ),
		'machi' => __( 'Chichaoua', 'lifterlms' ),
		'macht' => __( 'Chtouka Aït Baha', 'lifterlms' ),
		'madri' => __( 'Driouch', 'lifterlms' ),
		'maedi' => __( 'Essaouira', 'lifterlms' ),
		'maerr' => __( 'Errachidia', 'lifterlms' ),
		'mafah' => __( 'Fahs-Beni Makada', 'lifterlms' ),
		'mafes' => __( 'Fès-Dar-Dbibegh', 'lifterlms' ),
		'mafig' => __( 'Figuig', 'lifterlms' ),
		'mafqh' => __( 'Fquih Ben Salah', 'lifterlms' ),
		'mafes' => __( 'Fès-Dar-Dbibegh', 'lifterlms' ),
		'mague' => __( 'Guelmim', 'lifterlms' ),
		'maguf' => __( 'Guercif', 'lifterlms' ),
		'mahaj' => __( 'El Hajeb', 'lifterlms' ),
		'mahao' => __( 'Al Haouz', 'lifterlms' ),
		'mahoc' => __( 'Al Hoceïma', 'lifterlms' ),
		'maifr' => __( 'Ifrane', 'lifterlms' ),
		'maine' => __( 'Inezgane-Aït Melloul', 'lifterlms' ),
		'majdi' => __( 'El Jadida', 'lifterlms' ),
		'majra' => __( 'Jerada', 'lifterlms' ),
		'maken' => __( 'Kénitra', 'lifterlms' ),
		'makes' => __( 'Kelaat Sraghna', 'lifterlms' ),
		'makhe' => __( 'Khemisset', 'lifterlms' ),
		'makhn' => __( 'Khénifra', 'lifterlms' ),
		'makho' => __( 'Khouribga', 'lifterlms' ),
		'malaa' => __( 'Laâyoune', 'lifterlms' ),
		'malar' => __( 'Larache', 'lifterlms' ),
		'mamar' => __( 'Marrakech', 'lifterlms' ),
		'mamdf' => __( 'M’diq-Fnideq', 'lifterlms' ),
		'mamed' => __( 'Médiouna', 'lifterlms' ),
		'mamek' => __( 'Meknès', 'lifterlms' ),
		'mamid' => __( 'Midelt', 'lifterlms' ),
		'mammd' => __( 'Marrakech-Medina', 'lifterlms' ),
		'mammn' => __( 'Marrakech-Menara', 'lifterlms' ),
		'mamoh' => __( 'Mohammedia', 'lifterlms' ),
		'mamou' => __( 'Moulay Yacoub', 'lifterlms' ),
		'manad' => __( 'Nador', 'lifterlms' ),
		'manou' => __( 'Nouaceur', 'lifterlms' ),
		'maoua' => __( 'Ouarzazate', 'lifterlms' ),
		'maoud' => __( 'Oued Ed-Dahab', 'lifterlms' ),
		'maouj' => __( 'Oujda-Angad', 'lifterlms' ),
		'maouz' => __( 'Ouezzane', 'lifterlms' ),
		'marab' => __( 'Rabat', 'lifterlms' ),
		'mareh' => __( 'Rehamna', 'lifterlms' ),
		'masaf' => __( 'Safi', 'lifterlms' ),
		'masal' => __( 'Salé', 'lifterlms' ),
		'masef' => __( 'Sefrou', 'lifterlms' ),
		'maset' => __( 'Settat', 'lifterlms' ),
		'masib' => __( 'Sidi Bennour', 'lifterlms' ),
		'masif' => __( 'Sidi Ifni', 'lifterlms' ),
		'masik' => __( 'Sidi Kacem', 'lifterlms' ),
		'masil' => __( 'Sidi Slimane', 'lifterlms' ),
		'maskh' => __( 'Skhirat-Témara', 'lifterlms' ),
		'masyb' => __( 'Sidi Youssef Ben Ali', 'lifterlms' ),
		'mataf' => __( 'Tarfaya (EH-partial)', 'lifterlms' ),
		'matai' => __( 'Taourirt', 'lifterlms' ),
		'matao' => __( 'Taounate', 'lifterlms' ),
		'matar' => __( 'Taroudant', 'lifterlms' ),
		'matat' => __( 'Tata', 'lifterlms' ),
		'mataz' => __( 'Taza', 'lifterlms' ),
		'matet' => __( 'Tétouan', 'lifterlms' ),
		'matin' => __( 'Tinghir', 'lifterlms' ),
		'matiz' => __( 'Tiznit', 'lifterlms' ),
		'matng' => __( 'Tangier-Assilah', 'lifterlms' ),
		'matnt' => __( 'Tan-Tan', 'lifterlms' ),
		'mayus' => __( 'Youssoufia', 'lifterlms' ),
		'mazag' => __( 'Zagora', 'lifterlms' )
	),
	'MD' => array( // Moldovan states.
		'C'  => __( 'Chișinău', 'lifterlms' ),
		'BL' => __( 'Bălți', 'lifterlms' ),
		'AN' => __( 'Anenii Noi', 'lifterlms' ),
		'BS' => __( 'Basarabeasca', 'lifterlms' ),
		'BR' => __( 'Briceni', 'lifterlms' ),
		'CH' => __( 'Cahul', 'lifterlms' ),
		'CT' => __( 'Cantemir', 'lifterlms' ),
		'CL' => __( 'Călărași', 'lifterlms' ),
		'CS' => __( 'Căușeni', 'lifterlms' ),
		'CM' => __( 'Cimișlia', 'lifterlms' ),
		'CR' => __( 'Criuleni', 'lifterlms' ),
		'DN' => __( 'Dondușeni', 'lifterlms' ),
		'DR' => __( 'Drochia', 'lifterlms' ),
		'DB' => __( 'Dubăsari', 'lifterlms' ),
		'ED' => __( 'Edineț', 'lifterlms' ),
		'FL' => __( 'Fălești', 'lifterlms' ),
		'FR' => __( 'Florești', 'lifterlms' ),
		'GE' => __( 'UTA Găgăuzia', 'lifterlms' ),
		'GL' => __( 'Glodeni', 'lifterlms' ),
		'HN' => __( 'Hîncești', 'lifterlms' ),
		'IL' => __( 'Ialoveni', 'lifterlms' ),
		'LV' => __( 'Leova', 'lifterlms' ),
		'NS' => __( 'Nisporeni', 'lifterlms' ),
		'OC' => __( 'Ocnița', 'lifterlms' ),
		'OR' => __( 'Orhei', 'lifterlms' ),
		'RZ' => __( 'Rezina', 'lifterlms' ),
		'RS' => __( 'Rîșcani', 'lifterlms' ),
		'SG' => __( 'Sîngerei', 'lifterlms' ),
		'SR' => __( 'Soroca', 'lifterlms' ),
		'ST' => __( 'Strășeni', 'lifterlms' ),
		'SD' => __( 'Șoldănești', 'lifterlms' ),
		'SV' => __( 'Ștefan Vodă', 'lifterlms' ),
		'TR' => __( 'Taraclia', 'lifterlms' ),
		'TL' => __( 'Telenești', 'lifterlms' ),
		'UN' => __( 'Ungheni', 'lifterlms' ),
	),
	'MF' => array(),
	'MQ' => array(),
	'MT' => array(),
	'MX' => array( // Mexican states.
		'DF' => __( 'Ciudad de México', 'lifterlms' ),
		'JA' => __( 'Jalisco', 'lifterlms' ),
		'NL' => __( 'Nuevo León', 'lifterlms' ),
		'AG' => __( 'Aguascalientes', 'lifterlms' ),
		'BC' => __( 'Baja California', 'lifterlms' ),
		'BS' => __( 'Baja California Sur', 'lifterlms' ),
		'CM' => __( 'Campeche', 'lifterlms' ),
		'CS' => __( 'Chiapas', 'lifterlms' ),
		'CH' => __( 'Chihuahua', 'lifterlms' ),
		'CO' => __( 'Coahuila', 'lifterlms' ),
		'CL' => __( 'Colima', 'lifterlms' ),
		'DG' => __( 'Durango', 'lifterlms' ),
		'GT' => __( 'Guanajuato', 'lifterlms' ),
		'GR' => __( 'Guerrero', 'lifterlms' ),
		'HG' => __( 'Hidalgo', 'lifterlms' ),
		'MX' => __( 'Estado de México', 'lifterlms' ),
		'MI' => __( 'Michoacán', 'lifterlms' ),
		'MO' => __( 'Morelos', 'lifterlms' ),
		'NA' => __( 'Nayarit', 'lifterlms' ),
		'OA' => __( 'Oaxaca', 'lifterlms' ),
		'PU' => __( 'Puebla', 'lifterlms' ),
		'QT' => __( 'Querétaro', 'lifterlms' ),
		'QR' => __( 'Quintana Roo', 'lifterlms' ),
		'SL' => __( 'San Luis Potosí', 'lifterlms' ),
		'SI' => __( 'Sinaloa', 'lifterlms' ),
		'SO' => __( 'Sonora', 'lifterlms' ),
		'TB' => __( 'Tabasco', 'lifterlms' ),
		'TM' => __( 'Tamaulipas', 'lifterlms' ),
		'TL' => __( 'Tlaxcala', 'lifterlms' ),
		'VE' => __( 'Veracruz', 'lifterlms' ),
		'YU' => __( 'Yucatán', 'lifterlms' ),
		'ZA' => __( 'Zacatecas', 'lifterlms' ),
	),
	'MY' => array( // Malaysian states.
		'JHR' => __( 'Johor', 'lifterlms' ),
		'KDH' => __( 'Kedah', 'lifterlms' ),
		'KTN' => __( 'Kelantan', 'lifterlms' ),
		'LBN' => __( 'Labuan', 'lifterlms' ),
		'MLK' => __( 'Malacca (Melaka)', 'lifterlms' ),
		'NSN' => __( 'Negeri Sembilan', 'lifterlms' ),
		'PHG' => __( 'Pahang', 'lifterlms' ),
		'PNG' => __( 'Penang (Pulau Pinang)', 'lifterlms' ),
		'PRK' => __( 'Perak', 'lifterlms' ),
		'PLS' => __( 'Perlis', 'lifterlms' ),
		'SBH' => __( 'Sabah', 'lifterlms' ),
		'SWK' => __( 'Sarawak', 'lifterlms' ),
		'SGR' => __( 'Selangor', 'lifterlms' ),
		'TRG' => __( 'Terengganu', 'lifterlms' ),
		'PJY' => __( 'Putrajaya', 'lifterlms' ),
		'KUL' => __( 'Kuala Lumpur', 'lifterlms' ),
	),
	'MZ' => array( // Mozambican provinces.
		'MZP'   => __( 'Cabo Delgado', 'lifterlms' ),
		'MZG'   => __( 'Gaza', 'lifterlms' ),
		'MZI'   => __( 'Inhambane', 'lifterlms' ),
		'MZB'   => __( 'Manica', 'lifterlms' ),
		'MZL'   => __( 'Maputo Province', 'lifterlms' ),
		'MZMPM' => __( 'Maputo', 'lifterlms' ),
		'MZN'   => __( 'Nampula', 'lifterlms' ),
		'MZA'   => __( 'Niassa', 'lifterlms' ),
		'MZS'   => __( 'Sofala', 'lifterlms' ),
		'MZT'   => __( 'Tete', 'lifterlms' ),
		'MZQ'   => __( 'Zambézia', 'lifterlms' ),
	),
	'NA' => array( // Namibian regions.
		'ER' => __( 'Erongo', 'lifterlms' ),
		'HA' => __( 'Hardap', 'lifterlms' ),
		'KA' => __( 'Karas', 'lifterlms' ),
		'KE' => __( 'Kavango East', 'lifterlms' ),
		'KW' => __( 'Kavango West', 'lifterlms' ),
		'KH' => __( 'Khomas', 'lifterlms' ),
		'KU' => __( 'Kunene', 'lifterlms' ),
		'OW' => __( 'Ohangwena', 'lifterlms' ),
		'OH' => __( 'Omaheke', 'lifterlms' ),
		'OS' => __( 'Omusati', 'lifterlms' ),
		'ON' => __( 'Oshana', 'lifterlms' ),
		'OT' => __( 'Oshikoto', 'lifterlms' ),
		'OD' => __( 'Otjozondjupa', 'lifterlms' ),
		'CA' => __( 'Zambezi', 'lifterlms' ),
	),
	'NG' => array( // Nigerian provinces.
		'AB' => __( 'Abia', 'lifterlms' ),
		'FC' => __( 'Abuja', 'lifterlms' ),
		'AD' => __( 'Adamawa', 'lifterlms' ),
		'AK' => __( 'Akwa Ibom', 'lifterlms' ),
		'AN' => __( 'Anambra', 'lifterlms' ),
		'BA' => __( 'Bauchi', 'lifterlms' ),
		'BY' => __( 'Bayelsa', 'lifterlms' ),
		'BE' => __( 'Benue', 'lifterlms' ),
		'BO' => __( 'Borno', 'lifterlms' ),
		'CR' => __( 'Cross River', 'lifterlms' ),
		'DE' => __( 'Delta', 'lifterlms' ),
		'EB' => __( 'Ebonyi', 'lifterlms' ),
		'ED' => __( 'Edo', 'lifterlms' ),
		'EK' => __( 'Ekiti', 'lifterlms' ),
		'EN' => __( 'Enugu', 'lifterlms' ),
		'GO' => __( 'Gombe', 'lifterlms' ),
		'IM' => __( 'Imo', 'lifterlms' ),
		'JI' => __( 'Jigawa', 'lifterlms' ),
		'KD' => __( 'Kaduna', 'lifterlms' ),
		'KN' => __( 'Kano', 'lifterlms' ),
		'KT' => __( 'Katsina', 'lifterlms' ),
		'KE' => __( 'Kebbi', 'lifterlms' ),
		'KO' => __( 'Kogi', 'lifterlms' ),
		'KW' => __( 'Kwara', 'lifterlms' ),
		'LA' => __( 'Lagos', 'lifterlms' ),
		'NA' => __( 'Nasarawa', 'lifterlms' ),
		'NI' => __( 'Niger', 'lifterlms' ),
		'OG' => __( 'Ogun', 'lifterlms' ),
		'ON' => __( 'Ondo', 'lifterlms' ),
		'OS' => __( 'Osun', 'lifterlms' ),
		'OY' => __( 'Oyo', 'lifterlms' ),
		'PL' => __( 'Plateau', 'lifterlms' ),
		'RI' => __( 'Rivers', 'lifterlms' ),
		'SO' => __( 'Sokoto', 'lifterlms' ),
		'TA' => __( 'Taraba', 'lifterlms' ),
		'YO' => __( 'Yobe', 'lifterlms' ),
		'ZA' => __( 'Zamfara', 'lifterlms' ),
	),
	'NL' => array(),
	'NO' => array(),
	'NP' => array( // Nepalese zones.
		'BAG' => __( 'Bagmati', 'lifterlms' ),
		'BHE' => __( 'Bheri', 'lifterlms' ),
		'DHA' => __( 'Dhaulagiri', 'lifterlms' ),
		'GAN' => __( 'Gandaki', 'lifterlms' ),
		'JAN' => __( 'Janakpur', 'lifterlms' ),
		'KAR' => __( 'Karnali', 'lifterlms' ),
		'KOS' => __( 'Koshi', 'lifterlms' ),
		'LUM' => __( 'Lumbini', 'lifterlms' ),
		'MAH' => __( 'Mahakali', 'lifterlms' ),
		'MEC' => __( 'Mechi', 'lifterlms' ),
		'NAR' => __( 'Narayani', 'lifterlms' ),
		'RAP' => __( 'Rapti', 'lifterlms' ),
		'SAG' => __( 'Sagarmatha', 'lifterlms' ),
		'SET' => __( 'Seti', 'lifterlms' ),
	),
	'NI' => array( // Nicaraguan states.
		'NI-AN' => __( 'Atlántico Norte', 'lifterlms' ),
		'NI-AS' => __( 'Atlántico Sur', 'lifterlms' ),
		'NI-BO' => __( 'Boaco', 'lifterlms' ),
		'NI-CA' => __( 'Carazo', 'lifterlms' ),
		'NI-CI' => __( 'Chinandega', 'lifterlms' ),
		'NI-CO' => __( 'Chontales', 'lifterlms' ),
		'NI-ES' => __( 'Estelí', 'lifterlms' ),
		'NI-GR' => __( 'Granada', 'lifterlms' ),
		'NI-JI' => __( 'Jinotega', 'lifterlms' ),
		'NI-LE' => __( 'León', 'lifterlms' ),
		'NI-MD' => __( 'Madriz', 'lifterlms' ),
		'NI-MN' => __( 'Managua', 'lifterlms' ),
		'NI-MS' => __( 'Masaya', 'lifterlms' ),
		'NI-MT' => __( 'Matagalpa', 'lifterlms' ),
		'NI-NS' => __( 'Nueva Segovia', 'lifterlms' ),
		'NI-RI' => __( 'Rivas', 'lifterlms' ),
		'NI-SJ' => __( 'Río San Juan', 'lifterlms' ),
	),
	'NZ' => array( // New Zealand states.
		'NTL' => __( 'Northland', 'lifterlms' ),
		'AUK' => __( 'Auckland', 'lifterlms' ),
		'WKO' => __( 'Waikato', 'lifterlms' ),
		'BOP' => __( 'Bay of Plenty', 'lifterlms' ),
		'TKI' => __( 'Taranaki', 'lifterlms' ),
		'GIS' => __( 'Gisborne', 'lifterlms' ),
		'HKB' => __( 'Hawke’s Bay', 'lifterlms' ),
		'MWT' => __( 'Manawatu-Whanganui', 'lifterlms' ),
		'WGN' => __( 'Wellington', 'lifterlms' ),
		'NSN' => __( 'Nelson', 'lifterlms' ),
		'MBH' => __( 'Marlborough', 'lifterlms' ),
		'TAS' => __( 'Tasman', 'lifterlms' ),
		'WTC' => __( 'West Coast', 'lifterlms' ),
		'CAN' => __( 'Canterbury', 'lifterlms' ),
		'OTA' => __( 'Otago', 'lifterlms' ),
		'STL' => __( 'Southland', 'lifterlms' ),
	),
	'PA' => array( // Panamanian states.
		'PA-1' => __( 'Bocas del Toro', 'lifterlms' ),
		'PA-2' => __( 'Coclé', 'lifterlms' ),
		'PA-3' => __( 'Colón', 'lifterlms' ),
		'PA-4' => __( 'Chiriquí', 'lifterlms' ),
		'PA-5' => __( 'Darién', 'lifterlms' ),
		'PA-6' => __( 'Herrera', 'lifterlms' ),
		'PA-7' => __( 'Los Santos', 'lifterlms' ),
		'PA-8' => __( 'Panamá', 'lifterlms' ),
		'PA-9' => __( 'Veraguas', 'lifterlms' ),
		'PA-10' => __( 'West Panamá', 'lifterlms' ),
		'PA-EM' => __( 'Emberá', 'lifterlms' ),
		'PA-KY' => __( 'Guna Yala', 'lifterlms' ),
		'PA-NB' => __( 'Ngöbe-Buglé', 'lifterlms' ),
	),
	'PE' => array( // Peruvian states.
		'CAL' => __( 'El Callao', 'lifterlms' ),
		'LMA' => __( 'Municipalidad Metropolitana de Lima', 'lifterlms' ),
		'AMA' => __( 'Amazonas', 'lifterlms' ),
		'ANC' => __( 'Ancash', 'lifterlms' ),
		'APU' => __( 'Apurímac', 'lifterlms' ),
		'ARE' => __( 'Arequipa', 'lifterlms' ),
		'AYA' => __( 'Ayacucho', 'lifterlms' ),
		'CAJ' => __( 'Cajamarca', 'lifterlms' ),
		'CUS' => __( 'Cusco', 'lifterlms' ),
		'HUV' => __( 'Huancavelica', 'lifterlms' ),
		'HUC' => __( 'Huánuco', 'lifterlms' ),
		'ICA' => __( 'Ica', 'lifterlms' ),
		'JUN' => __( 'Junín', 'lifterlms' ),
		'LAL' => __( 'La Libertad', 'lifterlms' ),
		'LAM' => __( 'Lambayeque', 'lifterlms' ),
		'LIM' => __( 'Lima', 'lifterlms' ),
		'LOR' => __( 'Loreto', 'lifterlms' ),
		'MDD' => __( 'Madre de Dios', 'lifterlms' ),
		'MOQ' => __( 'Moquegua', 'lifterlms' ),
		'PAS' => __( 'Pasco', 'lifterlms' ),
		'PIU' => __( 'Piura', 'lifterlms' ),
		'PUN' => __( 'Puno', 'lifterlms' ),
		'SAM' => __( 'San Martín', 'lifterlms' ),
		'TAC' => __( 'Tacna', 'lifterlms' ),
		'TUM' => __( 'Tumbes', 'lifterlms' ),
		'UCA' => __( 'Ucayali', 'lifterlms' ),
	),
	'PH' => array( // Philippine provinces.
		'ABR' => __( 'Abra', 'lifterlms' ),
		'AGN' => __( 'Agusan del Norte', 'lifterlms' ),
		'AGS' => __( 'Agusan del Sur', 'lifterlms' ),
		'AKL' => __( 'Aklan', 'lifterlms' ),
		'ALB' => __( 'Albay', 'lifterlms' ),
		'ANT' => __( 'Antique', 'lifterlms' ),
		'APA' => __( 'Apayao', 'lifterlms' ),
		'AUR' => __( 'Aurora', 'lifterlms' ),
		'BAS' => __( 'Basilan', 'lifterlms' ),
		'BAN' => __( 'Bataan', 'lifterlms' ),
		'BTN' => __( 'Batanes', 'lifterlms' ),
		'BTG' => __( 'Batangas', 'lifterlms' ),
		'BEN' => __( 'Benguet', 'lifterlms' ),
		'BIL' => __( 'Biliran', 'lifterlms' ),
		'BOH' => __( 'Bohol', 'lifterlms' ),
		'BUK' => __( 'Bukidnon', 'lifterlms' ),
		'BUL' => __( 'Bulacan', 'lifterlms' ),
		'CAG' => __( 'Cagayan', 'lifterlms' ),
		'CAN' => __( 'Camarines Norte', 'lifterlms' ),
		'CAS' => __( 'Camarines Sur', 'lifterlms' ),
		'CAM' => __( 'Camiguin', 'lifterlms' ),
		'CAP' => __( 'Capiz', 'lifterlms' ),
		'CAT' => __( 'Catanduanes', 'lifterlms' ),
		'CAV' => __( 'Cavite', 'lifterlms' ),
		'CEB' => __( 'Cebu', 'lifterlms' ),
		'COM' => __( 'Compostela Valley', 'lifterlms' ),
		'NCO' => __( 'Cotabato', 'lifterlms' ),
		'DAV' => __( 'Davao del Norte', 'lifterlms' ),
		'DAS' => __( 'Davao del Sur', 'lifterlms' ),
		'DAC' => __( 'Davao Occidental', 'lifterlms' ),
		'DAO' => __( 'Davao Oriental', 'lifterlms' ),
		'DIN' => __( 'Dinagat Islands', 'lifterlms' ),
		'EAS' => __( 'Eastern Samar', 'lifterlms' ),
		'GUI' => __( 'Guimaras', 'lifterlms' ),
		'IFU' => __( 'Ifugao', 'lifterlms' ),
		'ILN' => __( 'Ilocos Norte', 'lifterlms' ),
		'ILS' => __( 'Ilocos Sur', 'lifterlms' ),
		'ILI' => __( 'Iloilo', 'lifterlms' ),
		'ISA' => __( 'Isabela', 'lifterlms' ),
		'KAL' => __( 'Kalinga', 'lifterlms' ),
		'LUN' => __( 'La Union', 'lifterlms' ),
		'LAG' => __( 'Laguna', 'lifterlms' ),
		'LAN' => __( 'Lanao del Norte', 'lifterlms' ),
		'LAS' => __( 'Lanao del Sur', 'lifterlms' ),
		'LEY' => __( 'Leyte', 'lifterlms' ),
		'MAG' => __( 'Maguindanao', 'lifterlms' ),
		'MAD' => __( 'Marinduque', 'lifterlms' ),
		'MAS' => __( 'Masbate', 'lifterlms' ),
		'MSC' => __( 'Misamis Occidental', 'lifterlms' ),
		'MSR' => __( 'Misamis Oriental', 'lifterlms' ),
		'MOU' => __( 'Mountain Province', 'lifterlms' ),
		'NEC' => __( 'Negros Occidental', 'lifterlms' ),
		'NER' => __( 'Negros Oriental', 'lifterlms' ),
		'NSA' => __( 'Northern Samar', 'lifterlms' ),
		'NUE' => __( 'Nueva Ecija', 'lifterlms' ),
		'NUV' => __( 'Nueva Vizcaya', 'lifterlms' ),
		'MDC' => __( 'Occidental Mindoro', 'lifterlms' ),
		'MDR' => __( 'Oriental Mindoro', 'lifterlms' ),
		'PLW' => __( 'Palawan', 'lifterlms' ),
		'PAM' => __( 'Pampanga', 'lifterlms' ),
		'PAN' => __( 'Pangasinan', 'lifterlms' ),
		'QUE' => __( 'Quezon', 'lifterlms' ),
		'QUI' => __( 'Quirino', 'lifterlms' ),
		'RIZ' => __( 'Rizal', 'lifterlms' ),
		'ROM' => __( 'Romblon', 'lifterlms' ),
		'WSA' => __( 'Samar', 'lifterlms' ),
		'SAR' => __( 'Sarangani', 'lifterlms' ),
		'SIQ' => __( 'Siquijor', 'lifterlms' ),
		'SOR' => __( 'Sorsogon', 'lifterlms' ),
		'SCO' => __( 'South Cotabato', 'lifterlms' ),
		'SLE' => __( 'Southern Leyte', 'lifterlms' ),
		'SUK' => __( 'Sultan Kudarat', 'lifterlms' ),
		'SLU' => __( 'Sulu', 'lifterlms' ),
		'SUN' => __( 'Surigao del Norte', 'lifterlms' ),
		'SUR' => __( 'Surigao del Sur', 'lifterlms' ),
		'TAR' => __( 'Tarlac', 'lifterlms' ),
		'TAW' => __( 'Tawi-Tawi', 'lifterlms' ),
		'ZMB' => __( 'Zambales', 'lifterlms' ),
		'ZAN' => __( 'Zamboanga del Norte', 'lifterlms' ),
		'ZAS' => __( 'Zamboanga del Sur', 'lifterlms' ),
		'ZSI' => __( 'Zamboanga Sibugay', 'lifterlms' ),
		'00'  => __( 'Metro Manila', 'lifterlms' ),
	),
	'PK' => array( // Pakistani states.
		'JK' => __( 'Azad Kashmir', 'lifterlms' ),
		'BA' => __( 'Balochistan', 'lifterlms' ),
		'TA' => __( 'FATA', 'lifterlms' ),
		'GB' => __( 'Gilgit Baltistan', 'lifterlms' ),
		'IS' => __( 'Islamabad Capital Territory', 'lifterlms' ),
		'KP' => __( 'Khyber Pakhtunkhwa', 'lifterlms' ),
		'PB' => __( 'Punjab', 'lifterlms' ),
		'SD' => __( 'Sindh', 'lifterlms' ),
	),
	'PL' => array(),
	'PR' => array(),
	'PT' => array(),
	'PY' => array( // Paraguayan states.
		'PY-ASU' => __( 'Asunción', 'lifterlms' ),
		'PY-1'   => __( 'Concepción', 'lifterlms' ),
		'PY-2'   => __( 'San Pedro', 'lifterlms' ),
		'PY-3'   => __( 'Cordillera', 'lifterlms' ),
		'PY-4'   => __( 'Guairá', 'lifterlms' ),
		'PY-5'   => __( 'Caaguazú', 'lifterlms' ),
		'PY-6'   => __( 'Caazapá', 'lifterlms' ),
		'PY-7'   => __( 'Itapúa', 'lifterlms' ),
		'PY-8'   => __( 'Misiones', 'lifterlms' ),
		'PY-9'   => __( 'Paraguarí', 'lifterlms' ),
		'PY-10'  => __( 'Alto Paraná', 'lifterlms' ),
		'PY-11'  => __( 'Central', 'lifterlms' ),
		'PY-12'  => __( 'Ñeembucú', 'lifterlms' ),
		'PY-13'  => __( 'Amambay', 'lifterlms' ),
		'PY-14'  => __( 'Canindeyú', 'lifterlms' ),
		'PY-15'  => __( 'Presidente Hayes', 'lifterlms' ),
		'PY-16'  => __( 'Alto Paraguay', 'lifterlms' ),
		'PY-17'  => __( 'Boquerón', 'lifterlms' ),
	),
	'RE' => array(),
	'RO' => array( // Romanian states.
		'AB' => __( 'Alba', 'lifterlms' ),
		'AR' => __( 'Arad', 'lifterlms' ),
		'AG' => __( 'Argeș', 'lifterlms' ),
		'BC' => __( 'Bacău', 'lifterlms' ),
		'BH' => __( 'Bihor', 'lifterlms' ),
		'BN' => __( 'Bistrița-Năsăud', 'lifterlms' ),
		'BT' => __( 'Botoșani', 'lifterlms' ),
		'BR' => __( 'Brăila', 'lifterlms' ),
		'BV' => __( 'Brașov', 'lifterlms' ),
		'B'  => __( 'București', 'lifterlms' ),
		'BZ' => __( 'Buzău', 'lifterlms' ),
		'CL' => __( 'Călărași', 'lifterlms' ),
		'CS' => __( 'Caraș-Severin', 'lifterlms' ),
		'CJ' => __( 'Cluj', 'lifterlms' ),
		'CT' => __( 'Constanța', 'lifterlms' ),
		'CV' => __( 'Covasna', 'lifterlms' ),
		'DB' => __( 'Dâmbovița', 'lifterlms' ),
		'DJ' => __( 'Dolj', 'lifterlms' ),
		'GL' => __( 'Galați', 'lifterlms' ),
		'GR' => __( 'Giurgiu', 'lifterlms' ),
		'GJ' => __( 'Gorj', 'lifterlms' ),
		'HR' => __( 'Harghita', 'lifterlms' ),
		'HD' => __( 'Hunedoara', 'lifterlms' ),
		'IL' => __( 'Ialomița', 'lifterlms' ),
		'IS' => __( 'Iași', 'lifterlms' ),
		'IF' => __( 'Ilfov', 'lifterlms' ),
		'MM' => __( 'Maramureș', 'lifterlms' ),
		'MH' => __( 'Mehedinți', 'lifterlms' ),
		'MS' => __( 'Mureș', 'lifterlms' ),
		'NT' => __( 'Neamț', 'lifterlms' ),
		'OT' => __( 'Olt', 'lifterlms' ),
		'PH' => __( 'Prahova', 'lifterlms' ),
		'SJ' => __( 'Sălaj', 'lifterlms' ),
		'SM' => __( 'Satu Mare', 'lifterlms' ),
		'SB' => __( 'Sibiu', 'lifterlms' ),
		'SV' => __( 'Suceava', 'lifterlms' ),
		'TR' => __( 'Teleorman', 'lifterlms' ),
		'TM' => __( 'Timiș', 'lifterlms' ),
		'TL' => __( 'Tulcea', 'lifterlms' ),
		'VL' => __( 'Vâlcea', 'lifterlms' ),
		'VS' => __( 'Vaslui', 'lifterlms' ),
		'VN' => __( 'Vrancea', 'lifterlms' ),
	),
	'SN' => array( // Regions of Senegal. Ref: https://github.com/unicode-org/cldr/blob/release-42/common/subdivisions/en.xml#L4801.
		'SNDB' => __( 'Diourbel', 'lifterlms' ),
		'SNDK' => __( 'Dakar', 'lifterlms' ),
		'SNFK' => __( 'Fatick', 'lifterlms' ),
		'SNKA' => __( 'Kaffrine', 'lifterlms' ),
		'SNKD' => __( 'Kolda', 'lifterlms' ),
		'SNKE' => __( 'Kédougou', 'lifterlms' ),
		'SNKL' => __( 'Kaolack', 'lifterlms' ),
		'SNLG' => __( 'Louga', 'lifterlms' ),
		'SNMT' => __( 'Matam', 'lifterlms' ),
		'SNSE' => __( 'Sédhiou', 'lifterlms' ),
		'SNSL' => __( 'Saint-Louis', 'lifterlms' ),
		'SNTC' => __( 'Tambacounda', 'lifterlms' ),
		'SNTH' => __( 'Thiès', 'lifterlms' ),
		'SNZG' => __( 'Ziguinchor', 'lifterlms' ),
	),
	'SG' => array(),
	'SK' => array(),
	'SI' => array(),
	'SV' => array( // Salvadoran states.
		'SV-AH' => __( 'Ahuachapán', 'lifterlms' ),
		'SV-CA' => __( 'Cabañas', 'lifterlms' ),
		'SV-CH' => __( 'Chalatenango', 'lifterlms' ),
		'SV-CU' => __( 'Cuscatlán', 'lifterlms' ),
		'SV-LI' => __( 'La Libertad', 'lifterlms' ),
		'SV-MO' => __( 'Morazán', 'lifterlms' ),
		'SV-PA' => __( 'La Paz', 'lifterlms' ),
		'SV-SA' => __( 'Santa Ana', 'lifterlms' ),
		'SV-SM' => __( 'San Miguel', 'lifterlms' ),
		'SV-SO' => __( 'Sonsonate', 'lifterlms' ),
		'SV-SS' => __( 'San Salvador', 'lifterlms' ),
		'SV-SV' => __( 'San Vicente', 'lifterlms' ),
		'SV-UN' => __( 'La Unión', 'lifterlms' ),
		'SV-US' => __( 'Usulután', 'lifterlms' ),
	),
	'TH' => array( // Thai states.
		'TH-37' => __( 'Amnat Charoen', 'lifterlms' ),
		'TH-15' => __( 'Ang Thong', 'lifterlms' ),
		'TH-14' => __( 'Ayutthaya', 'lifterlms' ),
		'TH-10' => __( 'Bangkok', 'lifterlms' ),
		'TH-38' => __( 'Bueng Kan', 'lifterlms' ),
		'TH-31' => __( 'Buri Ram', 'lifterlms' ),
		'TH-24' => __( 'Chachoengsao', 'lifterlms' ),
		'TH-18' => __( 'Chai Nat', 'lifterlms' ),
		'TH-36' => __( 'Chaiyaphum', 'lifterlms' ),
		'TH-22' => __( 'Chanthaburi', 'lifterlms' ),
		'TH-50' => __( 'Chiang Mai', 'lifterlms' ),
		'TH-57' => __( 'Chiang Rai', 'lifterlms' ),
		'TH-20' => __( 'Chonburi', 'lifterlms' ),
		'TH-86' => __( 'Chumphon', 'lifterlms' ),
		'TH-46' => __( 'Kalasin', 'lifterlms' ),
		'TH-62' => __( 'Kamphaeng Phet', 'lifterlms' ),
		'TH-71' => __( 'Kanchanaburi', 'lifterlms' ),
		'TH-40' => __( 'Khon Kaen', 'lifterlms' ),
		'TH-81' => __( 'Krabi', 'lifterlms' ),
		'TH-52' => __( 'Lampang', 'lifterlms' ),
		'TH-51' => __( 'Lamphun', 'lifterlms' ),
		'TH-42' => __( 'Loei', 'lifterlms' ),
		'TH-16' => __( 'Lopburi', 'lifterlms' ),
		'TH-58' => __( 'Mae Hong Son', 'lifterlms' ),
		'TH-44' => __( 'Maha Sarakham', 'lifterlms' ),
		'TH-49' => __( 'Mukdahan', 'lifterlms' ),
		'TH-26' => __( 'Nakhon Nayok', 'lifterlms' ),
		'TH-73' => __( 'Nakhon Pathom', 'lifterlms' ),
		'TH-48' => __( 'Nakhon Phanom', 'lifterlms' ),
		'TH-30' => __( 'Nakhon Ratchasima', 'lifterlms' ),
		'TH-60' => __( 'Nakhon Sawan', 'lifterlms' ),
		'TH-80' => __( 'Nakhon Si Thammarat', 'lifterlms' ),
		'TH-55' => __( 'Nan', 'lifterlms' ),
		'TH-96' => __( 'Narathiwat', 'lifterlms' ),
		'TH-39' => __( 'Nong Bua Lam Phu', 'lifterlms' ),
		'TH-43' => __( 'Nong Khai', 'lifterlms' ),
		'TH-12' => __( 'Nonthaburi', 'lifterlms' ),
		'TH-13' => __( 'Pathum Thani', 'lifterlms' ),
		'TH-94' => __( 'Pattani', 'lifterlms' ),
		'TH-82' => __( 'Phang Nga', 'lifterlms' ),
		'TH-93' => __( 'Phatthalung', 'lifterlms' ),
		'TH-56' => __( 'Phayao', 'lifterlms' ),
		'TH-67' => __( 'Phetchabun', 'lifterlms' ),
		'TH-76' => __( 'Phetchaburi', 'lifterlms' ),
		'TH-66' => __( 'Phichit', 'lifterlms' ),
		'TH-65' => __( 'Phitsanulok', 'lifterlms' ),
		'TH-54' => __( 'Phrae', 'lifterlms' ),
		'TH-83' => __( 'Phuket', 'lifterlms' ),
		'TH-25' => __( 'Prachin Buri', 'lifterlms' ),
		'TH-77' => __( 'Prachuap Khiri Khan', 'lifterlms' ),
		'TH-85' => __( 'Ranong', 'lifterlms' ),
		'TH-70' => __( 'Ratchaburi', 'lifterlms' ),
		'TH-21' => __( 'Rayong', 'lifterlms' ),
		'TH-45' => __( 'Roi Et', 'lifterlms' ),
		'TH-27' => __( 'Sa Kaeo', 'lifterlms' ),
		'TH-47' => __( 'Sakon Nakhon', 'lifterlms' ),
		'TH-11' => __( 'Samut Prakan', 'lifterlms' ),
		'TH-74' => __( 'Samut Sakhon', 'lifterlms' ),
		'TH-75' => __( 'Samut Songkhram', 'lifterlms' ),
		'TH-19' => __( 'Saraburi', 'lifterlms' ),
		'TH-91' => __( 'Satun', 'lifterlms' ),
		'TH-17' => __( 'Sing Buri', 'lifterlms' ),
		'TH-33' => __( 'Sisaket', 'lifterlms' ),
		'TH-90' => __( 'Songkhla', 'lifterlms' ),
		'TH-64' => __( 'Sukhothai', 'lifterlms' ),
		'TH-72' => __( 'Suphan Buri', 'lifterlms' ),
		'TH-84' => __( 'Surat Thani', 'lifterlms' ),
		'TH-32' => __( 'Surin', 'lifterlms' ),
		'TH-63' => __( 'Tak', 'lifterlms' ),
		'TH-92' => __( 'Trang', 'lifterlms' ),
		'TH-23' => __( 'Trat', 'lifterlms' ),
		'TH-34' => __( 'Ubon Ratchathani', 'lifterlms' ),
		'TH-41' => __( 'Udon Thani', 'lifterlms' ),
		'TH-61' => __( 'Uthai Thani', 'lifterlms' ),
		'TH-53' => __( 'Uttaradit', 'lifterlms' ),
		'TH-95' => __( 'Yala', 'lifterlms' ),
		'TH-35' => __( 'Yasothon', 'lifterlms' ),
	),
	'TR' => array( // Turkish states.
		'TR01' => __( 'Adana', 'lifterlms' ),
		'TR02' => __( 'Adıyaman', 'lifterlms' ),
		'TR03' => __( 'Afyon', 'lifterlms' ),
		'TR04' => __( 'Ağrı', 'lifterlms' ),
		'TR05' => __( 'Amasya', 'lifterlms' ),
		'TR06' => __( 'Ankara', 'lifterlms' ),
		'TR07' => __( 'Antalya', 'lifterlms' ),
		'TR08' => __( 'Artvin', 'lifterlms' ),
		'TR09' => __( 'Aydın', 'lifterlms' ),
		'TR10' => __( 'Balıkesir', 'lifterlms' ),
		'TR11' => __( 'Bilecik', 'lifterlms' ),
		'TR12' => __( 'Bingöl', 'lifterlms' ),
		'TR13' => __( 'Bitlis', 'lifterlms' ),
		'TR14' => __( 'Bolu', 'lifterlms' ),
		'TR15' => __( 'Burdur', 'lifterlms' ),
		'TR16' => __( 'Bursa', 'lifterlms' ),
		'TR17' => __( 'Çanakkale', 'lifterlms' ),
		'TR18' => __( 'Çankırı', 'lifterlms' ),
		'TR19' => __( 'Çorum', 'lifterlms' ),
		'TR20' => __( 'Denizli', 'lifterlms' ),
		'TR21' => __( 'Diyarbakır', 'lifterlms' ),
		'TR22' => __( 'Edirne', 'lifterlms' ),
		'TR23' => __( 'Elazığ', 'lifterlms' ),
		'TR24' => __( 'Erzincan', 'lifterlms' ),
		'TR25' => __( 'Erzurum', 'lifterlms' ),
		'TR26' => __( 'Eskişehir', 'lifterlms' ),
		'TR27' => __( 'Gaziantep', 'lifterlms' ),
		'TR28' => __( 'Giresun', 'lifterlms' ),
		'TR29' => __( 'Gümüşhane', 'lifterlms' ),
		'TR30' => __( 'Hakkari', 'lifterlms' ),
		'TR31' => __( 'Hatay', 'lifterlms' ),
		'TR32' => __( 'Isparta', 'lifterlms' ),
		'TR33' => __( 'İçel', 'lifterlms' ),
		'TR34' => __( 'İstanbul', 'lifterlms' ),
		'TR35' => __( 'İzmir', 'lifterlms' ),
		'TR36' => __( 'Kars', 'lifterlms' ),
		'TR37' => __( 'Kastamonu', 'lifterlms' ),
		'TR38' => __( 'Kayseri', 'lifterlms' ),
		'TR39' => __( 'Kırklareli', 'lifterlms' ),
		'TR40' => __( 'Kırşehir', 'lifterlms' ),
		'TR41' => __( 'Kocaeli', 'lifterlms' ),
		'TR42' => __( 'Konya', 'lifterlms' ),
		'TR43' => __( 'Kütahya', 'lifterlms' ),
		'TR44' => __( 'Malatya', 'lifterlms' ),
		'TR45' => __( 'Manisa', 'lifterlms' ),
		'TR46' => __( 'Kahramanmaraş', 'lifterlms' ),
		'TR47' => __( 'Mardin', 'lifterlms' ),
		'TR48' => __( 'Muğla', 'lifterlms' ),
		'TR49' => __( 'Muş', 'lifterlms' ),
		'TR50' => __( 'Nevşehir', 'lifterlms' ),
		'TR51' => __( 'Niğde', 'lifterlms' ),
		'TR52' => __( 'Ordu', 'lifterlms' ),
		'TR53' => __( 'Rize', 'lifterlms' ),
		'TR54' => __( 'Sakarya', 'lifterlms' ),
		'TR55' => __( 'Samsun', 'lifterlms' ),
		'TR56' => __( 'Siirt', 'lifterlms' ),
		'TR57' => __( 'Sinop', 'lifterlms' ),
		'TR58' => __( 'Sivas', 'lifterlms' ),
		'TR59' => __( 'Tekirdağ', 'lifterlms' ),
		'TR60' => __( 'Tokat', 'lifterlms' ),
		'TR61' => __( 'Trabzon', 'lifterlms' ),
		'TR62' => __( 'Tunceli', 'lifterlms' ),
		'TR63' => __( 'Şanlıurfa', 'lifterlms' ),
		'TR64' => __( 'Uşak', 'lifterlms' ),
		'TR65' => __( 'Van', 'lifterlms' ),
		'TR66' => __( 'Yozgat', 'lifterlms' ),
		'TR67' => __( 'Zonguldak', 'lifterlms' ),
		'TR68' => __( 'Aksaray', 'lifterlms' ),
		'TR69' => __( 'Bayburt', 'lifterlms' ),
		'TR70' => __( 'Karaman', 'lifterlms' ),
		'TR71' => __( 'Kırıkkale', 'lifterlms' ),
		'TR72' => __( 'Batman', 'lifterlms' ),
		'TR73' => __( 'Şırnak', 'lifterlms' ),
		'TR74' => __( 'Bartın', 'lifterlms' ),
		'TR75' => __( 'Ardahan', 'lifterlms' ),
		'TR76' => __( 'Iğdır', 'lifterlms' ),
		'TR77' => __( 'Yalova', 'lifterlms' ),
		'TR78' => __( 'Karabük', 'lifterlms' ),
		'TR79' => __( 'Kilis', 'lifterlms' ),
		'TR80' => __( 'Osmaniye', 'lifterlms' ),
		'TR81' => __( 'Düzce', 'lifterlms' ),
	),
	'TZ' => array( // Tanzanian states.
		'TZ01' => __( 'Arusha', 'lifterlms' ),
		'TZ02' => __( 'Dar es Salaam', 'lifterlms' ),
		'TZ03' => __( 'Dodoma', 'lifterlms' ),
		'TZ04' => __( 'Iringa', 'lifterlms' ),
		'TZ05' => __( 'Kagera', 'lifterlms' ),
		'TZ06' => __( 'Pemba North', 'lifterlms' ),
		'TZ07' => __( 'Zanzibar North', 'lifterlms' ),
		'TZ08' => __( 'Kigoma', 'lifterlms' ),
		'TZ09' => __( 'Kilimanjaro', 'lifterlms' ),
		'TZ10' => __( 'Pemba South', 'lifterlms' ),
		'TZ11' => __( 'Zanzibar South', 'lifterlms' ),
		'TZ12' => __( 'Lindi', 'lifterlms' ),
		'TZ13' => __( 'Mara', 'lifterlms' ),
		'TZ14' => __( 'Mbeya', 'lifterlms' ),
		'TZ15' => __( 'Zanzibar West', 'lifterlms' ),
		'TZ16' => __( 'Morogoro', 'lifterlms' ),
		'TZ17' => __( 'Mtwara', 'lifterlms' ),
		'TZ18' => __( 'Mwanza', 'lifterlms' ),
		'TZ19' => __( 'Coast', 'lifterlms' ),
		'TZ20' => __( 'Rukwa', 'lifterlms' ),
		'TZ21' => __( 'Ruvuma', 'lifterlms' ),
		'TZ22' => __( 'Shinyanga', 'lifterlms' ),
		'TZ23' => __( 'Singida', 'lifterlms' ),
		'TZ24' => __( 'Tabora', 'lifterlms' ),
		'TZ25' => __( 'Tanga', 'lifterlms' ),
		'TZ26' => __( 'Manyara', 'lifterlms' ),
		'TZ27' => __( 'Geita', 'lifterlms' ),
		'TZ28' => __( 'Katavi', 'lifterlms' ),
		'TZ29' => __( 'Njombe', 'lifterlms' ),
		'TZ30' => __( 'Simiyu', 'lifterlms' ),
	),
	'LK' => array(),
	'RS' => array( // Serbian districts.
		'RS00' => _x( 'Belgrade', 'district', 'lifterlms' ),
		'RS14' => _x( 'Bor', 'district', 'lifterlms' ),
		'RS11' => _x( 'Braničevo', 'district', 'lifterlms' ),
		'RS02' => _x( 'Central Banat', 'district', 'lifterlms' ),
		'RS10' => _x( 'Danube', 'district', 'lifterlms' ),
		'RS23' => _x( 'Jablanica', 'district', 'lifterlms' ),
		'RS09' => _x( 'Kolubara', 'district', 'lifterlms' ),
		'RS08' => _x( 'Mačva', 'district', 'lifterlms' ),
		'RS17' => _x( 'Morava', 'district', 'lifterlms' ),
		'RS20' => _x( 'Nišava', 'district', 'lifterlms' ),
		'RS01' => _x( 'North Bačka', 'district', 'lifterlms' ),
		'RS03' => _x( 'North Banat', 'district', 'lifterlms' ),
		'RS24' => _x( 'Pčinja', 'district', 'lifterlms' ),
		'RS22' => _x( 'Pirot', 'district', 'lifterlms' ),
		'RS13' => _x( 'Pomoravlje', 'district', 'lifterlms' ),
		'RS19' => _x( 'Rasina', 'district', 'lifterlms' ),
		'RS18' => _x( 'Raška', 'district', 'lifterlms' ),
		'RS06' => _x( 'South Bačka', 'district', 'lifterlms' ),
		'RS04' => _x( 'South Banat', 'district', 'lifterlms' ),
		'RS07' => _x( 'Srem', 'district', 'lifterlms' ),
		'RS12' => _x( 'Šumadija', 'district', 'lifterlms' ),
		'RS21' => _x( 'Toplica', 'district', 'lifterlms' ),
		'RS05' => _x( 'West Bačka', 'district', 'lifterlms' ),
		'RS15' => _x( 'Zaječar', 'district', 'lifterlms' ),
		'RS16' => _x( 'Zlatibor', 'district', 'lifterlms' ),
		'RS25' => _x( 'Kosovo', 'district', 'lifterlms' ),
		'RS26' => _x( 'Peć', 'district', 'lifterlms' ),
		'RS27' => _x( 'Prizren', 'district', 'lifterlms' ),
		'RS28' => _x( 'Kosovska Mitrovica', 'district', 'lifterlms' ),
		'RS29' => _x( 'Kosovo-Pomoravlje', 'district', 'lifterlms' ),
		'RSKM' => _x( 'Kosovo-Metohija', 'district', 'lifterlms' ),
		'RSVO' => _x( 'Vojvodina', 'district', 'lifterlms' ),
	),
	'RW' => array(),
	'SE' => array(),
	'UA' => array( // Ukrainian oblasts. https://github.com/unicode-org/cldr/blob/release-42/common/subdivisions/en.xml#L5243.
		'UA05' => __( 'Vinnychchyna', 'lifterlms' ),
		'UA07' => __( 'Volyn', 'lifterlms' ),
		'UA09' => __( 'Luhanshchyna', 'lifterlms' ),
		'UA12' => __( 'Dnipropetrovshchyna', 'lifterlms' ),
		'UA14' => __( 'Donechchyna', 'lifterlms' ),
		'UA18' => __( 'Zhytomyrshchyna', 'lifterlms' ),
		'UA21' => __( 'Zakarpattia', 'lifterlms' ),
		'UA23' => __( 'Zaporizhzhya', 'lifterlms' ),
		'UA26' => __( 'Prykarpattia', 'lifterlms' ),
		'UA30' => __( 'Kyiv', 'lifterlms' ),
		'UA32' => __( 'Kyivshchyna', 'lifterlms' ),
		'UA35' => __( 'Kirovohradschyna', 'lifterlms' ),
		'UA40' => __( 'Sevastopol', 'lifterlms' ),
		'UA43' => __( 'Crimea', 'lifterlms' ),
		'UA46' => __( 'Lvivshchyna', 'lifterlms' ),
		'UA48' => __( 'Mykolayivschyna', 'lifterlms' ),
		'UA51' => __( 'Odeshchyna', 'lifterlms' ),
		'UA53' => __( 'Poltavshchyna', 'lifterlms' ),
		'UA56' => __( 'Rivnenshchyna', 'lifterlms' ),
		'UA59' => __( 'Sumshchyna', 'lifterlms' ),
		'UA61' => __( 'Ternopilshchyna', 'lifterlms' ),
		'UA63' => __( 'Kharkivshchyna', 'lifterlms' ),
		'UA65' => __( 'Khersonshchyna', 'lifterlms' ),
		'UA68' => __( 'Khmelnychchyna', 'lifterlms' ),
		'UA71' => __( 'Cherkashchyna', 'lifterlms' ),
		'UA74' => __( 'Chernihivshchyna', 'lifterlms' ),
		'UA77' => __( 'Chernivtsi Oblast', 'lifterlms' ),
	),
	'UG' => array( // Ugandan districts.
		'UG314' => __( 'Abim', 'lifterlms' ),
		'UG301' => __( 'Adjumani', 'lifterlms' ),
		'UG322' => __( 'Agago', 'lifterlms' ),
		'UG323' => __( 'Alebtong', 'lifterlms' ),
		'UG315' => __( 'Amolatar', 'lifterlms' ),
		'UG324' => __( 'Amudat', 'lifterlms' ),
		'UG216' => __( 'Amuria', 'lifterlms' ),
		'UG316' => __( 'Amuru', 'lifterlms' ),
		'UG302' => __( 'Apac', 'lifterlms' ),
		'UG303' => __( 'Arua', 'lifterlms' ),
		'UG217' => __( 'Budaka', 'lifterlms' ),
		'UG218' => __( 'Bududa', 'lifterlms' ),
		'UG201' => __( 'Bugiri', 'lifterlms' ),
		'UG235' => __( 'Bugweri', 'lifterlms' ),
		'UG420' => __( 'Buhweju', 'lifterlms' ),
		'UG117' => __( 'Buikwe', 'lifterlms' ),
		'UG219' => __( 'Bukedea', 'lifterlms' ),
		'UG118' => __( 'Bukomansimbi', 'lifterlms' ),
		'UG220' => __( 'Bukwa', 'lifterlms' ),
		'UG225' => __( 'Bulambuli', 'lifterlms' ),
		'UG416' => __( 'Buliisa', 'lifterlms' ),
		'UG401' => __( 'Bundibugyo', 'lifterlms' ),
		'UG430' => __( 'Bunyangabu', 'lifterlms' ),
		'UG402' => __( 'Bushenyi', 'lifterlms' ),
		'UG202' => __( 'Busia', 'lifterlms' ),
		'UG221' => __( 'Butaleja', 'lifterlms' ),
		'UG119' => __( 'Butambala', 'lifterlms' ),
		'UG233' => __( 'Butebo', 'lifterlms' ),
		'UG120' => __( 'Buvuma', 'lifterlms' ),
		'UG226' => __( 'Buyende', 'lifterlms' ),
		'UG317' => __( 'Dokolo', 'lifterlms' ),
		'UG121' => __( 'Gomba', 'lifterlms' ),
		'UG304' => __( 'Gulu', 'lifterlms' ),
		'UG403' => __( 'Hoima', 'lifterlms' ),
		'UG417' => __( 'Ibanda', 'lifterlms' ),
		'UG203' => __( 'Iganga', 'lifterlms' ),
		'UG418' => __( 'Isingiro', 'lifterlms' ),
		'UG204' => __( 'Jinja', 'lifterlms' ),
		'UG318' => __( 'Kaabong', 'lifterlms' ),
		'UG404' => __( 'Kabale', 'lifterlms' ),
		'UG405' => __( 'Kabarole', 'lifterlms' ),
		'UG213' => __( 'Kaberamaido', 'lifterlms' ),
		'UG427' => __( 'Kagadi', 'lifterlms' ),
		'UG428' => __( 'Kakumiro', 'lifterlms' ),
		'UG101' => __( 'Kalangala', 'lifterlms' ),
		'UG222' => __( 'Kaliro', 'lifterlms' ),
		'UG122' => __( 'Kalungu', 'lifterlms' ),
		'UG102' => __( 'Kampala', 'lifterlms' ),
		'UG205' => __( 'Kamuli', 'lifterlms' ),
		'UG413' => __( 'Kamwenge', 'lifterlms' ),
		'UG414' => __( 'Kanungu', 'lifterlms' ),
		'UG206' => __( 'Kapchorwa', 'lifterlms' ),
		'UG236' => __( 'Kapelebyong', 'lifterlms' ),
		'UG126' => __( 'Kasanda', 'lifterlms' ),
		'UG406' => __( 'Kasese', 'lifterlms' ),
		'UG207' => __( 'Katakwi', 'lifterlms' ),
		'UG112' => __( 'Kayunga', 'lifterlms' ),
		'UG407' => __( 'Kibaale', 'lifterlms' ),
		'UG103' => __( 'Kiboga', 'lifterlms' ),
		'UG227' => __( 'Kibuku', 'lifterlms' ),
		'UG432' => __( 'Kikuube', 'lifterlms' ),
		'UG419' => __( 'Kiruhura', 'lifterlms' ),
		'UG421' => __( 'Kiryandongo', 'lifterlms' ),
		'UG408' => __( 'Kisoro', 'lifterlms' ),
		'UG305' => __( 'Kitgum', 'lifterlms' ),
		'UG319' => __( 'Koboko', 'lifterlms' ),
		'UG325' => __( 'Kole', 'lifterlms' ),
		'UG306' => __( 'Kotido', 'lifterlms' ),
		'UG208' => __( 'Kumi', 'lifterlms' ),
		'UG333' => __( 'Kwania', 'lifterlms' ),
		'UG228' => __( 'Kween', 'lifterlms' ),
		'UG123' => __( 'Kyankwanzi', 'lifterlms' ),
		'UG422' => __( 'Kyegegwa', 'lifterlms' ),
		'UG415' => __( 'Kyenjojo', 'lifterlms' ),
		'UG125' => __( 'Kyotera', 'lifterlms' ),
		'UG326' => __( 'Lamwo', 'lifterlms' ),
		'UG307' => __( 'Lira', 'lifterlms' ),
		'UG229' => __( 'Luuka', 'lifterlms' ),
		'UG104' => __( 'Luwero', 'lifterlms' ),
		'UG124' => __( 'Lwengo', 'lifterlms' ),
		'UG114' => __( 'Lyantonde', 'lifterlms' ),
		'UG223' => __( 'Manafwa', 'lifterlms' ),
		'UG320' => __( 'Maracha', 'lifterlms' ),
		'UG105' => __( 'Masaka', 'lifterlms' ),
		'UG409' => __( 'Masindi', 'lifterlms' ),
		'UG214' => __( 'Mayuge', 'lifterlms' ),
		'UG209' => __( 'Mbale', 'lifterlms' ),
		'UG410' => __( 'Mbarara', 'lifterlms' ),
		'UG423' => __( 'Mitooma', 'lifterlms' ),
		'UG115' => __( 'Mityana', 'lifterlms' ),
		'UG308' => __( 'Moroto', 'lifterlms' ),
		'UG309' => __( 'Moyo', 'lifterlms' ),
		'UG106' => __( 'Mpigi', 'lifterlms' ),
		'UG107' => __( 'Mubende', 'lifterlms' ),
		'UG108' => __( 'Mukono', 'lifterlms' ),
		'UG334' => __( 'Nabilatuk', 'lifterlms' ),
		'UG311' => __( 'Nakapiripirit', 'lifterlms' ),
		'UG116' => __( 'Nakaseke', 'lifterlms' ),
		'UG109' => __( 'Nakasongola', 'lifterlms' ),
		'UG230' => __( 'Namayingo', 'lifterlms' ),
		'UG234' => __( 'Namisindwa', 'lifterlms' ),
		'UG224' => __( 'Namutumba', 'lifterlms' ),
		'UG327' => __( 'Napak', 'lifterlms' ),
		'UG310' => __( 'Nebbi', 'lifterlms' ),
		'UG231' => __( 'Ngora', 'lifterlms' ),
		'UG424' => __( 'Ntoroko', 'lifterlms' ),
		'UG411' => __( 'Ntungamo', 'lifterlms' ),
		'UG328' => __( 'Nwoya', 'lifterlms' ),
		'UG331' => __( 'Omoro', 'lifterlms' ),
		'UG329' => __( 'Otuke', 'lifterlms' ),
		'UG321' => __( 'Oyam', 'lifterlms' ),
		'UG312' => __( 'Pader', 'lifterlms' ),
		'UG332' => __( 'Pakwach', 'lifterlms' ),
		'UG210' => __( 'Pallisa', 'lifterlms' ),
		'UG110' => __( 'Rakai', 'lifterlms' ),
		'UG429' => __( 'Rubanda', 'lifterlms' ),
		'UG425' => __( 'Rubirizi', 'lifterlms' ),
		'UG431' => __( 'Rukiga', 'lifterlms' ),
		'UG412' => __( 'Rukungiri', 'lifterlms' ),
		'UG111' => __( 'Sembabule', 'lifterlms' ),
		'UG232' => __( 'Serere', 'lifterlms' ),
		'UG426' => __( 'Sheema', 'lifterlms' ),
		'UG215' => __( 'Sironko', 'lifterlms' ),
		'UG211' => __( 'Soroti', 'lifterlms' ),
		'UG212' => __( 'Tororo', 'lifterlms' ),
		'UG113' => __( 'Wakiso', 'lifterlms' ),
		'UG313' => __( 'Yumbe', 'lifterlms' ),
		'UG330' => __( 'Zombo', 'lifterlms' ),
	),
	'UM' => array(
		'81' => __( 'Baker Island', 'lifterlms' ),
		'84' => __( 'Howland Island', 'lifterlms' ),
		'86' => __( 'Jarvis Island', 'lifterlms' ),
		'67' => __( 'Johnston Atoll', 'lifterlms' ),
		'89' => __( 'Kingman Reef', 'lifterlms' ),
		'71' => __( 'Midway Atoll', 'lifterlms' ),
		'76' => __( 'Navassa Island', 'lifterlms' ),
		'95' => __( 'Palmyra Atoll', 'lifterlms' ),
		'79' => __( 'Wake Island', 'lifterlms' ),
	),
	'US' => array( // U.S. states.
		'AL' => __( 'Alabama', 'lifterlms' ),
		'AK' => __( 'Alaska', 'lifterlms' ),
		'AZ' => __( 'Arizona', 'lifterlms' ),
		'AR' => __( 'Arkansas', 'lifterlms' ),
		'CA' => __( 'California', 'lifterlms' ),
		'CO' => __( 'Colorado', 'lifterlms' ),
		'CT' => __( 'Connecticut', 'lifterlms' ),
		'DE' => __( 'Delaware', 'lifterlms' ),
		'DC' => __( 'District of Columbia', 'lifterlms' ),
		'FL' => __( 'Florida', 'lifterlms' ),
		'GA' => _x( 'Georgia', 'US state of Georgia', 'lifterlms' ),
		'HI' => __( 'Hawaii', 'lifterlms' ),
		'ID' => __( 'Idaho', 'lifterlms' ),
		'IL' => __( 'Illinois', 'lifterlms' ),
		'IN' => __( 'Indiana', 'lifterlms' ),
		'IA' => __( 'Iowa', 'lifterlms' ),
		'KS' => __( 'Kansas', 'lifterlms' ),
		'KY' => __( 'Kentucky', 'lifterlms' ),
		'LA' => __( 'Louisiana', 'lifterlms' ),
		'ME' => __( 'Maine', 'lifterlms' ),
		'MD' => __( 'Maryland', 'lifterlms' ),
		'MA' => __( 'Massachusetts', 'lifterlms' ),
		'MI' => __( 'Michigan', 'lifterlms' ),
		'MN' => __( 'Minnesota', 'lifterlms' ),
		'MS' => __( 'Mississippi', 'lifterlms' ),
		'MO' => __( 'Missouri', 'lifterlms' ),
		'MT' => __( 'Montana', 'lifterlms' ),
		'NE' => __( 'Nebraska', 'lifterlms' ),
		'NV' => __( 'Nevada', 'lifterlms' ),
		'NH' => __( 'New Hampshire', 'lifterlms' ),
		'NJ' => __( 'New Jersey', 'lifterlms' ),
		'NM' => __( 'New Mexico', 'lifterlms' ),
		'NY' => __( 'New York', 'lifterlms' ),
		'NC' => __( 'North Carolina', 'lifterlms' ),
		'ND' => __( 'North Dakota', 'lifterlms' ),
		'OH' => __( 'Ohio', 'lifterlms' ),
		'OK' => __( 'Oklahoma', 'lifterlms' ),
		'OR' => __( 'Oregon', 'lifterlms' ),
		'PA' => __( 'Pennsylvania', 'lifterlms' ),
		'RI' => __( 'Rhode Island', 'lifterlms' ),
		'SC' => __( 'South Carolina', 'lifterlms' ),
		'SD' => __( 'South Dakota', 'lifterlms' ),
		'TN' => __( 'Tennessee', 'lifterlms' ),
		'TX' => __( 'Texas', 'lifterlms' ),
		'UT' => __( 'Utah', 'lifterlms' ),
		'VT' => __( 'Vermont', 'lifterlms' ),
		'VA' => __( 'Virginia', 'lifterlms' ),
		'WA' => __( 'Washington', 'lifterlms' ),
		'WV' => __( 'West Virginia', 'lifterlms' ),
		'WI' => __( 'Wisconsin', 'lifterlms' ),
		'WY' => __( 'Wyoming', 'lifterlms' ),
		'AA' => __( 'Armed Forces (AA)', 'lifterlms' ),
		'AE' => __( 'Armed Forces (AE)', 'lifterlms' ),
		'AP' => __( 'Armed Forces (AP)', 'lifterlms' ),
	),
	'UY' => array( // Uruguayan states.
		'UY-AR' => __( 'Artigas', 'lifterlms' ),
		'UY-CA' => __( 'Canelones', 'lifterlms' ),
		'UY-CL' => __( 'Cerro Largo', 'lifterlms' ),
		'UY-CO' => __( 'Colonia', 'lifterlms' ),
		'UY-DU' => __( 'Durazno', 'lifterlms' ),
		'UY-FS' => __( 'Flores', 'lifterlms' ),
		'UY-FD' => __( 'Florida', 'lifterlms' ),
		'UY-LA' => __( 'Lavalleja', 'lifterlms' ),
		'UY-MA' => __( 'Maldonado', 'lifterlms' ),
		'UY-MO' => __( 'Montevideo', 'lifterlms' ),
		'UY-PA' => __( 'Paysandú', 'lifterlms' ),
		'UY-RN' => __( 'Río Negro', 'lifterlms' ),
		'UY-RV' => __( 'Rivera', 'lifterlms' ),
		'UY-RO' => __( 'Rocha', 'lifterlms' ),
		'UY-SA' => __( 'Salto', 'lifterlms' ),
		'UY-SJ' => __( 'San José', 'lifterlms' ),
		'UY-SO' => __( 'Soriano', 'lifterlms' ),
		'UY-TA' => __( 'Tacuarembó', 'lifterlms' ),
		'UY-TT' => __( 'Treinta y Tres', 'lifterlms' ),
	),
	'VE' => array( // Venezuelan states.
		'VE-A' => __( 'Capital', 'lifterlms' ),
		'VE-B' => __( 'Anzoátegui', 'lifterlms' ),
		'VE-C' => __( 'Apure', 'lifterlms' ),
		'VE-D' => __( 'Aragua', 'lifterlms' ),
		'VE-E' => __( 'Barinas', 'lifterlms' ),
		'VE-F' => __( 'Bolívar', 'lifterlms' ),
		'VE-G' => __( 'Carabobo', 'lifterlms' ),
		'VE-H' => __( 'Cojedes', 'lifterlms' ),
		'VE-I' => __( 'Falcón', 'lifterlms' ),
		'VE-J' => __( 'Guárico', 'lifterlms' ),
		'VE-K' => __( 'Lara', 'lifterlms' ),
		'VE-L' => __( 'Mérida', 'lifterlms' ),
		'VE-M' => __( 'Miranda', 'lifterlms' ),
		'VE-N' => __( 'Monagas', 'lifterlms' ),
		'VE-O' => __( 'Nueva Esparta', 'lifterlms' ),
		'VE-P' => __( 'Portuguesa', 'lifterlms' ),
		'VE-R' => __( 'Sucre', 'lifterlms' ),
		'VE-S' => __( 'Táchira', 'lifterlms' ),
		'VE-T' => __( 'Trujillo', 'lifterlms' ),
		'VE-U' => __( 'Yaracuy', 'lifterlms' ),
		'VE-V' => __( 'Zulia', 'lifterlms' ),
		'VE-W' => __( 'Federal Dependencies', 'lifterlms' ),
		'VE-X' => __( 'La Guaira (Vargas)', 'lifterlms' ),
		'VE-Y' => __( 'Delta Amacuro', 'lifterlms' ),
		'VE-Z' => __( 'Amazonas', 'lifterlms' ),
	),
	'VN' => array(),
	'YT' => array(),
	'ZA' => array( // South African states.
		'EC'  => __( 'Eastern Cape', 'lifterlms' ),
		'FS'  => __( 'Free State', 'lifterlms' ),
		'GP'  => __( 'Gauteng', 'lifterlms' ),
		'KZN' => __( 'KwaZulu-Natal', 'lifterlms' ),
		'LP'  => __( 'Limpopo', 'lifterlms' ),
		'MP'  => __( 'Mpumalanga', 'lifterlms' ),
		'NC'  => __( 'Northern Cape', 'lifterlms' ),
		'NW'  => __( 'North West', 'lifterlms' ),
		'WC'  => __( 'Western Cape', 'lifterlms' ),
	),
	'ZM' => array( // Zambian provinces.
		'ZM-01' => __( 'Western', 'lifterlms' ),
		'ZM-02' => __( 'Central', 'lifterlms' ),
		'ZM-03' => __( 'Eastern', 'lifterlms' ),
		'ZM-04' => __( 'Luapula', 'lifterlms' ),
		'ZM-05' => __( 'Northern', 'lifterlms' ),
		'ZM-06' => __( 'North-Western', 'lifterlms' ),
		'ZM-07' => __( 'Southern', 'lifterlms' ),
		'ZM-08' => __( 'Copperbelt', 'lifterlms' ),
		'ZM-09' => __( 'Lusaka', 'lifterlms' ),
		'ZM-10' => __( 'Muchinga', 'lifterlms' ),
	),
);
