<?php
/**
 * Currency Symbols
 *
 * Returns a map of currency codes and their symbols.
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                                                                         *
 * The data contained within this file is derived from various open-source *
 * projects and libraries.                                                 *
 *                                                                         *
 * See the README.md file in this directory for credits and more.          *
 *                                                                         *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                                                                         *
 * Note to contributors:                                                   *
 *                                                                         *
 * The data contained within this file is automatically generated. Do not  *
 * modify or submit pull requests on this file directly. If you've located *
 * an issue with any of the data contained within this file please open a  *
 * new issue at https://github.com/gocodebox/lifterlms/issues/new/choose.  *
 *                                                                         *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 * @package LifterLMS/i18n
 *
 * @see llms_get_currency_symbols()
 *
 * @since 5.0.0
 * @version 7.3.0
 */

defined( 'ABSPATH' ) || exit;

return array(
	'AED' => __( '&#1573;.&#1583;', 'lifterlms' ),
	'AFN' => __( '&#1547;', 'lifterlms' ),
	'ALL' => __( 'Lek', 'lifterlms' ),
	'AMD' => __( '&#1423;', 'lifterlms' ),
	'ANG' => __( '&#402;', 'lifterlms' ),
	'AOA' => __( 'Kz', 'lifterlms' ),
	'ARS' => __( '&#36;', 'lifterlms' ),
	'AUD' => __( '&#36;', 'lifterlms' ),
	'AWG' => __( '&#402;', 'lifterlms' ),
	'AZN' => __( 'm', 'lifterlms' ),
	'BAM' => __( 'KM', 'lifterlms' ),
	'BBD' => __( 'Bds&#36;', 'lifterlms' ),
	'BDT' => __( '&#2547;', 'lifterlms' ),
	'BGN' => __( '&#1051;&#1074;.', 'lifterlms' ),
	'BHD' => __( '.&#1583;.&#1576;', 'lifterlms' ),
	'BIF' => __( 'FBu', 'lifterlms' ),
	'BMD' => __( '&#36;', 'lifterlms' ),
	'BND' => __( 'B&#36;', 'lifterlms' ),
	'BOB' => __( 'Bs.', 'lifterlms' ),
	'BRL' => __( 'R&#36;', 'lifterlms' ),
	'BSD' => __( 'B&#36;', 'lifterlms' ),
	'BTC' => __( '&#8383;', 'lifterlms' ),
	'BTN' => __( 'Nu.', 'lifterlms' ),
	'BWP' => __( 'P', 'lifterlms' ),
	'BYN' => __( 'Br', 'lifterlms' ),
	'BZD' => __( '&#36;', 'lifterlms' ),
	'CAD' => __( '&#36;', 'lifterlms' ),
	'CDF' => __( 'FC', 'lifterlms' ),
	'CHF' => __( 'CHF', 'lifterlms' ),
	'CLP' => __( '&#36;', 'lifterlms' ),
	'CNY' => __( '&#165;', 'lifterlms' ),
	'COP' => __( '&#36;', 'lifterlms' ),
	'CRC' => __( '&#8353;', 'lifterlms' ),
	'CUC' => __( 'CUC', 'lifterlms' ),
	'CUP' => __( '&#36;', 'lifterlms' ),
	'CVE' => __( '&#36;', 'lifterlms' ),
	'CZK' => __( 'K&#269;', 'lifterlms' ),
	'DJF' => __( 'Fdj', 'lifterlms' ),
	'DKK' => __( 'Kr.', 'lifterlms' ),
	'DOP' => __( '&#36;', 'lifterlms' ),
	'DZD' => __( '&#1583;&#1580;', 'lifterlms' ),
	'EGP' => __( '&#1580;.&#1605;', 'lifterlms' ),
	'ERN' => __( 'Nfk', 'lifterlms' ),
	'ETB' => __( 'Nkf', 'lifterlms' ),
	'ETH' => __( 'ETH', 'lifterlms' ),
	'EUR' => __( '&#8364;', 'lifterlms' ),
	'FJD' => __( 'FJ&#36;', 'lifterlms' ),
	'FKP' => __( '&#163;', 'lifterlms' ),
	'GBP' => __( '&#163;', 'lifterlms' ),
	'GEL' => __( '&#4314;', 'lifterlms' ),
	'GHS' => __( 'GH&#8373;', 'lifterlms' ),
	'GIP' => __( '&#163;', 'lifterlms' ),
	'GMD' => __( 'D', 'lifterlms' ),
	'GNF' => __( 'FG', 'lifterlms' ),
	'GPP' => __( '&#163;', 'lifterlms' ),
	'GTQ' => __( 'Q', 'lifterlms' ),
	'GYD' => __( '&#36;', 'lifterlms' ),
	'HKD' => __( '&#36;', 'lifterlms' ),
	'HNL' => __( 'L', 'lifterlms' ),
	'HRK' => __( 'kn', 'lifterlms' ),
	'HTG' => __( 'G', 'lifterlms' ),
	'HUF' => __( 'Ft', 'lifterlms' ),
	'IDR' => __( 'Rp', 'lifterlms' ),
	'ILS' => __( '&#8362;', 'lifterlms' ),
	'IMP' => __( '&#163;', 'lifterlms' ),
	'INR' => __( '&#8377;', 'lifterlms' ),
	'IQD' => __( '&#1583;.&#1593;', 'lifterlms' ),
	'IRR' => __( '&#65020;', 'lifterlms' ),
	'ISK' => __( 'kr', 'lifterlms' ),
	'JEP' => __( '&#163;', 'lifterlms' ),
	'JMD' => __( 'J&#36;', 'lifterlms' ),
	'JOD' => __( '&#1575;.&#1583;', 'lifterlms' ),
	'JPY' => __( '&#165;', 'lifterlms' ),
	'KES' => __( 'KSh', 'lifterlms' ),
	'KGS' => __( '&#1083;&#1074;', 'lifterlms' ),
	'KHR' => __( 'KHR', 'lifterlms' ),
	'KMF' => __( 'CF', 'lifterlms' ),
	'KPW' => __( '&#8361;', 'lifterlms' ),
	'KRW' => __( '&#8361;', 'lifterlms' ),
	'KWD' => __( '&#1603;.&#1583;', 'lifterlms' ),
	'KYD' => __( '&#36;', 'lifterlms' ),
	// 'KZT' symbol manually updated, see https://github.com/gocodebox/lifterlms/issues/2475.
	'KZT' => __( '&#8376;', 'lifterlms' ),
	'LAK' => __( '&#8365;', 'lifterlms' ),
	'LBP' => __( '&#163;', 'lifterlms' ),
	'LKR' => __( 'Rs', 'lifterlms' ),
	'LRD' => __( '&#36;', 'lifterlms' ),
	'LSL' => __( 'L', 'lifterlms' ),
	'LTC' => __( 'LTC', 'lifterlms' ),
	'LYD' => __( '&#1583;.&#1604;', 'lifterlms' ),
	'MAD' => __( 'MAD', 'lifterlms' ),
	'MDL' => __( 'L', 'lifterlms' ),
	'MGA' => __( 'Ar', 'lifterlms' ),
	'MKD' => __( '&#1076;&#1077;&#1085;', 'lifterlms' ),
	'MMK' => __( 'K', 'lifterlms' ),
	'MNT' => __( '&#8366;', 'lifterlms' ),
	'MOP' => __( '&#36;', 'lifterlms' ),
	'MRO' => __( 'MRU', 'lifterlms' ),
	'MUR' => __( '&#8360;', 'lifterlms' ),
	'MVR' => __( 'Rf', 'lifterlms' ),
	'MWK' => __( 'MK', 'lifterlms' ),
	'MXN' => __( '&#36;', 'lifterlms' ),
	'MYR' => __( 'RM', 'lifterlms' ),
	'MZN' => __( 'MT', 'lifterlms' ),
	'NAD' => __( '&#36;', 'lifterlms' ),
	'NGN' => __( '&#8358;', 'lifterlms' ),
	'NIO' => __( 'C&#36;', 'lifterlms' ),
	'NOK' => __( 'kr', 'lifterlms' ),
	'NPR' => __( '&#8360;', 'lifterlms' ),
	'NZD' => __( '&#36;', 'lifterlms' ),
	'OMR' => __( '.&#1593;.&#1585;', 'lifterlms' ),
	'PAB' => __( 'B&#47;.', 'lifterlms' ),
	'PEN' => __( 'S&#47;.', 'lifterlms' ),
	'PGK' => __( 'K', 'lifterlms' ),
	'PHP' => __( '&#8369;', 'lifterlms' ),
	'PKR' => __( '&#8360;', 'lifterlms' ),
	'PLN' => __( 'z&#322;', 'lifterlms' ),
	'PRB' => __( '&#8381;', 'lifterlms' ),
	'PYG' => __( '&#8370;', 'lifterlms' ),
	'QAR' => __( '&#1602;.&#1585;', 'lifterlms' ),
	'RON' => __( 'lei', 'lifterlms' ),
	'RSD' => __( 'din', 'lifterlms' ),
	'RUB' => __( '&#8381;', 'lifterlms' ),
	'RWF' => __( 'FRw', 'lifterlms' ),
	'SAR' => __( '&#65020;', 'lifterlms' ),
	'SBD' => __( 'Si&#36;', 'lifterlms' ),
	'SCR' => __( 'SRe', 'lifterlms' ),
	'SDG' => __( '.&#1587;.&#1580;', 'lifterlms' ),
	'SEK' => __( 'kr', 'lifterlms' ),
	'SGD' => __( '&#36;', 'lifterlms' ),
	'SHP' => __( '&#163;', 'lifterlms' ),
	'SLL' => __( 'Le', 'lifterlms' ),
	'SOS' => __( 'Sh.so.', 'lifterlms' ),
	'SRD' => __( '&#36;', 'lifterlms' ),
	'SSP' => __( '&#163;', 'lifterlms' ),
	'STD' => __( 'Db', 'lifterlms' ),
	'SYP' => __( 'LS', 'lifterlms' ),
	'SZL' => __( 'E', 'lifterlms' ),
	'THB' => __( '&#3647;', 'lifterlms' ),
	'TJS' => __( 'SM', 'lifterlms' ),
	'TMT' => __( 'T', 'lifterlms' ),
	'TND' => __( '&#1578;.&#1583;', 'lifterlms' ),
	'TOP' => __( '&#36;', 'lifterlms' ),
	'TRY' => __( '&#8378;', 'lifterlms' ),
	'TTD' => __( '&#36;', 'lifterlms' ),
	'TWD' => __( '&#36;', 'lifterlms' ),
	'TZS' => __( 'TSh', 'lifterlms' ),
	'UAH' => __( '&#8372;', 'lifterlms' ),
	'UGX' => __( 'USh', 'lifterlms' ),
	'USD' => __( '&#36;', 'lifterlms' ),
	'UYU' => __( '&#36;', 'lifterlms' ),
	'UZS' => __( '&#1083;&#1074;', 'lifterlms' ),
	'VEF' => __( 'Bs', 'lifterlms' ),
	'VND' => __( '&#8363;', 'lifterlms' ),
	'VUV' => __( 'VT', 'lifterlms' ),
	'WST' => __( 'SAT', 'lifterlms' ),
	'XAF' => __( 'FCFA', 'lifterlms' ),
	'XCD' => __( '&#36;', 'lifterlms' ),
	'XOF' => __( 'CFA', 'lifterlms' ),
	'XPF' => __( '&#8355;', 'lifterlms' ),
	'YER' => __( '&#65020;', 'lifterlms' ),
	'ZAR' => __( 'R', 'lifterlms' ),
	'ZMW' => __( 'ZK', 'lifterlms' ),
	'ZWL' => __( '&#36;', 'lifterlms' ),
);
