<?php
/**
 * The plugin bootstrap file
 *
 * @link              http://www.lenochat.com
 * @since             1.0.4
 * @package           LenoChat
 *
 * @wordpress-plugin
 * Plugin Name:       LenoChat
 * Plugin URI:        http://www.lenochat.com
 * Description:       Real-Time Conversations Made Simple! Enjoy engaging with your website visitors in real-time using LenoChat. Max out Customer Experience & Skyrocket Your Business Growth Deliver better support, faster responses, and stronger connections.
 * Version:           1.0.4
 * Author:            LenoChat
 * Author URI:        https://www.lenochat.com
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 */

// If this file is called directly, abort.
if (!defined("WPINC")) {
    die();
}

// Define constants for the plugin
define("LENOCHAT_VERSION", "1.0.4");
define("LENOCHAT_PLUGIN_DIR", plugin_dir_path(__FILE__));
define("LENOCHAT_PLUGIN_URL", plugin_dir_url(__FILE__));

// Include the dependencies needed to instantiate the plugin.
foreach (glob(LENOCHAT_PLUGIN_DIR . "admin/*.php") as $file) {
    include_once $file;
}

/**
 * Load environment variables with fallback values
 *
 * @return array Environment variables
 */
function lenochat_load_env()
{
    try {
        return lenochat_load_env_func();
    } catch (Exception $e) {
        return [
            "LENOCHAT_JS_URL" => "https://my-cdn.lenochat.com/lenochat.js",
            "AUTH_URL" => "https://8twcxgmmjb.execute-api.us-east-1.amazonaws.com/prod/v1/public/auth",
            "LENOCHAT_MENU_ICON_URL" => "https://my-cdn.lenochat.com/assets/lenochat/lenochaticon.png",
        ];
    }
}

add_action("plugins_loaded", "lenochat_init_plugin");

/**
 * Starts the plugin.
 *
 * @since 1.0.0
 */
function lenochat_init_plugin()
{
    $plugin = new LenoChat_Submenu(new LenoChat_Submenu_Page());
    $plugin->init();
}

/**
 * Register and enqueue LenoChat script when active
 */
function lenochat_register_scripts()
{
    $status = get_option("lenochat_status", "0");

    if ($status == "1") {
        try {
            $env = lenochat_load_env_func();
            $lenochat_js_url = isset($env["LENOCHAT_JS_URL"]) ? esc_url($env["LENOCHAT_JS_URL"]) : "";
            $license = get_option("lenochat_license");

            if (empty($lenochat_js_url) || empty($license)) {
                return;
            }

            // Additional security check
            $license = is_string($license) ? esc_js($license) : "";

            // Use IIFE pattern for dynamic script injection
            wp_register_script("lenochat-loader", "", [], LENOCHAT_VERSION, false);
            wp_add_inline_script(
                "lenochat-loader",
                'window.__yoda = window.__yoda || {};
                window.__yoda.license = ' . $license . ';
                window.__yoda.platform = 20;
                (function () {
                    var yoda_time = Math.round(new Date().getTime() / 1000);
                    var yoda_lc = document.createElement("script");
                    yoda_lc.type = "text/javascript";
                    yoda_lc.async = true;
                    yoda_lc.src = "' . $lenochat_js_url . '?d=" + yoda_time;
                    var s = document.getElementsByTagName("script")[0];
                    s.parentNode.insertBefore(yoda_lc, s);
                })();'
            );

            wp_enqueue_script("lenochat-loader");
        } catch (Exception $e) {
            // Silently exit on error
            return;
        }
    }
}

// Hook scripts to front-end loading
add_action("wp_enqueue_scripts", "lenochat_register_scripts");

/**
 * Plugin activation handler
 * Sets default status when plugin is activated
 */
function lenochat_activate()
{
    if (get_option("lenochat_status") === false) {
        add_option("lenochat_status", "0");
    }
}
register_activation_hook(__FILE__, "lenochat_activate");
