<?php
/**
 * Load environment variables from a data file.
 *
 * @return array The environment variables as an associative array.
 * @throws \Exception If the data file is not found.
 */
function lenochat_load_env_func()
{
    static $env = null;

    if ($env !== null) {
        return $env;
    }

    $filePath = dirname(__DIR__) . "/data-env.php";

    if (!file_exists($filePath)) {
        throw new \Exception("Environment data file not found: " . esc_html($filePath));
    }

    $env = include $filePath;

    if (!is_array($env)) {
        $env = [];
        $lines = file($filePath, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

        foreach ($lines as $line) {
            if (strpos(trim($line), "#") === 0) {
                continue;
            }

            list($name, $value) = explode("=", $line, 2);
            $name = trim($name);
            $value = trim($value);

            if (!empty($name)) {
                $env[$name] = $value;
            }
        }
    }

    return $env;
}
