<?php
/**
 * Plugin Name: Lean Video and Audio Player
 * Plugin URI: 
 * Description: Simple shortcode-based video and audio player supporting HTML5, YouTube, Vimeo and MP3 files.
 * Version: 1.0.1
 * Author: AZPlugins
 * Author URI: 
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: lean-video-and-audio-player
 * Domain Path: /languages
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Define plugin constants
define('LVNAP_VERSION', '1.0.1');
define('LVNAP_PLUGIN_URL', plugins_url('', __FILE__) );
define('LVNAP_PLUGIN_PATH', dirname( __FILE__ ));

/**
 * Main plugin class
 */
class LVNAP_Main {

    /**
     * Instance of this class
     */
    private static $instance = null;

    /**
     * Get instance
     */
    public static function get_instance() {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    /**
     * Constructor
     */
    private function __construct() {
        add_action('plugins_loaded', array($this, 'plugins_loaded_cb'));
        add_action('init', array($this, 'init_cb'));
        add_action('wp_enqueue_scripts', array($this, 'enqueue_scripts'));
    }

    public function plugins_loaded_cb() {        
        // Include required files
        $this->include_files();
    }

    public function init_cb() {        
        if (is_admin()) {
            LVNAP_Admin::get_instance();
        }
    }

    /**
     * Include required files
     */
    private function include_files() {
        require_once LVNAP_PLUGIN_PATH . '/includes/class-shortcodes.php';
        
        if (is_admin()) {
            require_once LVNAP_PLUGIN_PATH . '/includes/class-admin.php';
        }
    }

    /**
     * Enqueue scripts and styles
     */
    public function enqueue_scripts() {
        
        // Only enqueue if shortcode is used on the page
        if ($this->has_shortcode()) {
            wp_enqueue_style('lvnap-plyr-css', LVNAP_PLUGIN_URL . '/assets/css/plyr.css', array(), LVNAP_VERSION);
            wp_enqueue_style('lvnap-main-css', LVNAP_PLUGIN_URL . '/assets/css/main.css', array(), LVNAP_VERSION);
            
            wp_enqueue_script('lvnap-plyr-js', LVNAP_PLUGIN_URL . '/assets/js/plyr.min.js', array('jquery'), LVNAP_VERSION, true);
            wp_enqueue_script('lvnap-plyr-polyfilled-js', LVNAP_PLUGIN_URL . '/assets/js/plyr.polyfilled.min.js', array('jquery'), LVNAP_VERSION, true);
            wp_enqueue_script('lvnap-main-js', LVNAP_PLUGIN_URL . '/assets/js/main.js', array('jquery', 'lvnap-plyr-js'), LVNAP_VERSION, true);
        }
    }

    /**
     * Check if shortcode is used on current page
     */
    private function has_shortcode() {
        global $post;
        
        if (is_a($post, 'WP_Post')) {
            return has_shortcode($post->post_content, 'lean_video_player') || has_shortcode($post->post_content, 'lean_audio_player');
        }
        
        return false;
    }
}

// Initialize plugin
LVNAP_Main::get_instance();