<?php
/**
 * Admin panel handler class
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

class LVNAP_Admin {

    /**
     * Instance of this class
     */
    private static $instance = null;

    /**
     * Get instance
     */
    public static function get_instance() {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    /**
     * Constructor
     */
    private function __construct() {
        add_action('admin_menu', array($this, 'add_admin_menu'));
        add_action('admin_enqueue_scripts', array($this, 'admin_enqueue_scripts'));
    }

    /**
     * Add admin menu
     */
    public function add_admin_menu() {
        add_menu_page(
            esc_html__('Lean Player', 'lean-video-and-audio-player'),
            esc_html__('Lean Player', 'lean-video-and-audio-player'),
            'manage_options',
            'lean-player',
            array($this, 'admin_page'),
            'dashicons-video-alt3',
            30
        );
    }

    /**
     * Enqueue admin scripts
     */
    public function admin_enqueue_scripts($hook) {
        if ('toplevel_page_lean-player' !== $hook) {
            return;
        }

        wp_enqueue_style('lvnap-admin-style', LVNAP_PLUGIN_URL . 'assets/css/admin.css', array(), LVNAP_VERSION);
    }

    /**
     * Admin page content
     */
    public function admin_page() {
        ?>
        <div class="wrap">
            <h1><?php echo esc_html__('Lean Player - Shortcodes Documentation', 'lean-video-and-audio-player'); ?></h1>
            
            <div class="card">
                <h2><?php echo esc_html__('Video Player Shortcode', 'lean-video-and-audio-player'); ?></h2>
                <p><?php echo esc_html__('Use this shortcode to embed video players anywhere on your site.', 'lean-video-and-audio-player'); ?></p>
                
                <table class="wp-list-table widefat fixed striped">
                    <thead>
                        <tr>
                            <th><?php echo esc_html__('Attribute', 'lean-video-and-audio-player'); ?></th>
                            <th><?php echo esc_html__('Description', 'lean-video-and-audio-player'); ?></th>
                            <th><?php echo esc_html__('Default', 'lean-video-and-audio-player'); ?></th>
                            <th><?php echo esc_html__('Example', 'lean-video-and-audio-player'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td><code>type</code></td>
                            <td><?php echo esc_html__('Video type: youtube, vimeo, or html5', 'lean-video-and-audio-player'); ?></td>
                            <td>youtube</td>
                            <td><code>type="youtube"</code></td>
                        </tr>
                        <tr>
                            <td><code>id</code></td>
                            <td><?php echo esc_html__('Video ID for YouTube/Vimeo, or full URL for HTML5', 'lean-video-and-audio-player'); ?></td>
                            <td><?php echo esc_html__('None (Required)', 'lean-video-and-audio-player'); ?></td>
                            <td><code>id="dQw4w9WgXcQ"</code></td>
                        </tr>
                        <tr>
                            <td><code>autoplay</code></td>
                            <td><?php echo esc_html__('Enable autoplay (true/false)', 'lean-video-and-audio-player'); ?></td>
                            <td>false</td>
                            <td><code>autoplay="true"</code></td>
                        </tr>
                        <tr>
                            <td><code>muted</code></td>
                            <td><?php echo esc_html__('Start muted (true/false)', 'lean-video-and-audio-player'); ?></td>
                            <td>false</td>
                            <td><code>muted="true"</code></td>
                        </tr>
                    </tbody>
                </table>

                <h3><?php echo esc_html__('Video Player Examples:', 'lean-video-and-audio-player'); ?></h3>
                <div class="lvnap-examples">
                    <h4><?php echo esc_html__('YouTube Video:', 'lean-video-and-audio-player'); ?></h4>
                    <code>[lean_video_player type="youtube" id="dQw4w9WgXcQ"]</code>
                    
                    <h4><?php echo esc_html__('Vimeo Video:', 'lean-video-and-audio-player'); ?></h4>
                    <code>[lean_video_player type="vimeo" id="76979871"]</code>
                    
                    <h4><?php echo esc_html__('HTML5 Video:', 'lean-video-and-audio-player'); ?></h4>
                    <code>[lean_video_player type="html5" id="https://example.com/video.mp4" autoplay="true" muted="true"]</code>
                </div>
            </div>

            <div class="card">
                <h2><?php echo esc_html__('Audio Player Shortcode', 'lean-video-and-audio-player'); ?></h2>
                <p><?php echo esc_html__('Use this shortcode to embed audio players anywhere on your site.', 'lean-video-and-audio-player'); ?></p>
                
                <table class="wp-list-table widefat fixed striped">
                    <thead>
                        <tr>
                            <th><?php echo esc_html__('Attribute', 'lean-video-and-audio-player'); ?></th>
                            <th><?php echo esc_html__('Description', 'lean-video-and-audio-player'); ?></th>
                            <th><?php echo esc_html__('Default', 'lean-video-and-audio-player'); ?></th>
                            <th><?php echo esc_html__('Example', 'lean-video-and-audio-player'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td><code>src</code></td>
                            <td><?php echo esc_html__('Audio file URL', 'lean-video-and-audio-player'); ?></td>
                            <td><?php echo esc_html__('None (Required)', 'lean-video-and-audio-player'); ?></td>
                            <td><code>src="https://example.com/audio.mp3"</code></td>
                        </tr>
                        <tr>
                            <td><code>autoplay</code></td>
                            <td><?php echo esc_html__('Enable autoplay (true/false)', 'lean-video-and-audio-player'); ?></td>
                            <td>false</td>
                            <td><code>autoplay="true"</code></td>
                        </tr>
                        <tr>
                            <td><code>muted</code></td>
                            <td><?php echo esc_html__('Start muted (true/false)', 'lean-video-and-audio-player'); ?></td>
                            <td>false</td>
                            <td><code>muted="true"</code></td>
                        </tr>
                    </tbody>
                </table>

                <h3><?php echo esc_html__('Audio Player Examples:', 'lean-video-and-audio-player'); ?></h3>
                <div class="lvnap-examples">
                    <h4><?php echo esc_html__('Basic Audio:', 'lean-video-and-audio-player'); ?></h4>
                    <code>[lean_audio_player src="https://example.com/song.mp3"]</code>
                    
                    <h4><?php echo esc_html__('Auto-playing Muted Audio:', 'lean-video-and-audio-player'); ?></h4>
                    <code>[lean_audio_player src="https://example.com/song.mp3" autoplay="true" muted="true"]</code>
                </div>
            </div>

            <div class="card">
                <h2><?php echo esc_html__('Important Notes', 'lean-video-and-audio-player'); ?></h2>
                <ul>
                    <li><?php echo esc_html__('Autoplay policies vary by browser. For best results, use muted="true" with autoplay.', 'lean-video-and-audio-player'); ?></li>
                    <li><?php echo esc_html__('For YouTube videos, use only the video ID (e.g., "dQw4w9WgXcQ"), not the full URL.', 'lean-video-and-audio-player'); ?></li>
                    <li><?php echo esc_html__('For Vimeo videos, use only the video ID (e.g., "76979871"), not the full URL.', 'lean-video-and-audio-player'); ?></li>
                    <li><?php echo esc_html__('For HTML5 videos and audio files, use the complete URL to the media file.', 'lean-video-and-audio-player'); ?></li>
                </ul>
            </div>
        </div>
        <?php
    }
}