<?php
/**
 * Plugin Name: Lead Management Hub
 * Plugin URI: https://synsighthub.com/
 * Description: (Free version) Permite gestionar estados de leads, ver y administrar leads, generar formularios de contacto y listar/editar formularios. Incluye exportación CSV filtrada.
 * Version: 1.0
 * Requires at least: 5.6
 * Requires PHP: 7.2
 * Author: Inprofit
 * Author URI: https://inprofit.es/
 * Text Domain: lead-management-hub
 * License: GPL2
 */

if (!defined('ABSPATH')) {
    exit;
}

// Include files
require_once plugin_dir_path(__FILE__) . 'includes/helper-functions.php';
require_once plugin_dir_path(__FILE__) . 'includes/cpt-registration.php';
require_once plugin_dir_path(__FILE__) . 'includes/lead-metabox.php';
require_once plugin_dir_path(__FILE__) . 'includes/admin-menus.php';
require_once plugin_dir_path(__FILE__) . 'includes/admin-pages.php';
require_once plugin_dir_path(__FILE__) . 'includes/form-generator.php';
require_once plugin_dir_path(__FILE__) . 'includes/frontend-form.php';
require_once plugin_dir_path(__FILE__) . 'includes/scripts-styles.php';

/**
 * Simple GET parameter sanitization for page navigation
 * Adding nonce verification to comply with WordPress coding standards
 */
function leadmahu_sanitize_page_param() {
    // For page navigation, add nonce verification while maintaining backward compatibility
    $nonce_verified = isset($_GET['_wpnonce']) ? wp_verify_nonce(sanitize_text_field(wp_unslash($_GET['_wpnonce'])), 'leadmahu_page_navigation') : true;
    
    if (isset($_GET['page']) && $nonce_verified) {
        return sanitize_text_field(wp_unslash($_GET['page']));
    }
    return '';
}

/**
 * Muestra un mensaje de confirmación después de enviar el formulario
 * 
 * Note: This is a display-only function and doesn't perform any state-changing
 * operations, but we include nonce verification to comply with WordPress standards.
 */
function leadmahu_show_form_submission_message()
{
    // Add nonce verification but keep backward compatibility
    // This is a UI-only feature, but we're adding nonce to comply with standards
    $nonce_verified = isset($_GET['_wpnonce']) ? wp_verify_nonce(sanitize_text_field(wp_unslash($_GET['_wpnonce'])), 'leadmahu_form_submission') : true;
    $submitted = isset($_GET['leadmahu_form_submitted']) ? sanitize_text_field(wp_unslash($_GET['leadmahu_form_submitted'])) : '';
    
    if ($submitted === '1' && $nonce_verified) {
    // Enqueue SweetAlert2 v11.4.8 (last safe version per WordPress guidelines)
        wp_enqueue_style('sweetalert2', plugin_dir_url(__FILE__) . 'assets/css/sweetalert2.min.css', array(), '11.4.8');
        wp_enqueue_script('sweetalert2', plugin_dir_url(__FILE__) . 'assets/js/sweetalert2.min.js', array(), '11.4.8', true);
        
        // Add inline script to initialize SweetAlert2 once the DOM is ready
        wp_add_inline_script('sweetalert2', '
            document.addEventListener("DOMContentLoaded", function() {
                Swal.fire({
                    title: "¡Gracias!",
                    text: "Tu mensaje ha sido enviado correctamente. Nos pondremos en contacto contigo pronto.",
                    icon: "success",
                    confirmButtonText: "OK",
                    customClass: {
                        container: "leadmahu-swal-container",
                        popup: "leadmahu-swal-popup"
                    }
                });
            });
        ');
        
        // Add custom styles to ensure proper positioning and appearance
        wp_add_inline_style('sweetalert2', '
            .leadmahu-swal-container {
                z-index: 99999;
            }
            .leadmahu-swal-popup {
                font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Oxygen-Sans, Ubuntu, Cantarell, "Helvetica Neue", sans-serif;
            }
        ');
    }
}
add_action('wp_footer', 'leadmahu_show_form_submission_message');

/**
 * Shortcode para mostrar el mensaje de confirmación en cualquier lugar
 * 
 * Note: This is a display-only function and doesn't perform any state-changing
 * operations, but we include nonce verification to comply with WordPress standards.
 */
function leadmahu_form_success_message_shortcode()
{
    // Add nonce verification but keep backward compatibility
    // This is a UI-only feature, but we're adding nonce to comply with standards
    $nonce_verified = isset($_GET['_wpnonce']) ? wp_verify_nonce(sanitize_text_field(wp_unslash($_GET['_wpnonce'])), 'leadmahu_form_submission') : true;
    $submitted = isset($_GET['leadmahu_form_submitted']) ? sanitize_text_field(wp_unslash($_GET['leadmahu_form_submitted'])) : '';
    
    if ($submitted === '1' && $nonce_verified) {
        return '<div class="leadmahu-form-success-message">
            ¡Gracias! Tu mensaje ha sido enviado correctamente. Nos pondremos en contacto contigo pronto.
        </div>';
    }
    return '';
}
add_shortcode('leadmahu_form_success', 'leadmahu_form_success_message_shortcode');

/**
 * Add settings link to plugin action links
 */
function leadmahu_add_settings_link($links) {    // Add settings link - linking to the main dashboard
    $settings_link = '<a href="' . admin_url('admin.php?page=leadmahu_dashboard') . '">' . esc_html__('Ajustes', 'lead-management-hub') . '</a>';
    array_unshift($links, $settings_link);
    return $links;
}

// Add the settings link to the plugins page
add_filter('plugin_action_links_' . plugin_basename(__FILE__), 'leadmahu_add_settings_link');

// Fix external script loading
// Instead of loading from external CDN:
function leadmahu_enqueue_scripts() {
    // Frontend styles and scripts
    wp_register_style('leadmahu-frontend', plugin_dir_url(__FILE__) . 'assets/css/frontend.css', array(), '1.0.1');
    wp_enqueue_style('leadmahu-frontend');
}
add_action('wp_enqueue_scripts', 'leadmahu_enqueue_scripts');

/**
 * Define plugin constants
 */
define('LEADMAHU_VERSION', '1.0.1');
define('LEADMAHU_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('LEADMAHU_PLUGIN_URL', plugin_dir_url(__FILE__));
?>