<?php
/**
 * Registro de Custom Post Types y Metaboxes
 */

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Registro de Custom Post Types: leadmahu_lead y leadmahu_form
 */
function leadmahu_register_cpts() {
    // Registro de Leads
    $labels_lead = array(
        'name'               => 'Leads',
        'singular_name'      => 'Lead',
        'add_new'            => 'Añadir Nuevo',
        'add_new_item'       => 'Añadir Nuevo Lead',
        'edit_item'          => 'Editar Lead',
        'new_item'           => 'Nuevo Lead',
        'all_items'          => 'Todos los Leads',
        'view_item'          => 'Ver Lead',
        'search_items'       => 'Buscar Leads',
        'not_found'          => 'No se encontraron Leads',
        'not_found_in_trash' => 'No se encontraron Leads en la papelera',
        'menu_name'          => 'Leads'
    );
    $args_lead = array(
        'labels'        => $labels_lead,
        'public'        => false,
        'show_ui'       => true,
        'show_in_menu'  => true,
        'supports'      => array('title', 'editor'),
        'menu_icon'     => 'dashicons-businessman',
        'has_archive'   => true,
    );
    register_post_type('leadmahu_lead', $args_lead);    // Registro de Formularios    
    $labels_form = array(
        'name'               => 'Formularios leadmahu',
        'singular_name'      => 'Formulario leadmahu',
        'add_new_item'       => 'Añadir Nuevo Formulario',
        'edit_item'          => 'Editar Formulario',
        'new_item'           => 'Nuevo Formulario',
        'menu_name'          => '' // Empty string to hide menu name
    );
    $args_form = array(
        'labels'        => $labels_form,
        'public'        => false,
        'show_ui'       => true, // Need this to be true for the post type functionality to work
        'show_in_menu'  => false, // This hides it from the admin menu
        'supports'      => array('title'),
        'has_archive'   => false,
    );
    register_post_type('leadmahu_form', $args_form);
}
add_action('init', 'leadmahu_register_cpts');

/**
 * Metabox para Leads
 */
function leadmahu_add_lead_meta_box() {
    add_meta_box(
        'leadmahu_lead_details',
        'Detalles del Lead',
        'leadmahu_lead_meta_box_callback',
        'leadmahu_lead',
        'normal',
        'high'
    );
}
add_action('add_meta_boxes', 'leadmahu_add_lead_meta_box');

function leadmahu_lead_meta_box_callback($post) {
    wp_nonce_field('leadmahu_save_lead_meta', 'leadmahu_lead_nonce');
    $phone = get_post_meta($post->ID, '_leadmahu_phone', true);
    $email = get_post_meta($post->ID, '_leadmahu_email', true);
    $company = get_post_meta($post->ID, '_leadmahu_company', true);
    $status = get_post_meta($post->ID, '_leadmahu_status', true);
    $observations = get_post_meta($post->ID, '_leadmahu_observations', true);
    ?>
    <p>
        <label for="leadmahu_phone"><strong>Teléfono:</strong></label><br>
        <input type="text" id="leadmahu_phone" name="leadmahu_phone" value="<?php echo esc_attr($phone); ?>" style="width:100%;">
    </p>
    <p>
        <label for="leadmahu_email"><strong>Email:</strong></label><br>
        <input type="email" id="leadmahu_email" name="leadmahu_email" value="<?php echo esc_attr($email); ?>" style="width:100%;">
    </p>
    <p>
        <label for="leadmahu_company"><strong>Empresa:</strong></label><br>
        <input type="text" id="leadmahu_company" name="leadmahu_company" value="<?php echo esc_attr($company); ?>" style="width:100%;">
    </p>
    <p>
        <label for="leadmahu_status"><strong>Estado:</strong></label><br>
        <select id="leadmahu_status" name="leadmahu_status" style="width:100%;">
            <?php
            $states = get_option('leadmahu_states', array('nuevo', 'contactado', 'convertido', 'perdido'));
            foreach ($states as $s) {
                echo '<option value="' . esc_attr($s) . '" ' . selected($status, $s, false) . '>' . esc_html(ucfirst($s)) . '</option>';
            }
            ?>
        </select>
    </p>
    <p>
        <label for="leadmahu_observations"><strong>Observaciones:</strong></label><br>
        <textarea id="leadmahu_observations" name="leadmahu_observations" style="width:100%;"><?php echo esc_textarea($observations); ?></textarea>
    </p>
    <?php
}

function leadmahu_save_lead_meta($post_id) {
    if (!isset($_POST['leadmahu_lead_nonce']) || !wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['leadmahu_lead_nonce'])), 'leadmahu_save_lead_meta')) {
        return;
    }
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;
    if (!current_user_can('edit_post', $post_id)) return;

    $fields = array('leadmahu_phone', 'leadmahu_email', 'leadmahu_company', 'leadmahu_status', 'leadmahu_observations');
    foreach ($fields as $field) {
        if (isset($_POST[$field])) {
            update_post_meta($post_id, '_' . $field, sanitize_text_field(wp_unslash($_POST[$field])));
        }
    }
}
add_action('save_post', 'leadmahu_save_lead_meta');
?>
