<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}


function leadmahu_add_lead_meta_box()
{
    add_meta_box(
        'leadmahu_lead_details',
        'Detalles del Lead',
        'leadmahu_lead_meta_box_callback',
        'leadmahu_lead',
        'normal',
        'high'
    );
}
add_action('add_meta_boxes', 'leadmahu_add_lead_meta_box');

function leadmahu_lead_meta_box_callback($post)
{
    wp_nonce_field('leadmahu_save_lead_meta', 'leadmahu_lead_nonce');
    $phone = get_post_meta($post->ID, '_leadmahu_phone', true);
    $email = get_post_meta($post->ID, '_leadmahu_email', true);
    $company = get_post_meta($post->ID, '_leadmahu_company', true);
    $status = get_post_meta($post->ID, '_leadmahu_status', true);
    $observations = get_post_meta($post->ID, '_leadmahu_observations', true);
    ?>
    <p>
        <label for="leadmahu_phone"><strong>Teléfono:</strong></label><br>
        <input type="text" id="leadmahu_phone" name="leadmahu_phone" value="<?php echo esc_attr($phone); ?>" style="width:100%;">
    </p>
    <p>
        <label for="leadmahu_email"><strong>Email:</strong></label><br>
        <input type="email" id="leadmahu_email" name="leadmahu_email" value="<?php echo esc_attr($email); ?>" style="width:100%;">
    </p>
    <p>
        <label for="leadmahu_company"><strong>Empresa:</strong></label><br>
        <input type="text" id="leadmahu_company" name="leadmahu_company" value="<?php echo esc_attr($company); ?>"
            style="width:100%;">
    </p>
    <p>
        <label for="leadmahu_status"><strong>Estado:</strong></label><br>
        <select id="leadmahu_status" name="leadmahu_status" style="width:100%;">
            <?php
            $states = get_option('leadmahu_states', array('nuevo', 'contactado', 'convertido', 'perdido'));
            foreach ($states as $s) {
                echo '<option value="' . esc_attr($s) . '" ' . selected($status, $s, false) . '>' . esc_html(ucfirst($s)) . '</option>';
            }
            ?>
        </select>
    </p>
    <p>
        <label for="leadmahu_observations"><strong>Observaciones:</strong></label><br>
        <textarea id="leadmahu_observations" name="leadmahu_observations"
            style="width:100%;"><?php echo esc_textarea($observations); ?></textarea>
    </p>
    <?php
}

function leadmahu_save_lead_meta($post_id)
{
    // Verify nonce
    if (!isset($_POST['leadmahu_lead_nonce']) || !wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['leadmahu_lead_nonce'])), 'leadmahu_save_lead_meta')) {
        return;
    }

    // Check autosave
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return;
    }

    // Check permissions
    if (!current_user_can('edit_post', $post_id)) {
        return;
    }

    // Save meta fields with proper sanitization
    if (isset($_POST['leadmahu_phone'])) {
        update_post_meta($post_id, '_leadmahu_phone', sanitize_text_field(wp_unslash($_POST['leadmahu_phone'])));
    }
    if (isset($_POST['leadmahu_email'])) {
        update_post_meta($post_id, '_leadmahu_email', sanitize_email(wp_unslash($_POST['leadmahu_email'])));
    }
    if (isset($_POST['leadmahu_company'])) {
        update_post_meta($post_id, '_leadmahu_company', sanitize_text_field(wp_unslash($_POST['leadmahu_company'])));
    }
    if (isset($_POST['leadmahu_status'])) {
        update_post_meta($post_id, '_leadmahu_status', sanitize_text_field(wp_unslash($_POST['leadmahu_status'])));
    }
    if (isset($_POST['leadmahu_observations'])) {
        update_post_meta($post_id, '_leadmahu_observations', sanitize_textarea_field(wp_unslash($_POST['leadmahu_observations'])));
    }
}
add_action('save_post_leadmahu_lead', 'leadmahu_save_lead_meta');
