<?php
/**
 * Funciones auxiliares para Lead Management Hub
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

/**
 * Genera un enlace seguro para editar un lead
 * 
 * @param int $lead_id ID del lead a editar
 * @return string URL segura con nonce para edición
 */
function leadmahu_get_edit_lead_link($lead_id) {
    return admin_url('admin.php?page=leadmahu_edit_lead&lead_id=' . $lead_id . '&_wpnonce=' . wp_create_nonce('edit_lead_' . $lead_id));
}

/**
 * Genera un enlace seguro para ver un lead
 * 
 * @param int $lead_id ID del lead a ver
 * @return string URL segura con nonce para visualización
 */
function leadmahu_get_view_lead_link($lead_id) {
    return admin_url('admin.php?page=leadmahu_view_lead&lead_id=' . $lead_id . '&_wpnonce=' . wp_create_nonce('view_lead_' . $lead_id));
}

/**
 * Genera un enlace seguro para eliminar un lead
 * 
 * @param int $lead_id ID del lead a eliminar
 * @return string URL segura con nonce para eliminación
 */
function leadmahu_get_delete_lead_link($lead_id) {
    return admin_url('admin-post.php?action=leadmahu_delete_lead&lead_id=' . $lead_id . '&_wpnonce=' . wp_create_nonce('delete_lead_nonce'));
}

/**
 * Función de registro seguro sin código de depuración
 */
function leadmahu_log($message) {
    // Función vacía para mantener compatibilidad sin usar error_log
    // Las llamadas a esta función se mantienen pero no generan logs en producción
}
