/* Admin Scripts for Lead Management Hub */

jQuery(document).ready(function($) {
    // Filter functionality for leads
    $('#leadmahu_filter_button').on('click', function() {
        var status = $('#leadmahu_filter_status').val();
        var search = $('#leadmahu_filter_search').val();
        var data = {
            'action': 'leadmahu_filter_leads',
            'status': status,
            'search': search,
            '_wpnonce': leadmahu_params.filter_nonce
        };
        $.post(ajaxurl, data, function(response) {
            $('#leadmahu_leads_table tbody').html(response);
        });
    });

    // Custom field management for form generator
    if ($('#custom-fields-container').length) {
        // Add custom field functionality
        $('#add-custom-field').click(function() {
            var newField = '<div class="custom-field"><label>Nombre del Campo:</label>' +
                '<input type="text" name="custom_field_names[]" required>' +
                '<label>Tipo de Campo:</label>' +
                '<select name="custom_field_types[]">' +
                '<option value="text">Texto</option>' +
                '<option value="email">Email</option>' +
                '<option value="textarea">Area de Texto</option>' +
                '<option value="number">Número</option>' +
                '</select>' +
                '<label><input type="checkbox" name="custom_field_required[]" value="1">Requerido</label>' +
                '<div class="number-limits" style="display: none;">' +
                '<label>Mínimo:</label><input type="number" name="custom_field_min[]" min="0">' +
                '<label>Máximo:</label><input type="number" name="custom_field_max[]" min="0">' +
                '</div>' +
                '<button type="button" class="remove-custom-field">Eliminar</button></div>';
            $('#custom-fields-container').append(newField);
        });
        
        // Remove custom field functionality
        $('#custom-fields-container').on('click', '.remove-custom-field', function() {
            $(this).parent('.custom-field').remove();
        });
        
        // Toggle number limits based on field type
        $('#custom-fields-container').on('change', 'select[name="custom_field_types[]"]', function() {
            var selectedValue = $(this).val();
            var numberLimits = $(this).siblings('.number-limits');
            if (selectedValue === 'number') {
                numberLimits.show();
            } else {
                numberLimits.hide();
            }
        });
        
        // Initialize fields on load
        $('select[name="custom_field_types[]"]').each(function() {
            var selectedValue = $(this).val();
            var numberLimits = $(this).siblings('.number-limits');
            if (selectedValue === 'number') {
                numberLimits.show();
            }
        });
    }
});
