<?php
/**
 * Plugin Name: Le Bang gallery
 * Plugin URI: https://lebang.vn/wordpress/le-bang-gallery-wordpress-plugin.html
 * Description: Integrate blueimp gallery script for native wordpress gallery
 * Version: 1.0.3
 * Author: Le Bang
 * Author URI: https://lebang.vn
 * Donate link:     https://www.paypal.com/donate/?cmd=_s-xclick&hosted_button_id=9HSAMKR54AHRC
 * License:         GPL-2.0+
 * License URI:     http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:     le-bang-gallery
 */

function lebang_gallery_init()
{
    if(is_single() && get_post_type() == 'post') // Just for post detail
    {
        define( 'LEBANG_GALLERY_BASE_URL', plugins_url( '', __FILE__ ) );

        wp_enqueue_style('lebang-gallery-css-blueimp-gallery', LEBANG_GALLERY_BASE_URL.'/css/blueimp-gallery.min.css');
        wp_enqueue_style('lebang-gallery-css', LEBANG_GALLERY_BASE_URL.'/css/lebang-gallery.css');

        wp_enqueue_script('jquery');

        wp_enqueue_script('lebang-gallery-script-blueimp-gallery', LEBANG_GALLERY_BASE_URL.'/js/blueimp-gallery.min.js', array(), false, true);
        wp_enqueue_script('lebang-gallery-script-init', LEBANG_GALLERY_BASE_URL.'/js/lebang-gallery.js', array(), false, true);
    }
}

function lebang_gallery_plugin_row_meta($links_array, $plugin_file_name)
{
    if(strpos($plugin_file_name, 'lebang-gallery') !== FALSE)
    {
        $links_array[] = '<a href="https://lebang.vn/wordpress/le-bang-gallery-wordpress-plugin.html" target="_blank">Home page</a>';
        $links_array[] = '<a href="https://www.youtube.com/watch?v=WtCQD8arQHY&feature=emb_title" target="_blank">Video</a>';
        $links_array[] = '<a href="https://www.paypal.com/donate/?cmd=_s-xclick&hosted_button_id=9HSAMKR54AHRC" target="_blank">Buy us a cup of coffee</a>';
    }

    return $links_array;
}

add_action('wp_enqueue_scripts', 'lebang_gallery_init', 99);

// Disable wp auto add <p> to the gallery html code
remove_filter( 'the_content', 'wpautop' );
remove_filter( 'the_excerpt', 'wpautop' );

if (defined('ABSPATH') && is_admin()) {
    // For the admin section
    add_filter('plugin_row_meta', 'lebang_gallery_plugin_row_meta', 10, 2);
}