function lebang_gallery_init()
{
    // Init blueimp Gallery lightbox - default hide control
    jQuery('body').append('<!-- The Gallery as lightbox dialog --> <div id="blueimp-gallery" class="blueimp-gallery" aria-label="image gallery" aria-modal="true" role="dialog" ></div>');

    jQuery('.wp-block-gallery').each(function(gallery_index, gallery) {
        // Convert Wordpress gallery format to blueimp gallery format
        var current_index = 0;
        jQuery(gallery).find('figure img').each(function(img_index, img) {
            var figcaption = jQuery(this.parentNode.parentNode).find('figcaption').length > 0 ? jQuery(this.parentNode.parentNode).find('figcaption')[0] : null;
            var caption = figcaption ? jQuery(figcaption).text() : '';
            var description = figcaption && jQuery(figcaption).attr('data-description') ? jQuery(figcaption).attr('data-description') : '';
            var img_fullsize_url = jQuery(img).attr('data-full-url') && jQuery(img).attr('data-full-url') != 'undefined' ? jQuery(img).attr('data-full-url') : jQuery(img).attr('src');
            var srcset = jQuery(img).attr('srcset') && jQuery(img).attr('srcset') != 'undefined' ? jQuery(img).attr('srcset') : img_fullsize_url + ' ' + jQuery(this).attr('width') + 'w';
            var sizes = jQuery(img).attr('sizes') && jQuery(img).attr('sizes') != 'undefined' ? jQuery(img).attr('sizes') : '(max-width: '+ jQuery(this).attr('width') +'px) 100vw, '+ jQuery(this).attr('width') +'px';

            var a_element = jQuery('<a />');
            jQuery(a_element).attr('href', img_fullsize_url);
            jQuery(a_element).attr('title', caption);
            jQuery(a_element).attr('data-description', description);
            jQuery(a_element).attr('data-index', current_index);
            jQuery(a_element).attr('data-srcset', srcset);
            jQuery(a_element).attr('data-sizes', sizes);

            jQuery(a_element).append(jQuery(img).clone());

            if(img.parentNode.nodeName == 'FIGURE')
                jQuery(img).replaceWith(a_element);
            else
                jQuery(img.parentNode).replaceWith(a_element);

            current_index++;
        });

        // Limit display the rows of gallery
        var window_width = jQuery(window).width();
        var gallery_class = jQuery(gallery).attr('class');

        var gallery_numphoto_in_rows = 3;
        var gallery_limit_rows = null;
        var gallery_limit_width = null;

        var match_column = gallery_class.match(/columns-(\d)+/);
        var match_limit_row = gallery_class.match(/limit-row-(\d)+/);
        var match_limit_width = gallery_class.match(/limit-width-([\d]+(px|%))/);

        if(match_column) gallery_numphoto_in_rows = match_column[1];
        if(match_limit_row) gallery_limit_rows = match_limit_row[1];
        if(match_limit_width) gallery_limit_width = match_limit_width[1];

        // Limit with of gallery
        if(gallery_limit_width) {
            jQuery(gallery).css('max-width', gallery_limit_width);
            jQuery(gallery).css('margin', '0 auto');
        }
        if(gallery_limit_rows > 0) {
            var num_photo_per_row = window_width >= 600 ? gallery_numphoto_in_rows : 2;
            var num_photo_display = num_photo_per_row * gallery_limit_rows;
            var num_photo = jQuery(gallery).find('li.blocks-gallery-item').length;

            jQuery(gallery).find('li.blocks-gallery-item').each(function(index, li) {
                if(index + 1 == num_photo_display) {

                    jQuery(this).css('position', 'relative');
                    jQuery(this).append('<button class="blueimp-gallery-view-more">+'+ (num_photo-num_photo_display) +'</button>')
                } else if(index + 1 > num_photo_display) {
                    jQuery(this).hide();
                }
            });
        }

        // Intergrate with blueimp Gallery
        jQuery(gallery).click(function(event)
        {
            jQuery('#blueimp-gallery').html(' <div class="slides" aria-live="polite"></div> <h3 class="title"></h3> <p class="description"></p> <a class="prev" aria-controls="blueimp-gallery" aria-label="previous slide" aria-keyshortcuts="ArrowLeft" ></a> <a class="next" aria-controls="blueimp-gallery" aria-label="next slide" aria-keyshortcuts="ArrowRight" ></a> <a class="close" aria-controls="blueimp-gallery" aria-label="close" aria-keyshortcuts="Escape" ></a> <a class="play-pause" aria-controls="blueimp-gallery" aria-label="play slideshow" aria-keyshortcuts="Space" aria-pressed="false" role="button" ></a> <ol class="indicator"></ol> ');

            event = event || window.event;

            var target = event.target || event.srcElement;
            var current_a_element = target.src ? target.parentNode : target;
            if(current_a_element.nodeName == 'BUTTON') current_a_element = jQuery(current_a_element.parentNode).find('figure > a')[0];
            var options = {
                event: event,
                index: current_a_element,
                continuous: false,
                fullscreen: true,
                closeOnSlideClick: true,
                onslide: function (index, slide) {

                    self = this;
                    var initializeAdditional = function (index, data, klass, self) {
                        var text = self.list[index].getAttribute(data) != 'undefined' ? self.list[index].getAttribute(data) : '',
                        node = self.container.find(klass);
                        node.empty();

                        if (text) {
                            node[0].appendChild(document.createTextNode(text));
                        }
                    };
                    initializeAdditional(index, 'data-description', '.description', self);
                }
            };


            var array_a_elements = jQuery(this).find('figure > a');
            blueimp.Gallery(array_a_elements, options)
        });
    });

}

jQuery(function () {
    lebang_gallery_init();
});