<?php
/**
 * Provide a public-facing view for the plugin
 *
 * This file renders the timetable view.
 *
 * @link       https://codeberg.org/Klasse-Methode/wp-lauti
 * @since      1.0.0
 *
 * @package    Lauti_Calendar
 * @subpackage Lauti_Calendar/public/partials
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>
<div class="lauti-container">
	<div class="lauti-tabs">
		<?php foreach ( $days as $key => $day ) : ?>
			<?php
			$day_active_class = '';
			if ( $day['active'] ) {
				$day_active_class = 'lauti-active';
			}
			?>
			<button class="lauti-tab <?php echo esc_attr( $day_active_class ); ?>" data-day="<?php echo esc_attr( $key ); ?>">
				<?php echo esc_html( $day['title'] ); ?>
			</button>
		<?php endforeach ?>
	</div>
	<?php foreach ( $days as $key => $day ) : ?>
		<?php
		$day_active_class = '';
		if ( ! $day['active'] ) {
			$day_active_class = 'lauti-hidden';
		}
		?>
		<div
			id="day-<?php echo esc_attr( $key ); ?>"
			class="lauti-timetable  cols-<?php echo esc_attr( count( $places ) ); ?> <?php echo esc_attr( $day_active_class ); ?>"
			style="height: <?php echo esc_attr( $day['height'] ) + 50; ?>px"
		>
			<div class="lauti-places cols-<?php echo esc_attr( count( $places ) ); ?>">
				<?php foreach ( $places as $i => $place ) : ?>
					<div class="col col-<?php echo esc_attr( $i + 1 ); ?>">
						<?php echo esc_html( $place ); ?>
					</div>
				<?php endforeach ?>
			</div>
			<div class="lauti-times">
				<?php while ( $day['start']->getTimestamp() < $day['end']->getTimestamp() ) : ?>
					<div style="top:<?php echo esc_attr( $this->timetable_y_offset( $day['start'], $start_hour ) ); ?>px">
						<?php echo esc_html( $day['start']->format( 'H:i' ) ); ?>
					</div>
					<?php $day['start']->add( new DateInterval( 'PT60M' ) ); ?>
				<?php endwhile ?>
			</div>
			<div class="lauti-events">
				<?php foreach ( $day['events'] as $event ) : ?>
					<div
						id="<?php echo esc_attr( $event->id ); ?>"
						class="h-event lauti-event col col-<?php echo esc_attr( $event->col ); ?> <?php echo esc_attr( implode( ' ', $event->tags ) ); ?>"
						style="top:<?php echo esc_attr( $event->top ); ?>px;min-height:<?php echo esc_attr( $event->height ); ?>px;height:<?php echo esc_attr( $event->height ); ?>px;"
						itemscope itemtype="https://schema.org/Event"
					>
						<h2 class="p-name" itemprop="name"><?php echo esc_attr( $event->name ); ?></h2>
						<span class="lauti-event-time">
							<time class="dt-start" itemprop="startDate" datetime="<?php echo esc_attr( $event->start->format( DateTime::ATOM ) ); ?>">
								<?php echo esc_html( $event->start->format( 'H:i' ) ); ?>
							</time>
							<?php if ( $event->end ) : ?>
							-
							<time class="dt-end" itemprop="endDate" datetime="<?php echo esc_attr( $event->end->format( DateTime::ATOM ) ); ?>">
								<?php echo esc_html( $event->end->format( 'H:i' ) ); ?>
							</time>
							<?php endif ?>
						</span>
						<div class="lauti-info lauti-organizers lauti-more">
							<?php if ( count( $event->organizers ) > 0 ) : ?>
								<div><?php echo esc_html( __( 'event-by', 'lauti-calendar' ) ); ?>:
									<?php foreach ( $event->organizers as $o => $organizer ) : ?>
										<span itemprop="organizer" ><?php echo esc_html( $organizer ); ?>
										<?php
										if ( $i + 1 < count( $event->organizers ) ) :
											?>
											, <?php endif ?></span>
									<?php endforeach ?>
								</div>
							<?php endif ?>
						</div>
						<?php if ( property_exists( $event, 'location' ) ) : ?>
							<div class="lauti-info lauti-location lauti-more">
								<?php echo esc_html( __( 'event-where', 'lauti-calendar' ) ); ?>: <span class="p-location" itemprop="location"><?php echo esc_html( $event->location ); ?></span>
							</div>
						<?php endif ?>
						<div class="lauti-info lauti-involved lauti-more">
							<?php if ( count( $event->involved ) > 0 ) : ?>
								<div><?php echo esc_html( __( 'event-with', 'lauti-calendar' ) ); ?>:
									<?php foreach ( $event->involved as $i => $involved ) : ?>
										<span itemprop="contributor"><?php echo esc_html( $involved->name ); ?></span>
										<?php
										if ( $i + 1 < count( $event->involved ) ) :
											?>
											, <?php endif ?>
									<?php endforeach ?>
								</div>
							<?php endif ?>
						</div>
						<div class="p-summary lauti-info lauti-description lauti-more" itemprop="description"><?php echo esc_html( $event->description ); ?></div>
						<div class="lauti-info lauti-involved lauti-more">
							<?php foreach ( $event->involved as $i => $involved ) : ?>
								<div itemprop="contributor"><?php echo esc_html( $involved->description ); ?></div>
							<?php endforeach ?>
						</div>
					</div>
				<?php endforeach ?>
			</div>
		</div>
	<?php endforeach ?>
	<?php if ( '' !== $options['instance-name'] ) : ?>
		<div class="lauti-powered-by"><?php echo esc_html( __( 'powered-by', 'lauti-calendar' ) ); ?> <a href="<?php echo esc_attr( $options['instance-url'] ); ?>"><?php echo esc_html( $options['instance-name'] ? $options['instance-name'] : __( 'LAUTI Calendar', 'lauti-calendar' ) ); ?></a></div>
	<?php endif; ?>
</div>
