<?php
/**
 * Provide a public-facing view for the plugin
 *
 * This file renders the list view.
 *
 * @link       https://codeberg.org/Klasse-Methode/wp-lauti
 * @since      1.0.0
 *
 * @package    Lauti_Calendar
 * @subpackage Lauti_Calendar/public/partials
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>
<div class="lauti-container">
	<div class="lauti-header">
		<?php echo esc_html( '' !== $title ? $title : __( 'list-headline', 'lauti-calendar' ) ); ?>
	</div>
	<div class="lauti-list">
		<?php if ( null === $events || count( $events ) === 0 ) : ?>
			<?php echo esc_html( __( 'list-empty', 'lauti-calendar' ) ); ?>
		<?php endif; ?>
		<?php foreach ( $events as $event ) : ?>
			<?php
			if ( property_exists( $event, 'link' ) ) :
				?>
			<a href="<?php echo esc_attr( $event->link ); ?>" target="blank"
			<?php else : ?>
			<div
			<?php endif; ?>
				<?php
				$can_open    = '';
				$is_canceled = '';
				if ( property_exists( $event, 'link' ) && ! $event->link ) {
					$can_open = 'canOpen';
				}
				if ( $event->canceled ) {
					$is_canceled = 'canceled';
				}
				?>
				id="<?php echo esc_attr( $event->id ); ?>"
				class="h-event lauti-event lauti-cols <?php echo esc_attr( $can_open ); ?> <?php echo esc_attr( $is_canceled ); ?>"
				itemscope itemtype="https://schema.org/Event"
			>
				<div class="lauti-left">
					<?php $is_multiday = null !== $event->end && $event->end->format( 'Y-m-d' ) !== $event->start->format( 'Y-m-d' ); ?>
					<?php if ( ! $is_multiday ) : ?>
						<?php echo esc_html( wp_date( 'd.m', $event->start->getTimestamp() ) ); ?>
					<?php endif; ?>
				</div>
				<div class="lauti-right">
					<?php
					$event_name = $event->name;
					if ( '' !== $is_canceled ) {
						$event_name = __( 'event-canceled', 'lauti-calendar' ) . ': ' . $event_name;
					}
					?>
					<h2 class="p-name" itemprop="name"><?php echo esc_html( $event_name ); ?></h2>
					<?php if ( $this->show_info( 'time', $infos ) && ! $is_multiday ) : ?>
						<span class="lauti-info lauti-time"><?php echo esc_html( __( 'event-when', 'lauti-calendar' ) ); ?>:
							<time class="dt-start" itemprop="startDate" datetime="<?php echo esc_attr( $event->start->format( DateTime::ATOM ) ); ?>">
								<?php echo esc_html( $event->start->format( 'H:i' ) ); ?>
							</time>
							<?php if ( null !== $event->end ) : ?>
								-
								<time class="dt-end" itemprop="endDate" datetime="<?php echo esc_attr( $event->end->format( DateTime::ATOM ) ); ?>">
									<?php echo esc_html( $event->end->format( 'H:i' ) ); ?>
								</time>
							<?php endif; ?>
						</span>
					<?php elseif ( $this->show_info( 'time', $infos ) && $is_multiday ) : ?>
						<span class="lauti-info lauti-time"><?php echo esc_html( __( 'event-when', 'lauti-calendar' ) ); ?>:
							<time class="dt-start" itemprop="startDate" datetime="<?php echo esc_attr( $event->start->format( DateTime::ATOM ) ); ?>">
								<?php echo esc_html( $event->start->format( 'd.m.' ) ); ?>
							</time>
							-
							<time class="dt-end" itemprop="endDate" datetime="<?php echo esc_attr( $event->end->format( DateTime::ATOM ) ); ?>">
								<?php echo esc_html( $event->end->format( 'd.m.' ) ); ?>
							</time>
						</span>
					<?php endif ?>
					<?php if ( $this->show_info( 'location', $infos ) && property_exists( $event, 'location' ) ) : ?>
						<div class="lauti-info lauti-location">
							<?php echo esc_html( __( 'event-where', 'lauti-calendar' ) ); ?>: <span class="p-location" itemprop="location"><?php echo esc_html( $event->location ); ?></span>
						</div>
					<?php endif ?>
					<?php if ( $this->show_info( 'organizers', $infos ) && count( $event->organizers ) > 0 ) : ?>
						<div class="lauti-info lauti-organizers">
							<div><?php echo esc_html( __( 'event-by', 'lauti-calendar' ) ); ?>:
								<?php foreach ( $event->organizers as $o => $organizer ) : ?>
									<span itemprop="organizer" ><?php echo esc_html( $organizer ); ?>
									<?php
									if ( $o + 1 < count( $event->organizers ) ) :
										?>
										, <?php endif ?></span>
								<?php endforeach ?>
							</div>
						</div>
					<?php endif ?>
					<?php if ( $this->show_info( 'involved', $infos ) && count( $event->involved ) > 0 ) : ?>
						<div class="lauti-info lauti-involved">
							<div><?php echo esc_html( __( 'event-with', 'lauti-calendar' ) ); ?>:
								<?php foreach ( $event->involved as $i => $involved ) : ?>
									<span itemprop="contributor"><?php echo esc_html( $involved->name ); ?></span>
									<?php
									if ( $i + 1 < count( $event->involved ) ) :
										?>
										, <?php endif ?>
								<?php endforeach ?>
							</div>
						</div>
					<?php endif ?>
					<?php if ( $this->show_info( 'description', $infos ) ) : ?>
						<p class="p-summary lauti-info lauti-description lauti-more" itemprop="description"><?php echo esc_html( $event->description ); ?></p>
					<?php endif ?>
				</div>
			<?php
			if ( property_exists( $event, 'link' ) ) :
				?>
				</a>
				<?php
				else :
					?>
					</div><?php endif; ?>
		<?php endforeach ?>
	</div>
	<?php if ( '' !== $options['instance-name'] ) : ?>
		<div class="lauti-powered-by"><?php echo esc_html( __( 'powered-by', 'lauti-calendar' ) ); ?> <a href="<?php echo esc_attr( $options['instance-url'] ); ?>"><?php echo esc_html( $options['instance-name'] ? $options['instance-name'] : __( 'LAUTI Calendar', 'lauti-calendar' ) ); ?></a></div>
	<?php endif; ?>
</div>
