(function($) {
	"use strict";

	/**
	 * All of the code for your public-facing JavaScript source
	 * should reside in this file.
	 *
	 * Note: It has been assumed you will write jQuery code here, so the
	 * $ function reference has been prepared for usage within the scope
	 * of this function.
	 *
	 * This enables you to define handlers, for when the DOM is ready:
	 *
	 * $(function() {
	 *
	 * });
	 *
	 * When the window is loaded:
	 *
	 * $( window ).load(function() {
	 *
	 * });
	 *
	 * ...and/or other possibilities.
	 *
	 * Ideally, it is not considered best practise to attach more than a
	 * single DOM-ready or window-load handler for a particular page.
	 * Although scripts in the WordPress core, Plugins and Themes may be
	 * practising this, we should strive to set a better example in our own work.
	 */

	$(window).load(function() {
		$(".lauti-tab").on("click", function(e) {
			const el = $(this);
			const day = el.attr("data-day");
			$(".lauti-timetable").addClass("lauti-hidden");
			const timetable = $(`#day-${day}`).removeClass("lauti-hidden");

			$(".lauti-tab").removeClass("lauti-active");
			el.addClass("lauti-active");
		});

		$(".lauti-event").on("click", function(e) {
			const el = $(this);
			// only open description when it is not a link
			var tag = $(el).prop("tagName").toLowerCase();
			if (tag === "a") return
			// Close all but the clicked event component.
			$(".lauti-event").each(function() {
				if (!$(this).is(el)) {
					$(this).removeClass("open");
				}
			});
			if (el.hasClass("open")) {
				el.removeClass("open");
			} else {
				el.addClass("open");
			}
		});
	});
})(jQuery);
