<?php
/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://codeberg.org/Klasse-Methode/wp-lauti
 * @since             1.0.0
 * @package           Lauti_Calendar
 *
 * @wordpress-plugin
 * Plugin Name:       LAUTI Calendar
 * Plugin URI:        https://codeberg.org/Klasse-Methode/wp-lauti
 * Description:       This Plugin integrates the LAUTI calendar into your WordPress site.
 * Version:           1.0.0
 * Author:            Klasse & Methode
 * Author URI:        https://klasse-methode.it/
 * License:           AGPL-3.0-only
 * License URI:       http://www.gnu.org/licenses/agpl-3.0.txt
 * Text Domain:       lauti-calendar
 * Domain Path:       /languages/
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'LAUTI_CALENDAR_VERSION', '1.0.0' );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-lauti-calendar-activator.php
 */
function activate_lauti_calendar() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-lauti-calendar-activator.php';
	Lauti_Calendar_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-lauti-calendar-deactivator.php
 */
function deactivate_lauti_calendar() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-lauti-calendar-deactivator.php';
	Lauti_Calendar_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_lauti_calendar' );
register_deactivation_hook( __FILE__, 'deactivate_lauti_calendar' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-lauti-calendar.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_lauti_calendar() {

	$plugin = new Lauti_Calendar();
	$plugin->run();
}
run_lauti_calendar();
