<?php
/**
 * Sanitization of plugin settings.
 *
 * @link       https://codeberg.org/Klasse-Methode/wp-lauti
 * @since      1.0.0
 *
 * @package    Lauti_Calendar
 * @subpackage Lauti_Calendar/admin
 */

/**
 * Sanitize all related settings for this plugin.
 *
 * @param      array $input    A object of settings.
 * @since    1.0.0
 */
function sanitize_instance_object( $input ) {
	$output = array();

	if ( is_array( $input ) ) {
		$output['instance-url']  = isset( $input['instance-url'] ) ? sanitize_text_field( $input['instance-url'] ) : '';
		$output['instance-name'] = isset( $input['instance-name'] ) ? sanitize_text_field( $input['instance-name'] ) : '';
	}

	return $output;
}
