<?php
/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://codeberg.org/Klasse-Methode/wp-lauti
 * @since      1.0.0
 *
 * @package    Lauti_Calendar
 * @subpackage Lauti_Calendar/admin/partials
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<!-- This file should primarily consist of HTML with a little bit of PHP. -->
<div class="card">
	<h1><?php esc_html_e( 'General', 'lauti-calendar' ); ?></h1>
	<form class="form" method="post" action="options.php">
		<?php settings_fields( $this->plugin_name ); ?>
		<div class="form-group">
			<label  for="<?php echo esc_attr( $this->plugin_name ); ?>[instance-url]"><?php esc_html_e( 'Instance URL', 'lauti-calendar' ); ?></label>
			<input class="form-control" type="url" id="<?php echo esc_attr( $this->plugin_name ); ?>[instance-url]" name="<?php echo esc_attr( $this->plugin_name ); ?>[instance-url]"  value="<?php echo esc_attr( get_option( $this->plugin_name )['instance-url'] ?? '' ); ?>" />
		</div>
		<div class="form-group">
			<label  for="<?php echo esc_attr( $this->plugin_name ); ?>[instance-name]"><?php esc_html_e( 'Instance Name', 'lauti-calendar' ); ?></label>
			<input class="form-control" type="text" id="<?php echo esc_attr( $this->plugin_name ); ?>[instance-name]" name="<?php echo esc_attr( $this->plugin_name ); ?>[instance-name]"  value="<?php echo esc_attr( get_option( $this->plugin_name )['instance-name'] ?? '' ); ?>" />
		</div>
		<button type="submit" class="button button-primary form-submit"><?php esc_html_e( 'Save', 'lauti-calendar' ); ?></button>
	</form>
</div>
