<?php
/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://codeberg.org/Klasse-Methode/wp-lauti
 * @since      1.0.0
 *
 * @package    Lauti_Calendar
 * @subpackage Lauti_Calendar/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Lauti_Calendar
 * @subpackage Lauti_Calendar/admin
 * @author     Klasse & Methode <member@klasse-methode.it>
 */
class Lauti_Calendar_Admin {


	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string $plugin_name       The name of this plugin.
	 * @param      string $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {
		/**
		 * Requires sanitization function.
		 */
		require_once plugin_dir_path( __DIR__ ) . 'admin/sanitize-lauti-calendar-settings-admin.php';

		$this->plugin_name = $plugin_name;
		$this->version     = $version;
	}

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Lauti_Calendar_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Lauti_Calendar_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/lauti-calendar-admin.css', array(), $this->version, 'all' );
	}

	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Lauti_Calendar_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Lauti_Calendar_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/lauti-calendar-admin.js', array( 'jquery' ), $this->version, false );
	}

	/**
	 * Register the administration menu for this plugin into the WordPress Dashboard menu.
	 *
	 * @since    1.0.0
	 */
	public function add_plugin_admin_menu() {

		/**
		 * Add a settings page for this plugin to the Settings menu.
		 *
		 * NOTE:  Alternative menu locations are available via WordPress administration menu functions.
		 *        Administration Menus: http://codex.wordpress.org/Administration_Menus
		 *        Plugin Check returns error if using $this->plugin_name in __()
		 */
		add_menu_page( __( 'Lauti Calendar', 'lauti-calendar' ), __( 'Lauti Calendar', 'lauti-calendar' ), 'manage_options', 'lauti-calendar', array( $this, 'display_plugin_setup_page' ), 'dashicons-calendar-alt', null );
	}

	/**
	 * Add settings action link to the plugins page.
	 *
	 * @param      array $links    A list of action links.
	 * @since    1.0.0
	 */
	public function add_action_links( $links ) {
		/*
		*  Documentation : https://codex.wordpress.org/Plugin_API/Filter_Reference/plugin_action_links_(plugin_file_name)
		*  NOTE:    Plugin Check returns error if using $this->plugin_name in __()
		*/
		$settings_link = array(
			'<a href="' . admin_url( 'options-general.php?page=' . $this->plugin_name ) . '">' . __( 'Settings', 'lauti-calendar' ) . '</a>',
		);
		return array_merge( $settings_link, $links );
	}


	/**
	 * Register all related settings for this plugin.
	 *
	 * @since    1.0.0
	 */
	public function register_plugin_settings() {
		register_setting(
			$this->plugin_name,
			$this->plugin_name,
			array(
				'type'              => 'object',
				'default'           => array(
					'instance-url'  => '',
					'instance-name' => '',
				),
				'sanitize_callback' => 'sanitize_instance_object',
				'show_in_rest'      => false,
			)
		);
	}

	/**
	 * Render the settings page for this plugin.
	 *
	 * @since    1.0.0
	 */
	public function display_plugin_setup_page() {
		include_once 'partials/lauti-calendar-admin-display.php';
	}
}
