=== LAUTI Calendar ===
Contributors: klasseundmethode
Tags: calendar, Event, events, timetable
Requires at least: 5.3
Tested up to: 6.8
Stable tag: 1.0.0
License: AGPL-3.0-only
License URI: https://www.gnu.org/licenses/agpl-3.0
Display events from your LAUTI instance on your WordPress site as a list or timetable. Ships with simple, adjustable CSS.

## Contents
- Overview
- Features
- Installation
- Configuration
- Shortcodes
  - List
  - Timetable
- Styling
- Troubleshooting
- Development
- Release
- License

## Overview
This plugin pulls events from a [LAUTI](https://lauti.org) instance and renders them in WordPress via shortcodes. Just set your instance, drop a shortcode on a page, and publish.

## Features
- Event list shortcode with optional links to LAUTI
- Timetable shortcode for multi-day events and rooms
- Minimal CSS you can override in your theme

## Installation
1. Download the latest release ZIP from the [releases page](https://codeberg.org/Klasse-Methode/wp-lauti/releases).
2. In WordPress admin, open Plugins → Add New → Upload Plugin.
3. Select the ZIP, install, and activate.

## Configuration
1. In the admin dashboard, open “Lauti Calendar”.
2. Set and save:
   - Instance URL: URL of your LAUTI instance.
   - Instance Name: Text shown next to “powered by” under the list.

Important: Save settings before inserting shortcodes to avoid errors when saving pages.

## Shortcodes

### List
Add to any page or post:

`
[lauti-calendar-list groupID=66b1a314-1234-5678-9123-1d53372d85ef title="Veranstaltungen" infos=time,location,description link=true]
`

Options:
- title: Heading text shown above the list.
- infos: Comma-separated fields to show. Supported: time, location, organizers, involved, description.
- groupID: UUID of your group (open your group in LAUTI and copy the ID from the URL).
- placeID: UUID of your place (open your place in LAUTI and copy the ID from the URL).
- link: true/false. If true, each event links to its page on your LAUTI instance.

Info: When entering groupID and placeID the filter applies both. You only see events from your group at the specific place.

### Timetable(experimental)
This solution is a bit hacky and was written for a specific need. It works in most cases, but
can be a bit quirky sometimes.
Render a timetable for a multi-day event across specific rooms/places:

`
[lauti-calendar-timetable id="2aa9e94b-1234-5678-9012-34a0f7c44c29" places="Raum Rosa,Raum Betty,Raum Clara,Raum Emma" startHour=9 endHour=23]
`

Options:
- id: UUID of a multi-day event.
- places: Comma-separated list of place names. This list has to match the option "Extra information for location" of an event exactly.
- startHour: Starting hour of the timetable (integer, 0–23).
- endHour: Ending hour of the timetable (integer, 0–23).

## Development
Spin up WordPress with the plugin mounted:

`
docker-compose up
# or
make dev
`

Then open http://localhost:8080.

## Release
Create a distributable ZIP:

`
make zip
`

## License
AGPL-3.0-only. See the [LICENSE](https://www.gnu.org/licenses/agpl-3.0) for details.
