<?php
/**
 * Settings View
 *
 * @package LATW_AI_Translator_for_WPML
 */

if (!defined('ABSPATH')) {
    exit;
}

// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Tab parameter is only used for display
$latwaitr_current_tab = isset($_GET['tab']) ? sanitize_text_field(wp_unslash($_GET['tab'])) : 'general';
?>

<div class="wrap">
    <h1><?php esc_html_e('LATW AI Translator Settings', 'latw-ai-translator-for-wpml'); ?></h1>

    <?php
    // phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Display parameter only
    if (isset($_GET['updated'])):
    ?>
        <div class="notice notice-success is-dismissible">
            <p><?php esc_html_e('Settings saved successfully.', 'latw-ai-translator-for-wpml'); ?></p>
        </div>
    <?php endif; ?>

    <h2 class="nav-tab-wrapper">
        <a href="?page=latwaitr-settings&tab=general" class="nav-tab <?php echo $latwaitr_current_tab === 'general' ? 'nav-tab-active' : ''; ?>">
            <?php esc_html_e('General', 'latw-ai-translator-for-wpml'); ?>
        </a>
        <a href="?page=latwaitr-settings&tab=translation" class="nav-tab <?php echo $latwaitr_current_tab === 'translation' ? 'nav-tab-active' : ''; ?>">
            <?php esc_html_e('Translation', 'latw-ai-translator-for-wpml'); ?>
        </a>
        <a href="?page=latwaitr-settings&tab=advanced" class="nav-tab <?php echo $latwaitr_current_tab === 'advanced' ? 'nav-tab-active' : ''; ?>">
            <?php esc_html_e('Advanced', 'latw-ai-translator-for-wpml'); ?>
        </a>
    </h2>

        <?php if ($latwaitr_current_tab === 'general'): ?>
    <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>">
        <input type="hidden" name="action" value="latwaitr_save_settings">
        <input type="hidden" name="current_tab" value="general">
        <?php wp_nonce_field('latwaitr_settings'); ?>
            <table class="form-table">
                <tr>
                    <th scope="row">
                        <label for="latwaitr_openai_api_key"><?php esc_html_e('OpenAI API Key', 'latw-ai-translator-for-wpml'); ?></label>
                    </th>
                    <td>
                        <input type="password" name="latwaitr_openai_api_key" id="latwaitr_openai_api_key" class="regular-text"
                               value="<?php echo esc_attr(get_option('latwaitr_openai_api_key')); ?>">
                        <p class="description"><?php echo wp_kses(__('Enter your OpenAI API key (starts with sk-). <a href="https://help.openai.com/en/articles/4936850-where-do-i-find-my-openai-api-key" target="_blank">Where do I find my OpenAI API Key?</a>', 'latw-ai-translator-for-wpml'), array('a' => array('href' => array(), 'target' => array()))); ?></p>
                    </td>
                </tr>
                <tr>
                    <th scope="row">
                        <label for="latwaitr_openai_model"><?php esc_html_e('Model', 'latw-ai-translator-for-wpml'); ?></label>
                    </th>
                    <td>
                        <?php $latwaitr_current_model = get_option('latwaitr_openai_model', 'gpt-5-nano'); ?>
                        <select name="latwaitr_openai_model" id="latwaitr_openai_model">
                            <option value="gpt-5-nano" <?php selected($latwaitr_current_model, 'gpt-5-nano'); ?>>GPT-5 Nano (Fastest, Cheapest)</option>
                            <option value="gpt-5-mini" <?php selected($latwaitr_current_model, 'gpt-5-mini'); ?>>GPT-5 Mini (Balanced)</option>
                            <option value="gpt-5" <?php selected($latwaitr_current_model, 'gpt-5'); ?>>GPT-5 (Best Quality)</option>
                        </select>
                        <p class="description"><?php esc_html_e('Select the OpenAI model to use for translations', 'latw-ai-translator-for-wpml'); ?></p>
                    </td>
                </tr>
                <tr>
                    <th scope="row">
                        <label for="latwaitr_website_description"><?php esc_html_e('Website Description', 'latw-ai-translator-for-wpml'); ?></label>
                    </th>
                    <td>
                        <textarea name="latwaitr_website_description" id="latwaitr_website_description" rows="5" class="large-text"><?php echo esc_textarea(get_option('latwaitr_website_description', '')); ?></textarea>
                        <p class="description"><?php esc_html_e('Describe what your website is about. This helps improve translation quality and context.', 'latw-ai-translator-for-wpml'); ?></p>
                    </td>
                </tr>
            </table>

            <?php submit_button(); ?>
    </form>

        <?php elseif ($latwaitr_current_tab === 'translation'): ?>
    <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>">
        <input type="hidden" name="action" value="latwaitr_save_settings">
        <input type="hidden" name="current_tab" value="translation">
        <?php wp_nonce_field('latwaitr_settings'); ?>
            <table class="form-table">
                <tr>
                    <th scope="row">
                        <label><?php esc_html_e('Target Languages', 'latw-ai-translator-for-wpml'); ?></label>
                    </th>
                    <td>
                        <?php
                        $latwaitr_selected_languages = get_option('latwaitr_target_languages', array());
                        foreach ($latwaitr_languages as $latwaitr_lang_code => $latwaitr_lang_data):
                            $latwaitr_is_en = substr($latwaitr_lang_code, 0, 2) === 'en';
                        ?>
                            <label style="display: block; margin-bottom: 5px;<?php echo $latwaitr_is_en ? '' : ' opacity: 0.6;'; ?>" <?php echo $latwaitr_is_en ? '' : 'class="latwaitr-language-locked"'; ?>>
                                <input type="checkbox" name="latwaitr_target_languages[]" value="<?php echo esc_attr($latwaitr_lang_code); ?>"
                                       <?php checked(in_array($latwaitr_lang_code, $latwaitr_selected_languages)); ?>
                                       <?php echo $latwaitr_is_en ? '' : 'disabled'; ?>>
                                <?php echo esc_html($latwaitr_lang_data['display_name'] ?? $latwaitr_lang_code); ?>
                            </label>
                        <?php endforeach; ?>
                        <p class="description"><?php esc_html_e('Select which languages to translate content into', 'latw-ai-translator-for-wpml'); ?></p>
                        <p class="description"><a href="https://llm-automatic-translation.top/" target="_blank"><?php esc_html_e('Upgrade to Pro to translate to other languages', 'latw-ai-translator-for-wpml'); ?></a></p>
                    </td>
                </tr>
                <tr>
                    <th scope="row">
                        <label><?php esc_html_e('Fields to Translate', 'latw-ai-translator-for-wpml'); ?></label>
                    </th>
                    <td>
                        <label><input type="checkbox" name="latwaitr_translate_title" value="yes" <?php checked(get_option('latwaitr_translate_title'), 'yes'); ?>> <?php esc_html_e('Title', 'latw-ai-translator-for-wpml'); ?></label><br>
                        <label><input type="checkbox" name="latwaitr_translate_content" value="yes" <?php checked(get_option('latwaitr_translate_content'), 'yes'); ?>> <?php esc_html_e('Content', 'latw-ai-translator-for-wpml'); ?></label><br>
                        <label><input type="checkbox" name="latwaitr_translate_excerpt" value="yes" <?php checked(get_option('latwaitr_translate_excerpt'), 'yes'); ?>> <?php esc_html_e('Excerpt', 'latw-ai-translator-for-wpml'); ?></label><br>
                        <label><input type="checkbox" name="latwaitr_translate_custom_fields" value="yes" <?php checked(get_option('latwaitr_translate_custom_fields'), 'yes'); ?>> <?php esc_html_e('Custom Fields', 'latw-ai-translator-for-wpml'); ?></label><br>
                        <label><input type="checkbox" name="latwaitr_translate_seo" value="yes" <?php checked(get_option('latwaitr_translate_seo'), 'yes'); ?>> <?php esc_html_e('SEO Fields', 'latw-ai-translator-for-wpml'); ?></label>
                    </td>
                </tr>
                <tr>
                    <th scope="row">
                        <label for="latwaitr_translation_prompt"><?php esc_html_e('Translation Prompt', 'latw-ai-translator-for-wpml'); ?></label>
                    </th>
                    <td>
                        <?php
                        $latwaitr_current_prompt = get_option('latwaitr_translation_prompt', '');
                        $latwaitr_default_prompt = LATWAITR_LLM_API::get_default_prompt();
                        $latwaitr_display_prompt = !empty($latwaitr_current_prompt) ? $latwaitr_current_prompt : $latwaitr_default_prompt;
                        ?>
                        <textarea name="latwaitr_translation_prompt" id="latwaitr_translation_prompt" rows="15" class="large-text code"><?php echo esc_textarea($latwaitr_display_prompt); ?></textarea>
                        <p class="description">
                            <?php esc_html_e('Customize the prompt sent to the AI model. Available variables:', 'latw-ai-translator-for-wpml'); ?><br>
                            <code>{{source_language}}</code> - <?php esc_html_e('Source language name (e.g., "English")', 'latw-ai-translator-for-wpml'); ?><br>
                            <code>{{destination_language}}</code> - <?php esc_html_e('Target language name (e.g., "German")', 'latw-ai-translator-for-wpml'); ?><br>
                            <code>{{website_context}}</code> - <?php esc_html_e('Website description from General settings (if set)', 'latw-ai-translator-for-wpml'); ?>
                        </p>
                        <p style="margin-top: 10px;">
                            <button type="button" class="button" id="latwaitr_reset_prompt"><?php esc_html_e('Reset to Default', 'latw-ai-translator-for-wpml'); ?></button>
                        </p>
                    </td>
                </tr>
            </table>
            <?php submit_button(); ?>
    </form>

        <?php elseif ($latwaitr_current_tab === 'advanced'): ?>
    <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>">
        <input type="hidden" name="action" value="latwaitr_save_settings">
        <input type="hidden" name="current_tab" value="advanced">
        <?php wp_nonce_field('latwaitr_settings'); ?>
            <table class="form-table">
                <tr>
                    <th scope="row">
                        <label for="latwaitr_debug_mode"><?php esc_html_e('Debug Mode', 'latw-ai-translator-for-wpml'); ?></label>
                    </th>
                    <td>
                        <label>
                            <input type="checkbox" name="latwaitr_debug_mode" id="latwaitr_debug_mode" value="yes" <?php checked(get_option('latwaitr_debug_mode'), 'yes'); ?>>
                            <?php esc_html_e('Enable debug logging', 'latw-ai-translator-for-wpml'); ?>
                        </label>
                        <p class="description"><?php esc_html_e('When enabled, detailed debug logs will be written to help diagnose translation issues. Disable in production for better performance.', 'latw-ai-translator-for-wpml'); ?></p>
                    </td>
                </tr>
                <tr>
                    <th scope="row">
                        <label for="latwaitr_manual_check_responses"><?php esc_html_e('Manual Check Responses', 'latw-ai-translator-for-wpml'); ?></label>
                    </th>
                    <td>
                        <label>
                            <input type="checkbox" name="latwaitr_manual_check_responses" id="latwaitr_manual_check_responses" value="yes" <?php checked(get_option('latwaitr_manual_check_responses'), 'yes'); ?>>
                            <?php esc_html_e('Enable manual check responses button', 'latw-ai-translator-for-wpml'); ?>
                        </label>
                        <p class="description"><?php esc_html_e('If WP-Cron is not working on your server, enable this option to show a "Check Responses" button on the Translations page (next to "Translate Again"). This button allows you to manually check the status of pending translations in OpenAI.', 'latw-ai-translator-for-wpml'); ?></p>
                    </td>
                </tr>
            </table>
            <?php submit_button(); ?>
    </form>
        <?php endif; ?>
</div>
