<?php
/**
 * Dashboard View
 *
 * @package LATW_AI_Translator_for_WPML
 */

if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="wrap">
    <h1><?php esc_html_e('LATW AI Translator Dashboard', 'latw-ai-translator-for-wpml'); ?></h1>

    <div class="latwaitr-dashboard">
        <div class="latwaitr-dashboard-grid">
            <!-- Translation Stats -->
            <div class="latwaitr-card">
                <h2><?php esc_html_e('Translation Statistics (Last 30 Days)', 'latw-ai-translator-for-wpml'); ?></h2>
                <table class="widefat">
                    <tr>
                        <td><?php esc_html_e('Total Translations:', 'latw-ai-translator-for-wpml'); ?></td>
                        <td><strong><?php echo number_format($latwaitr_stats['total']); ?></strong></td>
                    </tr>
                    <tr>
                        <td><?php esc_html_e('Completed:', 'latw-ai-translator-for-wpml'); ?></td>
                        <td><strong><?php echo number_format($latwaitr_stats['completed']); ?></strong></td>
                    </tr>
                    <tr>
                        <td><?php esc_html_e('Failed:', 'latw-ai-translator-for-wpml'); ?></td>
                        <td><strong><?php echo number_format($latwaitr_stats['failed']); ?></strong></td>
                    </tr>
                    <tr>
                        <td><?php esc_html_e('Pending:', 'latw-ai-translator-for-wpml'); ?></td>
                        <td><strong><?php echo number_format($latwaitr_stats['queued']); ?></strong></td>
                    </tr>
                    <tr>
                        <td><?php esc_html_e('In progress:', 'latw-ai-translator-for-wpml'); ?></td>
                        <td><strong><?php echo number_format($latwaitr_stats['in-progress']); ?></strong></td>
                    </tr>
                </table>
            </div>

            <!-- Cost Stats -->
            <div class="latwaitr-card">
                <h2><?php esc_html_e('Cost Statistics', 'latw-ai-translator-for-wpml'); ?></h2>
                <table class="widefat">
                    <tr>
                        <td><?php esc_html_e('This Month:', 'latw-ai-translator-for-wpml'); ?></td>
                        <td><strong>$<?php echo number_format($latwaitr_monthly_cost, 2); ?></strong></td>
                    </tr>
                    <tr>
                        <td><?php esc_html_e('Last 30 Days:', 'latw-ai-translator-for-wpml'); ?></td>
                        <td><strong>$<?php echo number_format($latwaitr_stats['total_cost'], 2); ?></strong></td>
                    </tr>
                    <tr>
                        <td><?php esc_html_e('Total Tokens Used:', 'latw-ai-translator-for-wpml'); ?></td>
                        <td><strong><?php echo number_format($latwaitr_stats['total_tokens']); ?></strong></td>
                    </tr>
                </table>
            </div>

            <!-- Queue Status -->
            <div class="latwaitr-card">
                <h2><?php esc_html_e('Queue Status', 'latw-ai-translator-for-wpml'); ?></h2>
                <table class="widefat">
                    <tr>
                        <td><?php esc_html_e('Pending:', 'latw-ai-translator-for-wpml'); ?></td>
                        <td><strong><?php echo number_format($latwaitr_queue_status['pending']); ?></strong></td>
                    </tr>
                    <tr>
                        <td><?php esc_html_e('In Progress:', 'latw-ai-translator-for-wpml'); ?></td>
                        <td><strong><?php echo number_format($latwaitr_queue_status['in_progress']); ?></strong></td>
                    </tr>
                </table>
            </div>
        </div>

        <!-- Quick Actions -->
        <div class="latwaitr-card latwaitr-quick-actions">
            <h2><?php esc_html_e('Quick Actions', 'latw-ai-translator-for-wpml'); ?></h2>
            <p>
                <a href="<?php echo esc_url(admin_url('admin.php?page=latwaitr-translations')); ?>" class="button button-primary">
                    <span class="dashicons dashicons-translation"></span>
                    <?php esc_html_e('Translations', 'latw-ai-translator-for-wpml'); ?>
                </a>
                <a href="<?php echo esc_url(admin_url('admin.php?page=latwaitr-settings')); ?>" class="button">
                    <span class="dashicons dashicons-admin-settings"></span>
                    <?php esc_html_e('Settings', 'latw-ai-translator-for-wpml'); ?>
                </a>
                <a href="<?php echo esc_url(admin_url('admin.php?page=latwaitr-logs')); ?>" class="button">
                    <span class="dashicons dashicons-media-text"></span>
                    <?php esc_html_e('View Logs', 'latw-ai-translator-for-wpml'); ?>
                </a>
            </p>
        </div>
    </div>
</div>
