<?php
/**
 * Elementor Testimonial Carousel widget integration
 *
 * @package LATW_AI_Translator_for_WPML
 */

if (!defined('ABSPATH')) {
    exit;
}

class LATWAITR_Elementor_Testimonial_Carousel extends LATWAITR_Elementor_Module_With_Items {

    /**
     * @return string
     */
    public function get_items_field() {
        return 'slides';
    }

    /**
     * @return array
     */
    protected function get_fields() {
        return array(
            'testimonial_content',
            'testimonial_name',
            'testimonial_job',
            'link' => array('url')
        );
    }

    /**
     * @param string $field
     * @return string
     */
    protected function get_title($field) {
        switch ($field) {
            case 'testimonial_content':
                return 'Testimonial Carousel: Content';
            case 'testimonial_name':
                return 'Testimonial Carousel: Name';
            case 'testimonial_job':
                return 'Testimonial Carousel: Job';
            case 'url':
                return 'Testimonial Carousel: Link URL';
            default:
                return '';
        }
    }

    /**
     * @param string $field
     * @return string
     */
    protected function get_editor_type($field) {
        switch ($field) {
            case 'testimonial_content':
                return 'VISUAL';
            case 'testimonial_name':
                return 'LINE';
            case 'testimonial_job':
                return 'LINE';
            case 'url':
                return 'LINK';
            default:
                return '';
        }
    }
}
