<?php
/**
 * Elementor Tabs widget integration
 *
 * @package LATW_AI_Translator_for_WPML
 */

if (!defined('ABSPATH')) {
    exit;
}

class LATWAITR_Elementor_Tabs extends LATWAITR_Elementor_Module_With_Items {

    /**
     * @return string
     */
    public function get_items_field() {
        return 'tabs';
    }

    /**
     * @return array
     */
    protected function get_fields() {
        return array('tab_title', 'tab_content');
    }

    /**
     * @param string $field
     * @return string
     */
    protected function get_title($field) {
        switch ($field) {
            case 'tab_title':
                return 'Tabs: Title';
            case 'tab_content':
                return 'Tabs: Content';
            default:
                return '';
        }
    }

    /**
     * @param string $field
     * @return string
     */
    protected function get_editor_type($field) {
        switch ($field) {
            case 'tab_title':
                return 'LINE';
            case 'tab_content':
                return 'VISUAL';
            default:
                return '';
        }
    }
}
