<?php
/**
 * Elementor Slides widget integration
 *
 * @package LATW_AI_Translator_for_WPML
 */

if (!defined('ABSPATH')) {
    exit;
}

class LATWAITR_Elementor_Slides extends LATWAITR_Elementor_Module_With_Items {

    /**
     * @return string
     */
    public function get_items_field() {
        return 'slides';
    }

    /**
     * @return array
     */
    protected function get_fields() {
        return array(
            'heading',
            'description',
            'button_text',
            'link' => array('url')
        );
    }

    /**
     * @param string $field
     * @return string
     */
    protected function get_title($field) {
        switch ($field) {
            case 'heading':
                return 'Slides: Heading';
            case 'description':
                return 'Slides: Description';
            case 'button_text':
                return 'Slides: Button text';
            case 'url':
                return 'Slides: Link URL';
            default:
                return '';
        }
    }

    /**
     * @param string $field
     * @return string
     */
    protected function get_editor_type($field) {
        switch ($field) {
            case 'heading':
                return 'LINE';
            case 'description':
                return 'AREA';
            case 'button_text':
                return 'LINE';
            case 'url':
                return 'LINK';
            default:
                return '';
        }
    }
}
