<?php
/**
 * Elementor Sitemap Widget Integration
 *
 * @package LATW_AI_Translator_for_WPML
 */

if (!defined('ABSPATH')) {
    exit;
}

class LATWAITR_Elementor_Sitemap extends LATWAITR_Elementor_Module_With_Items {

    /**
     * Get the field holding items
     */
    public function get_items_field() {
        return 'sitemap_items';
    }

    /**
     * Get fields to translate
     */
    protected function get_fields() {
        return array(
            'sitemap_title',
            'sitemap_password_protected_message'
        );
    }

    /**
     * Get field title
     */
    protected function get_title($field) {
        switch ($field) {
            case 'sitemap_title':
                return 'Sitemap: Item Title';
            case 'sitemap_password_protected_message':
                return 'Sitemap: Password Protected Message';
            default:
                return '';
        }
    }

    /**
     * Get editor type for field
     */
    protected function get_editor_type($field) {
        switch ($field) {
            case 'sitemap_title':
                return 'LINE';
            case 'sitemap_password_protected_message':
                return 'LINE';
            default:
                return 'LINE';
        }
    }
}
