<?php
/**
 * Elementor Reviews Widget Integration
 *
 * @package LATW_AI_Translator_for_WPML
 */

if (!defined('ABSPATH')) {
    exit;
}

class LATWAITR_Elementor_Reviews extends LATWAITR_Elementor_Module_With_Items {

    /**
     * Get the field holding items
     */
    public function get_items_field() {
        return 'slides';
    }

    /**
     * Get fields to translate
     */
    protected function get_fields() {
        return array(
            'content',
            'name',
            'title',
            'link' => array('field' => 'url')
        );
    }

    /**
     * Get field title
     */
    protected function get_title($field) {
        switch ($field) {
            case 'content':
                return 'Reviews: Comment Contents';
            case 'name':
                return 'Reviews: Commenter Name';
            case 'title':
                return 'Reviews: Comment Title';
            case 'url':
                return 'Reviews: Comment Link';
            default:
                return '';
        }
    }

    /**
     * Get editor type for field
     */
    protected function get_editor_type($field) {
        switch ($field) {
            case 'content':
            case 'name':
            case 'title':
                return 'LINE';
            case 'url':
                return 'LINK';
            default:
                return 'LINE';
        }
    }
}
