<?php
/**
 * Elementor Price Table widget integration
 *
 * @package LATW_AI_Translator_for_WPML
 */

if (!defined('ABSPATH')) {
    exit;
}

class LATWAITR_Elementor_Price_Table extends LATWAITR_Elementor_Module_With_Items {

    /**
     * @return string
     */
    public function get_items_field() {
        return 'features_list';
    }

    /**
     * @return array
     */
    protected function get_fields() {
        return array('item_text', 'link' => array('url'));
    }

    /**
     * @param string $field
     * @return string
     */
    protected function get_title($field) {
        switch ($field) {
            case 'item_text':
                return 'Price Table: Feature text';
            case 'url':
                return 'Price Table: Feature link';
            default:
                return '';
        }
    }

    /**
     * @param string $field
     * @return string
     */
    protected function get_editor_type($field) {
        switch ($field) {
            case 'item_text':
                return 'LINE';
            case 'url':
                return 'LINK';
            default:
                return '';
        }
    }
}
