<?php
/**
 * Elementor Price List Widget Integration
 *
 * @package LATW_AI_Translator_for_WPML
 */

if (!defined('ABSPATH')) {
    exit;
}

class LATWAITR_Elementor_Price_List extends LATWAITR_Elementor_Module_With_Items {

    /**
     * Get the field holding items
     */
    public function get_items_field() {
        return 'price_list';
    }

    /**
     * Get fields to translate
     */
    protected function get_fields() {
        return array(
            'title',
            'item_description',
            'price'
        );
    }

    /**
     * Get field title
     */
    protected function get_title($field) {
        switch ($field) {
            case 'title':
                return 'Price List: Item Title';
            case 'item_description':
                return 'Price List: Item Description';
            case 'price':
                return 'Price List: Price';
            default:
                return '';
        }
    }

    /**
     * Get editor type for field
     */
    protected function get_editor_type($field) {
        switch ($field) {
            case 'title':
            case 'price':
                return 'LINE';
            case 'item_description':
                return 'AREA';
            default:
                return 'LINE';
        }
    }
}
