<?php
/**
 * Elementor Multiple Gallery Widget Integration
 *
 * @package LATW_AI_Translator_for_WPML
 */

if (!defined('ABSPATH')) {
    exit;
}

class LATWAITR_Elementor_Multiple_Gallery extends LATWAITR_Elementor_Module_With_Items {

    /**
     * Get the field holding items
     */
    public function get_items_field() {
        return 'galleries';
    }

    /**
     * Get fields to translate
     */
    protected function get_fields() {
        return array('gallery_title');
    }

    /**
     * Get field title
     */
    protected function get_title($field) {
        switch ($field) {
            case 'gallery_title':
                return 'Galleries: Gallery Title';
            default:
                return '';
        }
    }

    /**
     * Get editor type for field
     */
    protected function get_editor_type($field) {
        switch ($field) {
            case 'gallery_title':
                return 'LINE';
            default:
                return 'LINE';
        }
    }
}
