<?php
/**
 * Elementor Mega Menu Widget Integration
 *
 * @package LATW_AI_Translator_for_WPML
 */

if (!defined('ABSPATH')) {
    exit;
}

class LATWAITR_Elementor_Mega_Menu extends LATWAITR_Elementor_Module_With_Items {

    /**
     * Get the field holding items
     */
    public function get_items_field() {
        return 'menu_items';
    }

    /**
     * Get fields to translate
     */
    protected function get_fields() {
        return array(
            'item_title',
            'item_subtitle'
        );
    }

    /**
     * Get field title
     */
    protected function get_title($field) {
        switch ($field) {
            case 'item_title':
                return 'Mega Menu: Item Title';
            case 'item_subtitle':
                return 'Mega Menu: Item Subtitle';
            default:
                return '';
        }
    }

    /**
     * Get editor type for field
     */
    protected function get_editor_type($field) {
        switch ($field) {
            case 'item_title':
            case 'item_subtitle':
                return 'LINE';
            default:
                return 'LINE';
        }
    }
}
