<?php
/**
 * Elementor Icon List widget integration
 *
 * @package LATW_AI_Translator_for_WPML
 */

if (!defined('ABSPATH')) {
    exit;
}

class LATWAITR_Elementor_Icon_List extends LATWAITR_Elementor_Module_With_Items {

    /**
     * @return string
     */
    public function get_items_field() {
        return 'icon_list';
    }

    /**
     * @return array
     */
    protected function get_fields() {
        return array('text', 'link' => array('url'));
    }

    /**
     * @param string $field
     * @return string
     */
    protected function get_title($field) {
        switch ($field) {
            case 'text':
                return 'Icon List: Text';
            case 'url':
                return 'Icon List: Link URL';
            default:
                return '';
        }
    }

    /**
     * @param string $field
     * @return string
     */
    protected function get_editor_type($field) {
        switch ($field) {
            case 'text':
                return 'LINE';
            case 'url':
                return 'LINK';
            default:
                return '';
        }
    }
}
