<?php
/**
 * Elementor Form Widget Integration
 *
 * @package LATW_AI_Translator_for_WPML
 */

if (!defined('ABSPATH')) {
    exit;
}

class LATWAITR_Elementor_Form extends LATWAITR_Elementor_Module_With_Items {

    /**
     * Get the field holding items
     */
    public function get_items_field() {
        return 'form_fields';
    }

    /**
     * Get fields to translate
     */
    protected function get_fields() {
        return array(
            'field_label',
            'placeholder',
            'field_options'
        );
    }

    /**
     * Get field title
     */
    protected function get_title($field) {
        switch ($field) {
            case 'field_label':
                return 'Form: Field Label';
            case 'placeholder':
                return 'Form: Field Placeholder';
            case 'field_options':
                return 'Form: Field Options';
            default:
                return '';
        }
    }

    /**
     * Get editor type for field
     */
    protected function get_editor_type($field) {
        switch ($field) {
            case 'field_label':
            case 'placeholder':
                return 'LINE';
            case 'field_options':
                return 'AREA';
            default:
                return 'LINE';
        }
    }
}
