<?php
/**
 * Elementor Contact Widget Integration
 *
 * @package LATW_AI_Translator_for_WPML
 */

if (!defined('ABSPATH')) {
    exit;
}

class LATWAITR_Elementor_Contact extends LATWAITR_Elementor_Module_With_Items {

    /**
     * Override get() to handle multiple repeater fields
     */
    public function get($node_id, $element, $strings) {
        if (!isset($element['settings'])) {
            return $strings;
        }

        $settings = $element['settings'];

        // Handle all group repeaters (group_1_repeater, group_2_repeater, etc.)
        for ($i = 1; $i <= 4; $i++) {
            $repeater_key = "group_{$i}_repeater";
            if (isset($settings[$repeater_key]) && is_array($settings[$repeater_key])) {
                foreach ($settings[$repeater_key] as $item_index => $item) {
                    $label_key = "group_{$i}_label";
                    if (isset($item[$label_key])) {
                        $strings[] = new LATWAITR_PB_String(
                            $item[$label_key],
                            $node_id . '-' . $repeater_key . '-' . $item_index . '-' . $label_key,
                            "Contact: Group {$i} Label",
                            'LINE'
                        );
                    }
                }
            }

            // Handle social repeaters (group_X_social_repeater)
            $social_repeater_key = "group_{$i}_social_repeater";
            if (isset($settings[$social_repeater_key]) && is_array($settings[$social_repeater_key])) {
                foreach ($settings[$social_repeater_key] as $item_index => $item) {
                    $label_key = "group_{$i}_social_label";
                    if (isset($item[$label_key])) {
                        $strings[] = new LATWAITR_PB_String(
                            $item[$label_key],
                            $node_id . '-' . $social_repeater_key . '-' . $item_index . '-' . $label_key,
                            "Contact: Group {$i} Social Label",
                            'LINE'
                        );
                    }
                }
            }
        }

        return $strings;
    }

    /**
     * Override update() to handle multiple repeater fields
     */
    public function update($node_id, $element, $pb_string) {
        if (!isset($element['settings'])) {
            return array(null, null);
        }

        $settings = $element['settings'];
        $string_name = $pb_string->get_name();

        // Handle all group repeaters
        for ($i = 1; $i <= 4; $i++) {
            $repeater_key = "group_{$i}_repeater";
            if (isset($settings[$repeater_key]) && is_array($settings[$repeater_key])) {
                foreach ($settings[$repeater_key] as $item_index => $item) {
                    $label_key = "group_{$i}_label";
                    $expected_name = $node_id . '-' . $repeater_key . '-' . $item_index . '-' . $label_key;
                    if ($string_name === $expected_name) {
                        $item[$label_key] = $pb_string->get_value();
                        // Return path using separator and updated item
                        return array($repeater_key . '>' . $item_index, $item);
                    }
                }
            }

            // Handle social repeaters
            $social_repeater_key = "group_{$i}_social_repeater";
            if (isset($settings[$social_repeater_key]) && is_array($settings[$social_repeater_key])) {
                foreach ($settings[$social_repeater_key] as $item_index => $item) {
                    $label_key = "group_{$i}_social_label";
                    $expected_name = $node_id . '-' . $social_repeater_key . '-' . $item_index . '-' . $label_key;
                    if ($string_name === $expected_name) {
                        $item[$label_key] = $pb_string->get_value();
                        // Return path using separator and updated item
                        return array($social_repeater_key . '>' . $item_index, $item);
                    }
                }
            }
        }

        return array(null, null);
    }

    /**
     * Get the field holding items (not used, we override get/update)
     */
    public function get_items_field() {
        return '';
    }

    /**
     * Get fields to translate (not used, we override get/update)
     */
    protected function get_fields() {
        return array();
    }

    /**
     * Get field title (not used, we override get/update)
     */
    protected function get_title($field) {
        return '';
    }

    /**
     * Get editor type for field (not used, we override get/update)
     */
    protected function get_editor_type($field) {
        return 'LINE';
    }
}
