<?php
/**
 * Page Builder String representation
 *
 * Represents a translatable string from a page builder with metadata
 *
 * @package LATW_AI_Translator_for_WPML
 */

if (!defined('ABSPATH')) {
    exit;
}

class LATWAITR_PB_String {

    /**
     * @var string String value to translate
     */
    private $value;

    /**
     * @var string Unique identifier for this string
     */
    private $name;

    /**
     * @var string Human-readable title/description
     */
    private $title;

    /**
     * @var string Editor type (LINE, VISUAL, AREA, LINK)
     */
    private $editor_type;

    /**
     * @var string Optional HTML wrap tag for SEO (h1-h6, etc.)
     */
    private $wrap_tag;

    /**
     * Constructor
     *
     * @param string $value       String value
     * @param string $name        String name/identifier
     * @param string $title       String title/description
     * @param string $editor_type Editor type (LINE, VISUAL, AREA, LINK)
     * @param string $wrap_tag    Optional wrap tag
     */
    public function __construct($value, $name, $title, $editor_type, $wrap_tag = '') {
        $this->value = $value;
        $this->name = $name;
        $this->title = $title;
        $this->editor_type = $editor_type;
        $this->wrap_tag = $wrap_tag;
    }

    /**
     * Get string value
     *
     * @return string
     */
    public function get_value() {
        return $this->value;
    }

    /**
     * Set string value
     *
     * @param string $value
     */
    public function set_value($value) {
        $this->value = $value;
    }

    /**
     * Get string name/identifier
     *
     * @return string
     */
    public function get_name() {
        return $this->name;
    }

    /**
     * Get string title/description
     *
     * @return string
     */
    public function get_title() {
        return $this->title;
    }

    /**
     * Set string title
     *
     * @param string $title
     */
    public function set_title($title) {
        $this->title = $title;
    }

    /**
     * Get editor type
     *
     * @return string
     */
    public function get_editor_type() {
        return $this->editor_type;
    }

    /**
     * Get wrap tag
     *
     * @return string
     */
    public function get_wrap_tag() {
        return $this->wrap_tag;
    }
}
