<?php
/**
 * Cost Estimator for LATW
 *
 * @package LATW_AI_Translator_for_WPML
 */

if (!defined('ABSPATH')) {
    exit;
}

class LATWAITR_Cost_Estimator {

    /**
     * Prices per 1K tokens
     */
    const PRICING = array(
        'gpt-5-nano' => array(
            'input' => 0.00005,
            'output' => 0.0004,
        ),
        'gpt-5-mini' => array(
            'input' => 0.00025,
            'output' => 0.002,
        ),
        'gpt-5' => array(
            'input' => 0.00175,
            'output' => 0.014,
        )
    );

    /**
     * Default model
     */
    const DEFAULT_MODEL = 'gpt-5-nano';

    /**
     * Cost for translation
     */
    public static function calculate_translation_cost($input_tokens, $output_tokens, $model = null) {
        if ($model === null) {
            $model = self::DEFAULT_MODEL;
        }

        if (!isset(self::PRICING[$model])) {
            $model = self::DEFAULT_MODEL;
        }

        $input_cost = ($input_tokens / 1000) * self::PRICING[$model]['input'];
        $output_cost = ($output_tokens / 1000) * self::PRICING[$model]['output'];

        $total_cost = $input_cost + $output_cost;

        return array(
            'input_cost' => $input_cost,
            'output_cost' => $output_cost,
            'total_cost' => $total_cost,
        );
    }

    /**
     * Format cost for display
     */
    public static function format_cost($cost) {
        return '$' . number_format($cost, 4);
    }

    /**
     * Format tokens for display
     */
    public static function format_tokens($tokens) {
        return number_format($tokens) . ' tokens';
    }
}
