<?php
if (!defined('ABSPATH')) exit;

// Ensure latwaitr_queued_languages is defined (passed from controller)
if (!isset($latwaitr_queued_languages)) {
    $latwaitr_queued_languages = array();
}

$latwaitr_active_languages = LATWAITR()->wpml->get_active_languages();

?>
<div class="wrap">
    <h1 class="wp-heading-inline"><?php esc_html_e('Translations', 'latw-ai-translator-for-wpml'); ?></h1>

    <button type="button" class="page-title-action" id="latwaitr-translate-again-btn">
        <span class="dashicons dashicons-update" style="vertical-align: middle; margin-top: -2px;"></span>
        <?php esc_html_e('Translate Again', 'latw-ai-translator-for-wpml'); ?>
    </button>

    <?php if (get_option('latwaitr_manual_check_responses') === 'yes'): ?>
    <button type="button" class="page-title-action" id="latwaitr-check-responses-btn">
        <span class="dashicons dashicons-search" style="vertical-align: middle; margin-top: -2px;"></span>
        <?php esc_html_e('Check Responses', 'latw-ai-translator-for-wpml'); ?>
    </button>
    <?php endif; ?>

    <hr class="wp-header-end">

    <?php if (empty($latwaitr_target_languages)): ?>
        <div class="notice notice-warning">
            <p>
                <?php esc_html_e('No target languages configured. Please configure target languages in', 'latw-ai-translator-for-wpml'); ?>
                <a href="<?php echo esc_url(admin_url('admin.php?page=latwaitr-settings')); ?>"><?php esc_html_e('Settings', 'latw-ai-translator-for-wpml'); ?></a>
            </p>
        </div>
    <?php else: ?>

        <!-- Active Queue -->
        <?php if (!empty($latwaitr_queue_items)): ?>
        <div class="latwaitr-queue-section" style="background: #fff; padding: 20px; border: 1px solid #ccd0d4; border-radius: 4px; margin-bottom: 20px;">
            <h2 style="margin-top: 0;">
                <?php esc_html_e('Active Translation Queue', 'latw-ai-translator-for-wpml'); ?>
            </h2>
            <table class="wp-list-table widefat fixed striped">
                <thead>
                    <tr>
                        <th><?php esc_html_e('Post Title', 'latw-ai-translator-for-wpml'); ?></th>
                        <th><?php esc_html_e('Post Type', 'latw-ai-translator-for-wpml'); ?></th>
                        <th><?php esc_html_e('Target Language', 'latw-ai-translator-for-wpml'); ?></th>
                        <th><?php esc_html_e('Status', 'latw-ai-translator-for-wpml'); ?></th>
                        <th><?php esc_html_e('Scheduled', 'latw-ai-translator-for-wpml'); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($latwaitr_queue_items as $latwaitr_item): ?>
                    <tr>
                        <td>
                            <strong><?php echo esc_html($latwaitr_item['post_title']); ?></strong>
                        </td>
                        <td><?php echo esc_html($latwaitr_item['post_type']); ?></td>
                        <td>
                            <?php
                            $latwaitr_lang_name = isset($latwaitr_active_languages[$latwaitr_item['target_lang']]) ?
                                $latwaitr_active_languages[$latwaitr_item['target_lang']]['native_name'] :
                                $latwaitr_item['target_lang'];
                            echo esc_html($latwaitr_lang_name);
                            ?>
                        </td>
                        <td>
                            <?php if ($latwaitr_item['status'] === 'queued'): ?>
                                <span style="color: #f0b849; font-weight: 600;">⏳ <?php esc_html_e('Queued', 'latw-ai-translator-for-wpml'); ?></span>
                            <?php elseif ($latwaitr_item['status'] === 'in_progress'): ?>
                                <span style="color: #00a32a; font-weight: 600;">⚙️ <?php esc_html_e('Translating...', 'latw-ai-translator-for-wpml'); ?></span>
                            <?php endif; ?>
                        </td>
                        <td><?php echo esc_html(wp_date('Y-m-d H:i:s', $latwaitr_item['scheduled'])); ?></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
        <?php endif; ?>

        <!-- Content Needing Translation -->
        <?php if (empty($latwaitr_post_types) && empty($latwaitr_categories_tab)): ?>
        <div class="notice notice-success">
            <p><?php esc_html_e('All content is translated! No posts require translation.', 'latw-ai-translator-for-wpml'); ?></p>
        </div>
        <?php else: ?>

        <!-- Tabs Navigation -->
        <nav class="nav-tab-wrapper wp-clearfix">
            <?php foreach ($latwaitr_post_types as $latwaitr_pt): ?>
                <?php
                $latwaitr_tab_url = add_query_arg(array(
                    'page' => 'latwaitr-translations',
                    'tab' => $latwaitr_pt['name'],
                ), admin_url('admin.php'));
                $latwaitr_is_active = ($latwaitr_current_tab === $latwaitr_pt['name']);
                ?>
                <a href="<?php echo esc_url($latwaitr_tab_url); ?>" class="nav-tab <?php echo $latwaitr_is_active ? 'nav-tab-active' : ''; ?>">
                    <?php echo esc_html($latwaitr_pt['label']); ?>
                    <span class="count">(<?php echo esc_html($latwaitr_pt['count']); ?>)</span>
                </a>
            <?php endforeach; ?>
            <?php if ($latwaitr_categories_tab): ?>
                <?php
                $cat_tab_url = add_query_arg(array(
                    'page' => 'latwaitr-translations',
                    'tab' => 'categories',
                ), admin_url('admin.php'));
                $is_categories_active = ($latwaitr_current_tab === 'categories');
                ?>
                <a href="<?php echo esc_url($cat_tab_url); ?>" class="nav-tab <?php echo $is_categories_active ? 'nav-tab-active' : ''; ?>">
                    <?php esc_html_e('Categories', 'latw-ai-translator-for-wpml'); ?>
                    <span class="count">(<?php echo esc_html($latwaitr_categories_tab['count']); ?>)</span>
                </a>
            <?php endif; ?>
        </nav>

        <?php if ($latwaitr_is_categories_tab): ?>
        <div class="latwaitr-translations-panel">
            <!-- Search Box and Actions -->
            <div class="tablenav top">
                <?php if ($latwaitr_terms_data && !empty($latwaitr_terms_data['terms'])): ?>
                <div class="alignleft actions bulkactions">
                    <button type="button" class="button latwaitr-translate-selected-terms">
                        <?php esc_html_e('Translate Selected', 'latw-ai-translator-for-wpml'); ?>
                    </button>
                </div>
                <?php endif; ?>

                <!-- Search Form -->
                <form method="get" class="search-box">
                    <input type="hidden" name="page" value="latwaitr-translations">
                    <input type="hidden" name="tab" value="categories">
                    <label class="screen-reader-text" for="term-search-input"><?php esc_html_e('Search', 'latw-ai-translator-for-wpml'); ?></label>
                    <input type="search" id="term-search-input" name="s" value="<?php echo esc_attr($latwaitr_search_query); ?>" placeholder="<?php esc_attr_e('Search by name...', 'latw-ai-translator-for-wpml'); ?>">
                    <input type="submit" id="search-submit" class="button" value="<?php esc_attr_e('Search', 'latw-ai-translator-for-wpml'); ?>">
                    <?php if (!empty($latwaitr_search_query)): ?>
                        <a href="<?php echo esc_url(add_query_arg(array('page' => 'latwaitr-translations', 'tab' => 'categories'), admin_url('admin.php'))); ?>" class="button">
                            <?php esc_html_e('Clear', 'latw-ai-translator-for-wpml'); ?>
                        </a>
                    <?php endif; ?>
                </form>

                <!-- Pagination Top -->
                <?php if ($latwaitr_terms_data && $latwaitr_terms_data['total_pages'] > 1): ?>
                <div class="tablenav-pages">
                    <span class="displaying-num">
                        <?php
                        echo esc_html(
                            sprintf(
                                _n('%s item', '%s items', $latwaitr_terms_data['total_terms'], 'latw-ai-translator-for-wpml'),
                                number_format_i18n($latwaitr_terms_data['total_terms'])
                            )
                        );
                        ?>
                    </span>
                    <span class="pagination-links">
                        <?php
                        $term_pagination_args = array(
                            'page' => 'latwaitr-translations',
                            'tab' => 'categories',
                        );
                        if (!empty($latwaitr_search_query)) {
                            $term_pagination_args['s'] = $latwaitr_search_query;
                        }
                        $term_first_url = add_query_arg(array_merge($term_pagination_args, array('paged' => 1)), admin_url('admin.php'));
                        $term_prev_url = add_query_arg(array_merge($term_pagination_args, array('paged' => max(1, $latwaitr_current_page - 1))), admin_url('admin.php'));
                        $term_next_url = add_query_arg(array_merge($term_pagination_args, array('paged' => min($latwaitr_terms_data['total_pages'], $latwaitr_current_page + 1))), admin_url('admin.php'));
                        $term_last_url = add_query_arg(array_merge($term_pagination_args, array('paged' => $latwaitr_terms_data['total_pages'])), admin_url('admin.php'));
                        ?>
                        <?php if ($latwaitr_current_page > 1): ?>
                            <a class="first-page button" href="<?php echo esc_url($term_first_url); ?>"><span aria-hidden="true">«</span></a>
                            <a class="prev-page button" href="<?php echo esc_url($term_prev_url); ?>"><span aria-hidden="true">‹</span></a>
                        <?php else: ?>
                            <span class="tablenav-pages-navspan button disabled" aria-hidden="true">«</span>
                            <span class="tablenav-pages-navspan button disabled" aria-hidden="true">‹</span>
                        <?php endif; ?>
                        <span class="paging-input">
                            <span class="tablenav-paging-text">
                                <?php echo esc_html($latwaitr_current_page); ?>
                                <?php esc_html_e('of', 'latw-ai-translator-for-wpml'); ?>
                                <span class="total-pages"><?php echo esc_html($latwaitr_terms_data['total_pages']); ?></span>
                            </span>
                        </span>
                        <?php if ($latwaitr_current_page < $latwaitr_terms_data['total_pages']): ?>
                            <a class="next-page button" href="<?php echo esc_url($term_next_url); ?>"><span aria-hidden="true">›</span></a>
                            <a class="last-page button" href="<?php echo esc_url($term_last_url); ?>"><span aria-hidden="true">»</span></a>
                        <?php else: ?>
                            <span class="tablenav-pages-navspan button disabled" aria-hidden="true">›</span>
                            <span class="tablenav-pages-navspan button disabled" aria-hidden="true">»</span>
                        <?php endif; ?>
                    </span>
                </div>
                <?php endif; ?>
            </div>

            <!-- Terms Table -->
            <table class="wp-list-table widefat fixed striped posts">
                <thead>
                    <tr>
                        <td id="cb" class="manage-column column-cb check-column">
                            <input type="checkbox" class="latwaitr-select-all-terms">
                        </td>
                        <th scope="col" class="manage-column column-title column-primary"><?php esc_html_e('Name', 'latw-ai-translator-for-wpml'); ?></th>
                        <th scope="col" class="manage-column"><?php esc_html_e('Taxonomy', 'latw-ai-translator-for-wpml'); ?></th>
                        <th scope="col" class="manage-column"><?php esc_html_e('Slug', 'latw-ai-translator-for-wpml'); ?></th>
                        <th scope="col" class="manage-column"><?php esc_html_e('Posts', 'latw-ai-translator-for-wpml'); ?></th>
                        <th scope="col" class="manage-column column-source-lang"><?php esc_html_e('Source Language', 'latw-ai-translator-for-wpml'); ?></th>
                        <th scope="col" class="manage-column column-missing-langs"><?php esc_html_e('Missing Languages', 'latw-ai-translator-for-wpml'); ?></th>
                        <th scope="col" class="manage-column column-actions"><?php esc_html_e('Actions', 'latw-ai-translator-for-wpml'); ?></th>
                    </tr>
                </thead>
                <tbody id="the-list">
                    <?php if (!$latwaitr_terms_data || empty($latwaitr_terms_data['terms'])): ?>
                    <tr class="no-items">
                        <td class="colspanchange" colspan="8">
                            <?php if (!empty($latwaitr_search_query)): ?>
                                <?php esc_html_e('No terms found matching your search.', 'latw-ai-translator-for-wpml'); ?>
                            <?php else: ?>
                                <?php esc_html_e('No terms need translation.', 'latw-ai-translator-for-wpml'); ?>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php else: ?>
                    <?php foreach ($latwaitr_terms_data['terms'] as $latwaitr_term): ?>
                    <tr>
                        <th scope="row" class="check-column">
                            <input type="checkbox" class="latwaitr-select-term" value="<?php echo esc_attr($latwaitr_term['term_id']); ?>">
                        </th>
                        <td class="title column-title column-primary">
                            <strong><?php echo esc_html($latwaitr_term['name']); ?></strong>
                            <?php if (!empty($latwaitr_term['description'])): ?>
                                <div class="row-actions">
                                    <span class="description" style="color: #666; font-style: italic;"><?php echo esc_html(wp_trim_words($latwaitr_term['description'], 10)); ?></span>
                                </div>
                            <?php endif; ?>
                        </td>
                        <td><?php echo esc_html($latwaitr_term['taxonomy_label']); ?></td>
                        <td><?php echo esc_html($latwaitr_term['slug']); ?></td>
                        <td><?php echo esc_html($latwaitr_term['count']); ?></td>
                        <td class="source-lang column-source-lang">
                            <?php
                            $latwaitr_term_source_lang_name = isset($latwaitr_active_languages[$latwaitr_term['source_lang']]) ?
                                $latwaitr_active_languages[$latwaitr_term['source_lang']]['native_name'] :
                                $latwaitr_term['source_lang'];
                            echo esc_html($latwaitr_term_source_lang_name);
                            ?>
                        </td>
                        <td class="missing-langs column-missing-langs">
                            <div class="latwaitr-language-checkboxes">
                                <label class="latwaitr-lang-checkbox-label latwaitr-lang-all">
                                    <input type="checkbox" class="latwaitr-term-select-all-langs" data-term-id="<?php echo esc_attr($latwaitr_term['term_id']); ?>" checked>
                                    <strong><?php esc_html_e('All Languages', 'latw-ai-translator-for-wpml'); ?></strong>
                                </label>
                                <?php foreach ($latwaitr_term['missing_languages'] as $latwaitr_lang_code): ?>
                                    <?php
                                    $latwaitr_display_lang_name = isset($latwaitr_active_languages[$latwaitr_lang_code]) ?
                                        $latwaitr_active_languages[$latwaitr_lang_code]['display_name'] :
                                        $latwaitr_lang_code;

                                    // Check if queued
                                    $latwaitr_term_is_queued = isset($latwaitr_queued_languages[$latwaitr_term['term_id']][$latwaitr_lang_code]);
                                    $latwaitr_term_queue_status = $latwaitr_term_is_queued ? $latwaitr_queued_languages[$latwaitr_term['term_id']][$latwaitr_lang_code] : '';
                                    $latwaitr_term_is_disabled = $latwaitr_term_is_queued;
                                    ?>
                                    <label class="latwaitr-lang-checkbox-label <?php echo $latwaitr_term_is_disabled ? 'latwaitr-lang-disabled' : ''; ?>">
                                        <input type="checkbox" class="latwaitr-term-select-lang"
                                               data-term-id="<?php echo esc_attr($latwaitr_term['term_id']); ?>"
                                               data-lang-code="<?php echo esc_attr($latwaitr_lang_code); ?>"
                                               <?php echo $latwaitr_term_is_disabled ? 'disabled' : 'checked'; ?>>
                                        <?php echo esc_html($latwaitr_display_lang_name); ?>
                                        <?php if ($latwaitr_term_is_queued): ?>
                                            <?php if ($latwaitr_term_queue_status === 'queued'): ?>
                                                <span class="latwaitr-queue-indicator latwaitr-queue-queued">(⏳ <?php esc_html_e('Queued', 'latw-ai-translator-for-wpml'); ?>)</span>
                                            <?php elseif ($latwaitr_term_queue_status === 'in-progress'): ?>
                                                <span class="latwaitr-queue-indicator latwaitr-queue-progress">(⚙️ <?php esc_html_e('Translating...', 'latw-ai-translator-for-wpml'); ?>)</span>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </label>
                                <?php endforeach; ?>
                            </div>
                        </td>
                        <td class="actions column-actions">
                            <button type="button" class="button latwaitr-translate-single-term" data-term-id="<?php echo esc_attr($latwaitr_term['term_id']); ?>">
                                <span class="dashicons dashicons-translation"></span>
                                <?php esc_html_e('Translate', 'latw-ai-translator-for-wpml'); ?>
                            </button>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
                <tfoot>
                    <tr>
                        <td class="manage-column column-cb check-column">
                            <input type="checkbox" class="latwaitr-select-all-terms">
                        </td>
                        <th scope="col" class="manage-column column-title column-primary"><?php esc_html_e('Name', 'latw-ai-translator-for-wpml'); ?></th>
                        <th scope="col" class="manage-column"><?php esc_html_e('Taxonomy', 'latw-ai-translator-for-wpml'); ?></th>
                        <th scope="col" class="manage-column"><?php esc_html_e('Slug', 'latw-ai-translator-for-wpml'); ?></th>
                        <th scope="col" class="manage-column"><?php esc_html_e('Posts', 'latw-ai-translator-for-wpml'); ?></th>
                        <th scope="col" class="manage-column column-source-lang"><?php esc_html_e('Source Language', 'latw-ai-translator-for-wpml'); ?></th>
                        <th scope="col" class="manage-column column-missing-langs"><?php esc_html_e('Missing Languages', 'latw-ai-translator-for-wpml'); ?></th>
                        <th scope="col" class="manage-column column-actions"><?php esc_html_e('Actions', 'latw-ai-translator-for-wpml'); ?></th>
                    </tr>
                </tfoot>
            </table>

            <!-- Pagination Bottom -->
            <?php if ($latwaitr_terms_data && $latwaitr_terms_data['total_pages'] > 1): ?>
            <div class="tablenav bottom">
                <div class="tablenav-pages">
                    <span class="displaying-num">
                        <?php
                        echo esc_html(
                            sprintf(
                                _n('%s item', '%s items', $latwaitr_terms_data['total_terms'], 'latw-ai-translator-for-wpml'),
                                number_format_i18n($latwaitr_terms_data['total_terms'])
                            )
                        );
                        ?>
                    </span>
                    <span class="pagination-links">
                        <?php if ($latwaitr_current_page > 1): ?>
                            <a class="first-page button" href="<?php echo esc_url($term_first_url); ?>"><span aria-hidden="true">«</span></a>
                            <a class="prev-page button" href="<?php echo esc_url($term_prev_url); ?>"><span aria-hidden="true">‹</span></a>
                        <?php else: ?>
                            <span class="tablenav-pages-navspan button disabled" aria-hidden="true">«</span>
                            <span class="tablenav-pages-navspan button disabled" aria-hidden="true">‹</span>
                        <?php endif; ?>
                        <span class="paging-input">
                            <span class="tablenav-paging-text">
                                <?php echo esc_html($latwaitr_current_page); ?>
                                <?php esc_html_e('of', 'latw-ai-translator-for-wpml'); ?>
                                <span class="total-pages"><?php echo esc_html($latwaitr_terms_data['total_pages']); ?></span>
                            </span>
                        </span>
                        <?php if ($latwaitr_current_page < $latwaitr_terms_data['total_pages']): ?>
                            <a class="next-page button" href="<?php echo esc_url($term_next_url); ?>"><span aria-hidden="true">›</span></a>
                            <a class="last-page button" href="<?php echo esc_url($term_last_url); ?>"><span aria-hidden="true">»</span></a>
                        <?php else: ?>
                            <span class="tablenav-pages-navspan button disabled" aria-hidden="true">›</span>
                            <span class="tablenav-pages-navspan button disabled" aria-hidden="true">»</span>
                        <?php endif; ?>
                    </span>
                </div>
            </div>
            <?php endif; ?>
        </div>

        <?php elseif ($latwaitr_current_tab_data || !empty($latwaitr_search_query)): ?>
        <div class="latwaitr-translations-panel">
            <!-- Search Box and Actions -->
            <div class="tablenav top">
                <?php if ($latwaitr_current_tab_data && !empty($latwaitr_current_tab_data['posts'])): ?>
                <div class="alignleft actions bulkactions">
                    <button type="button" class="button latwaitr-translate-selected" data-post-type="<?php echo esc_attr($latwaitr_current_tab); ?>">
                        <?php esc_html_e('Translate Selected', 'latw-ai-translator-for-wpml'); ?>
                    </button>
                </div>
                <?php endif; ?>

                <!-- Search Form -->
                <form method="get" class="search-box">
                    <input type="hidden" name="page" value="latwaitr-translations">
                    <input type="hidden" name="tab" value="<?php echo esc_attr($latwaitr_current_tab); ?>">
                    <label class="screen-reader-text" for="post-search-input"><?php esc_html_e('Search', 'latw-ai-translator-for-wpml'); ?></label>
                    <input type="search" id="post-search-input" name="s" value="<?php echo esc_attr($latwaitr_search_query); ?>" placeholder="<?php esc_attr_e('Search by title...', 'latw-ai-translator-for-wpml'); ?>">
                    <input type="submit" id="search-submit" class="button" value="<?php esc_attr_e('Search', 'latw-ai-translator-for-wpml'); ?>">
                    <?php if (!empty($latwaitr_search_query)): ?>
                        <a href="<?php echo esc_url(add_query_arg(array('page' => 'latwaitr-translations', 'tab' => $latwaitr_current_tab), admin_url('admin.php'))); ?>" class="button">
                            <?php esc_html_e('Clear', 'latw-ai-translator-for-wpml'); ?>
                        </a>
                    <?php endif; ?>
                </form>

                <!-- Pagination Top -->
                <?php if ($latwaitr_current_tab_data && $latwaitr_current_tab_data['total_pages'] > 1): ?>
                <div class="tablenav-pages">
                    <span class="displaying-num">
                        <?php
                        echo esc_html(
                            sprintf(
                            /* translators: %s: Number of items */
                                _n('%s item', '%s items', $latwaitr_current_tab_data['total_posts'], 'latw-ai-translator-for-wpml'),
                                number_format_i18n($latwaitr_current_tab_data['total_posts'])
                            )
                        );
                        ?>
                    </span>
                    <span class="pagination-links">
                        <?php
                        $latwaitr_pagination_args = array(
                            'page' => 'latwaitr-translations',
                            'tab' => $latwaitr_current_tab,
                        );
                        if (!empty($latwaitr_search_query)) {
                            $latwaitr_pagination_args['s'] = $latwaitr_search_query;
                        }

                        $latwaitr_first_page_url = add_query_arg(array_merge($latwaitr_pagination_args, array('paged' => 1)), admin_url('admin.php'));
                        $latwaitr_prev_page_url = add_query_arg(array_merge($latwaitr_pagination_args, array('paged' => max(1, $latwaitr_current_page - 1))), admin_url('admin.php'));
                        $latwaitr_next_page_url = add_query_arg(array_merge($latwaitr_pagination_args, array('paged' => min($latwaitr_current_tab_data['total_pages'], $latwaitr_current_page + 1))), admin_url('admin.php'));
                        $latwaitr_last_page_url = add_query_arg(array_merge($latwaitr_pagination_args, array('paged' => $latwaitr_current_tab_data['total_pages'])), admin_url('admin.php'));
                        ?>

                        <?php if ($latwaitr_current_page > 1): ?>
                            <a class="first-page button" href="<?php echo esc_url($latwaitr_first_page_url); ?>">
                                <span class="screen-reader-text"><?php esc_html_e('First page', 'latw-ai-translator-for-wpml'); ?></span>
                                <span aria-hidden="true">«</span>
                            </a>
                            <a class="prev-page button" href="<?php echo esc_url($latwaitr_prev_page_url); ?>">
                                <span class="screen-reader-text"><?php esc_html_e('Previous page', 'latw-ai-translator-for-wpml'); ?></span>
                                <span aria-hidden="true">‹</span>
                            </a>
                        <?php else: ?>
                            <span class="tablenav-pages-navspan button disabled" aria-hidden="true">«</span>
                            <span class="tablenav-pages-navspan button disabled" aria-hidden="true">‹</span>
                        <?php endif; ?>

                        <span class="paging-input">
                            <label for="current-page-selector" class="screen-reader-text"><?php esc_html_e('Current Page', 'latw-ai-translator-for-wpml'); ?></label>
                            <span class="tablenav-paging-text">
                                <?php echo esc_html($latwaitr_current_page); ?>
                                <?php esc_html_e('of', 'latw-ai-translator-for-wpml'); ?>
                                <span class="total-pages"><?php echo esc_html($latwaitr_current_tab_data['total_pages']); ?></span>
                            </span>
                        </span>

                        <?php if ($latwaitr_current_page < $latwaitr_current_tab_data['total_pages']): ?>
                            <a class="next-page button" href="<?php echo esc_url($latwaitr_next_page_url); ?>">
                                <span class="screen-reader-text"><?php esc_html_e('Next page', 'latw-ai-translator-for-wpml'); ?></span>
                                <span aria-hidden="true">›</span>
                            </a>
                            <a class="last-page button" href="<?php echo esc_url($latwaitr_last_page_url); ?>">
                                <span class="screen-reader-text"><?php esc_html_e('Last page', 'latw-ai-translator-for-wpml'); ?></span>
                                <span aria-hidden="true">»</span>
                            </a>
                        <?php else: ?>
                            <span class="tablenav-pages-navspan button disabled" aria-hidden="true">›</span>
                            <span class="tablenav-pages-navspan button disabled" aria-hidden="true">»</span>
                        <?php endif; ?>
                    </span>
                </div>
                <?php endif; ?>
            </div>

            <!-- Posts Table -->
            <table class="wp-list-table widefat fixed striped posts">
                <thead>
                    <tr>
                        <td id="cb" class="manage-column column-cb check-column">
                            <input type="checkbox" class="latwaitr-select-all-posts" data-post-type="<?php echo esc_attr($latwaitr_current_tab); ?>">
                        </td>
                        <th scope="col" class="manage-column column-title column-primary"><?php esc_html_e('Title', 'latw-ai-translator-for-wpml'); ?></th>
                        <th scope="col" class="manage-column column-status"><?php esc_html_e('Status', 'latw-ai-translator-for-wpml'); ?></th>
                        <th scope="col" class="manage-column column-source-lang"><?php esc_html_e('Source Language', 'latw-ai-translator-for-wpml'); ?></th>
                        <th scope="col" class="manage-column column-missing-langs"><?php esc_html_e('Missing Languages', 'latw-ai-translator-for-wpml'); ?></th>
                        <th scope="col" class="manage-column column-date"><?php esc_html_e('Last Modified', 'latw-ai-translator-for-wpml'); ?></th>
                        <th scope="col" class="manage-column column-actions"><?php esc_html_e('Actions', 'latw-ai-translator-for-wpml'); ?></th>
                    </tr>
                </thead>
                <tbody id="the-list">
                    <?php if (!$latwaitr_current_tab_data || empty($latwaitr_current_tab_data['posts'])): ?>
                    <tr class="no-items">
                        <td class="colspanchange" colspan="7">
                            <?php if (!empty($latwaitr_search_query)): ?>
                                <?php esc_html_e('No posts found matching your search.', 'latw-ai-translator-for-wpml'); ?>
                            <?php else: ?>
                                <?php esc_html_e('No posts need translation.', 'latw-ai-translator-for-wpml'); ?>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php else: ?>
                    <?php foreach ($latwaitr_current_tab_data['posts'] as $latwaitr_post): ?>
                    <tr>
                        <th scope="row" class="check-column">
                            <input type="checkbox" class="latwaitr-select-post" value="<?php echo esc_attr($latwaitr_post['id']); ?>" data-post-type="<?php echo esc_attr($latwaitr_current_tab); ?>">
                        </th>
                        <td class="title column-title column-primary" data-colname="<?php esc_attr_e('Title', 'latw-ai-translator-for-wpml'); ?>">
                            <strong>
                                <a href="<?php echo esc_url(get_edit_post_link($latwaitr_post['id'])); ?>" class="row-title">
                                    <?php echo esc_html($latwaitr_post['title']); ?>
                                </a>
                            </strong>
                            <div class="row-actions">
                                <span class="edit">
                                    <a href="<?php echo esc_url(get_edit_post_link($latwaitr_post['id'])); ?>"><?php esc_html_e('Edit', 'latw-ai-translator-for-wpml'); ?></a> |
                                </span>
                                <span class="view">
                                    <a href="<?php echo esc_url(get_permalink($latwaitr_post['id'])); ?>" target="_blank"><?php esc_html_e('View', 'latw-ai-translator-for-wpml'); ?></a>
                                </span>
                            </div>
                        </td>
                        <td class="status column-status" data-colname="<?php esc_attr_e('Status', 'latw-ai-translator-for-wpml'); ?>">
                            <?php if ($latwaitr_post['status'] === 'publish'): ?>
                                <span class="latwaitr-post-status latwaitr-post-status-publish">● <?php esc_html_e('Published', 'latw-ai-translator-for-wpml'); ?></span>
                            <?php else: ?>
                                <span class="latwaitr-post-status latwaitr-post-status-draft">● <?php esc_html_e('Draft', 'latw-ai-translator-for-wpml'); ?></span>
                            <?php endif; ?>
                        </td>
                        <td class="source-lang column-source-lang" data-colname="<?php esc_attr_e('Source Language', 'latw-ai-translator-for-wpml'); ?>">
                            <?php
                            $latwaitr_source_lang_name = isset($latwaitr_active_languages[$latwaitr_post['source_lang']]) ?
                                $latwaitr_active_languages[$latwaitr_post['source_lang']]['native_name'] :
                                $latwaitr_post['source_lang'];
                            echo esc_html($latwaitr_source_lang_name);
                            ?>
                        </td>
                        <td class="missing-langs column-missing-langs" data-colname="<?php esc_attr_e('Missing Languages', 'latw-ai-translator-for-wpml'); ?>">
                            <div class="latwaitr-language-checkboxes">
                                <label class="latwaitr-lang-checkbox-label latwaitr-lang-all">
                                    <input type="checkbox" class="latwaitr-select-all-langs" data-post-id="<?php echo esc_attr($latwaitr_post['id']); ?>" checked>
                                    <strong><?php esc_html_e('All Languages', 'latw-ai-translator-for-wpml'); ?></strong>
                                </label>
                                <?php foreach ($latwaitr_post['missing_languages'] as $latwaitr_lang_code): ?>
                                    <?php
                                    $latwaitr_display_lang_name = isset($latwaitr_active_languages[$latwaitr_lang_code]) ?
                                        $latwaitr_active_languages[$latwaitr_lang_code]['display_name'] :
                                        $latwaitr_lang_code;

                                    // Check if this language is queued
                                    $latwaitr_is_queued = isset($latwaitr_queued_languages[$latwaitr_post['id']][$latwaitr_lang_code]);
                                    $latwaitr_queue_status = $latwaitr_is_queued ? $latwaitr_queued_languages[$latwaitr_post['id']][$latwaitr_lang_code] : '';
                                    ?>
                                    <label class="latwaitr-lang-checkbox-label <?php echo $latwaitr_is_queued ? 'latwaitr-lang-disabled' : ''; ?>">
                                        <input type="checkbox" class="latwaitr-select-lang"
                                               data-post-id="<?php echo esc_attr($latwaitr_post['id']); ?>"
                                               data-lang-code="<?php echo esc_attr($latwaitr_lang_code); ?>"
                                               data-is-locked="0"
                                               <?php echo $latwaitr_is_queued ? 'disabled' : 'checked'; ?>>
                                        <?php echo esc_html($latwaitr_display_lang_name); ?>
                                        <?php if ($latwaitr_is_queued): ?>
                                            <?php if ($latwaitr_queue_status === 'queued'): ?>
                                                <span class="latwaitr-queue-indicator latwaitr-queue-queued">(⏳ <?php esc_html_e('Queued', 'latw-ai-translator-for-wpml'); ?>)</span>
                                            <?php elseif ($latwaitr_queue_status === 'in-progress'): ?>
                                                <span class="latwaitr-queue-indicator latwaitr-queue-progress">(⚙️ <?php esc_html_e('Translating...', 'latw-ai-translator-for-wpml'); ?>)</span>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </label>
                                <?php endforeach; ?>
                            </div>
                        </td>
                        <td class="date column-date" data-colname="<?php esc_attr_e('Last Modified', 'latw-ai-translator-for-wpml'); ?>">
                            <?php echo esc_html(wp_date('Y-m-d H:i', strtotime($latwaitr_post['modified']))); ?>
                        </td>
                        <td class="actions column-actions" data-colname="<?php esc_attr_e('Actions', 'latw-ai-translator-for-wpml'); ?>">
                            <button type="button" class="button latwaitr-translate-single" data-post-id="<?php echo esc_attr($latwaitr_post['id']); ?>">
                                <span class="dashicons dashicons-translation"></span>
                                <?php esc_html_e('Translate', 'latw-ai-translator-for-wpml'); ?>
                            </button>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
                <tfoot>
                    <tr>
                        <td class="manage-column column-cb check-column">
                            <input type="checkbox" class="latwaitr-select-all-posts" data-post-type="<?php echo esc_attr($latwaitr_current_tab); ?>">
                        </td>
                        <th scope="col" class="manage-column column-title column-primary"><?php esc_html_e('Title', 'latw-ai-translator-for-wpml'); ?></th>
                        <th scope="col" class="manage-column column-status"><?php esc_html_e('Status', 'latw-ai-translator-for-wpml'); ?></th>
                        <th scope="col" class="manage-column column-source-lang"><?php esc_html_e('Source Language', 'latw-ai-translator-for-wpml'); ?></th>
                        <th scope="col" class="manage-column column-missing-langs"><?php esc_html_e('Missing Languages', 'latw-ai-translator-for-wpml'); ?></th>
                        <th scope="col" class="manage-column column-date"><?php esc_html_e('Last Modified', 'latw-ai-translator-for-wpml'); ?></th>
                        <th scope="col" class="manage-column column-actions"><?php esc_html_e('Actions', 'latw-ai-translator-for-wpml'); ?></th>
                    </tr>
                </tfoot>
            </table>

            <!-- Pagination Bottom -->
            <?php if ($latwaitr_current_tab_data && $latwaitr_current_tab_data['total_pages'] > 1): ?>
            <div class="tablenav bottom">
                <div class="tablenav-pages">
                    <span class="displaying-num">
                        <?php
                        echo esc_html(
                            sprintf(
                            /* translators: %s: Number of items */
                                _n('%s item', '%s items', $latwaitr_current_tab_data['total_posts'], 'latw-ai-translator-for-wpml'),
                                number_format_i18n($latwaitr_current_tab_data['total_posts'])
                            )
                        );
                        ?>
                    </span>
                    <span class="pagination-links">
                        <?php if ($latwaitr_current_page > 1): ?>
                            <a class="first-page button" href="<?php echo esc_url($latwaitr_first_page_url); ?>">
                                <span class="screen-reader-text"><?php esc_html_e('First page', 'latw-ai-translator-for-wpml'); ?></span>
                                <span aria-hidden="true">«</span>
                            </a>
                            <a class="prev-page button" href="<?php echo esc_url($latwaitr_prev_page_url); ?>">
                                <span class="screen-reader-text"><?php esc_html_e('Previous page', 'latw-ai-translator-for-wpml'); ?></span>
                                <span aria-hidden="true">‹</span>
                            </a>
                        <?php else: ?>
                            <span class="tablenav-pages-navspan button disabled" aria-hidden="true">«</span>
                            <span class="tablenav-pages-navspan button disabled" aria-hidden="true">‹</span>
                        <?php endif; ?>

                        <span class="paging-input">
                            <span class="tablenav-paging-text">
                                <?php echo esc_html($latwaitr_current_page); ?>
                                <?php esc_html_e('of', 'latw-ai-translator-for-wpml'); ?>
                                <span class="total-pages"><?php echo esc_html($latwaitr_current_tab_data['total_pages']); ?></span>
                            </span>
                        </span>

                        <?php if ($latwaitr_current_page < $latwaitr_current_tab_data['total_pages']): ?>
                            <a class="next-page button" href="<?php echo esc_url($latwaitr_next_page_url); ?>">
                                <span class="screen-reader-text"><?php esc_html_e('Next page', 'latw-ai-translator-for-wpml'); ?></span>
                                <span aria-hidden="true">›</span>
                            </a>
                            <a class="last-page button" href="<?php echo esc_url($latwaitr_last_page_url); ?>">
                                <span class="screen-reader-text"><?php esc_html_e('Last page', 'latw-ai-translator-for-wpml'); ?></span>
                                <span aria-hidden="true">»</span>
                            </a>
                        <?php else: ?>
                            <span class="tablenav-pages-navspan button disabled" aria-hidden="true">›</span>
                            <span class="tablenav-pages-navspan button disabled" aria-hidden="true">»</span>
                        <?php endif; ?>
                    </span>
                </div>
            </div>
            <?php endif; ?>
        </div>
        <?php endif; ?>

        <?php endif; ?>
    <?php endif; ?>
</div>

<!-- Translate Again Modal -->
<div id="latwaitr-translate-again-modal" class="latwaitr-modal" style="display: none;">
    <div class="latwaitr-modal-overlay"></div>
    <div class="latwaitr-modal-content">
        <div class="latwaitr-modal-header">
            <h2><?php esc_html_e('Translate Again', 'latw-ai-translator-for-wpml'); ?></h2>
            <button type="button" class="latwaitr-modal-close">&times;</button>
        </div>
        <div class="latwaitr-modal-body">
            <div class="latwaitr-modal-step-1">
                <p><?php esc_html_e('Select post type to retranslate:', 'latw-ai-translator-for-wpml'); ?></p>
                <div style="margin-bottom: 20px;">
                    <label for="latwaitr-retranslate-post-type" style="display: block; margin-bottom: 5px; font-weight: 600;">
                        <?php esc_html_e('Post Type:', 'latw-ai-translator-for-wpml'); ?>
                    </label>
                    <select id="latwaitr-retranslate-post-type" class="regular-text" style="width: 100%; max-width: 400px;">
                        <option value=""><?php esc_html_e('-- Select Post Type --', 'latw-ai-translator-for-wpml'); ?></option>
                        <?php
                        $latwaitr_modal_post_types = get_post_types(array('public' => true), 'objects');
                        foreach ($latwaitr_modal_post_types as $latwaitr_pt):
                        ?>
                            <option value="<?php echo esc_attr($latwaitr_pt->name); ?>">
                                <?php echo esc_html($latwaitr_pt->label); ?>
                            </option>
                        <?php endforeach; ?>
                        <option value="categories"><?php esc_html_e('Categories', 'latw-ai-translator-for-wpml'); ?></option>
                    </select>
                </div>
                <button type="button" class="button button-primary" id="latwaitr-load-translated-posts">
                    <?php esc_html_e('Load Posts', 'latw-ai-translator-for-wpml'); ?>
                </button>
            </div>

            <div class="latwaitr-modal-step-2" style="display: none;">
                <div id="latwaitr-retranslate-posts-container">
                    <p><?php esc_html_e('Loading posts...', 'latw-ai-translator-for-wpml'); ?></p>
                </div>
                <div style="margin-top: 20px; display: flex; gap: 10px;">
                    <button type="button" class="button button-primary" id="latwaitr-retranslate-selected">
                        <?php esc_html_e('Translate Selected', 'latw-ai-translator-for-wpml'); ?>
                    </button>
                    <button type="button" class="button" id="latwaitr-retranslate-back">
                        <?php esc_html_e('Back', 'latw-ai-translator-for-wpml'); ?>
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>
