<?php
if (!defined('ABSPATH')) exit;
?>
<div class="wrap">
    <h1><?php esc_html_e('System Logs', 'latw-ai-translator-for-wpml'); ?></h1>
    <p><?php esc_html_e('Recent translation logs and debug information', 'latw-ai-translator-for-wpml'); ?></p>

    <div class="latwaitr-logs-container" style="background: #fff; padding: 20px; border: 1px solid #ccd0d4; border-radius: 4px; margin-top: 20px;">
        <?php if (!empty($latwaitr_logs)): ?>
            <div style="margin-bottom: 15px;">
                <strong><?php esc_html_e('Log File:', 'latw-ai-translator-for-wpml'); ?></strong>
                <code><?php echo esc_html($latwaitr_logger->get_log_file()); ?></code>
            </div>

            <div style="background: #23282d; color: #f8f9fa; padding: 15px; font-family: 'Courier New', monospace; font-size: 12px; overflow-x: auto; max-height: 600px; overflow-y: auto; border-radius: 4px;">
                <?php foreach ($latwaitr_logs as $latwaitr_log_line): ?>
                    <?php
                    // Color code log levels
                    $latwaitr_class = '';
                    if (stripos($latwaitr_log_line, '[ERROR]') !== false) {
                        $latwaitr_class = 'style="color: #ff6b6b;"';
                    } elseif (stripos($latwaitr_log_line, '[WARNING]') !== false) {
                        $latwaitr_class = 'style="color: #ffd93d;"';
                    } elseif (stripos($latwaitr_log_line, '[INFO]') !== false) {
                        $latwaitr_class = 'style="color: #6bcf7f;"';
                    } elseif (stripos($latwaitr_log_line, '[DEBUG]') !== false) {
                        $latwaitr_class = 'style="color: #95a5a6;"';
                    }
                    ?>
                    <div <?php echo esc_attr($latwaitr_class); ?>><?php echo esc_html($latwaitr_log_line); ?></div>
                <?php endforeach; ?>
            </div>

            <div style="margin-top: 15px;">
                <p class="description">
                    <?php
                    /* translators: %d: Number of log entries */
                    printf(esc_html__('Showing last %d log entries', 'latw-ai-translator-for-wpml'), count($latwaitr_logs));
                    ?>
                </p>
            </div>
        <?php else: ?>
            <p style="color: #666; font-style: italic;">
                <?php esc_html_e('No logs found. Logs will appear here after translation operations.', 'latw-ai-translator-for-wpml'); ?>
            </p>
            <p class="description">
                <?php esc_html_e('Log File:', 'latw-ai-translator-for-wpml'); ?>
                <code><?php echo esc_html($latwaitr_logger->get_log_file()); ?></code>
            </p>
        <?php endif; ?>
    </div>
</div>
